/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.db.input.es;

import com.frameworkset.util.SimpleStringUtil;
import org.frameworkset.tran.DataStream;
import org.frameworkset.tran.ExportResultHandler;
import org.frameworkset.tran.WrapedExportResultHandler;
import org.frameworkset.tran.config.BaseImportBuilder;
import org.frameworkset.tran.db.DBImportConfig;
import org.frameworkset.tran.db.input.es.DB2ESDataStreamImpl;
import org.frameworkset.tran.es.ESExportResultHandler;

public class DB2ESImportBuilder
extends BaseImportBuilder {
    protected String sqlFilepath;
    protected String sql;
    protected String sqlName;

    protected DB2ESImportBuilder() {
    }

    public DB2ESImportBuilder setShowSql(boolean showSql) {
        this._setShowSql(showSql);
        return this;
    }

    public String getSql() {
        return this.sql;
    }

    public static DB2ESImportBuilder newInstance() {
        return new DB2ESImportBuilder();
    }

    public DB2ESImportBuilder setSql(String sql) {
        this.sql = sql;
        return this;
    }

    @Override
    public DataStream builder() {
        super.builderConfig();
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("DB2ES Import Configs:");
                this.logger.info(this.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        DBImportConfig importConfig = new DBImportConfig();
        super.buildImportConfig(importConfig);
        importConfig.setSqlFilepath(this.sqlFilepath);
        importConfig.setSqlName(this.sqlName);
        if (SimpleStringUtil.isNotEmpty((String)this.sql)) {
            importConfig.setSql(this.sql);
        }
        DB2ESDataStreamImpl dataStream = new DB2ESDataStreamImpl();
        dataStream.setImportConfig(importConfig);
        dataStream.setConfigString(this.toString());
        dataStream.init();
        return dataStream;
    }

    public DB2ESImportBuilder setSqlFilepath(String sqlFilepath) {
        this.sqlFilepath = sqlFilepath;
        return this;
    }

    public String getSqlName() {
        return this.sqlName;
    }

    public DB2ESImportBuilder setSqlName(String sqlName) {
        this.sqlName = sqlName;
        return this;
    }

    @Override
    protected WrapedExportResultHandler buildExportResultHandler(ExportResultHandler exportResultHandler) {
        ESExportResultHandler db2ESExportResultHandler = new ESExportResultHandler(exportResultHandler);
        return db2ESExportResultHandler;
    }
}

