/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.db.input.db;

import com.frameworkset.common.poolman.ConfigSQLExecutor;
import com.frameworkset.common.poolman.SQLExecutor;
import com.frameworkset.common.poolman.handle.NullRowHandler;
import com.frameworkset.common.poolman.handle.ResultSetHandler;
import com.frameworkset.orm.transaction.TransactionManager;
import java.sql.SQLException;
import java.util.List;
import org.frameworkset.persitent.util.SQLInfo;
import org.frameworkset.tran.DataTranPlugin;
import org.frameworkset.tran.ESDataImportException;
import org.frameworkset.tran.SQLBaseDataTranPlugin;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.db.input.db.DB2DBContext;
import org.frameworkset.tran.db.input.db.DB2DBResultSetHandler;
import org.frameworkset.tran.util.TranUtil;
import org.frameworkset.util.tokenizer.TextGrammarParser;

public class DB2DBDataTranPlugin
extends SQLBaseDataTranPlugin
implements DataTranPlugin {
    private DB2DBContext db2DBContext;

    public DB2DBDataTranPlugin(ImportContext importContext) {
        super(importContext);
    }

    @Override
    protected void init(ImportContext importContext) {
        this.db2DBContext = (DB2DBContext)((Object)importContext);
        super.init(importContext);
    }

    @Override
    public void initStatusTableId() {
        if (this.isIncreamentImport() && this.dbContext.getSql() != null && !this.dbContext.getSql().equals("")) {
            this.importContext.setStatusTableId(this.dbContext.getSql().hashCode());
        }
    }

    public void initSourceSQLInfo() {
        if ((this.dbContext.getSql() == null || this.dbContext.getSql().equals("")) && this.dbContext.getSqlFilepath() != null && !this.dbContext.getSqlFilepath().equals("")) {
            try {
                ConfigSQLExecutor executor = new ConfigSQLExecutor(this.dbContext.getSqlFilepath());
                SQLInfo sqlInfo = executor.getSqlInfo(this.importContext.getDbConfig().getDbName(), this.dbContext.getSqlName());
                this.executor = executor;
                this.dbContext.setSql(sqlInfo.getSql());
            }
            catch (SQLException e) {
                throw new ESDataImportException(e);
            }
        }
        if (this.dbContext.getSql() != null && !this.dbContext.getSql().equals("")) {
            this.initSQLInfoParams();
        }
    }

    private void initSQLInfoParams() {
        String originSQL = this.dbContext.getSql();
        List tokens = TextGrammarParser.parser((String)originSQL, (String)"#[", (String)"]");
        org.frameworkset.tran.schedule.SQLInfo _sqlInfo = new org.frameworkset.tran.schedule.SQLInfo();
        int paramSize = 0;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < tokens.size(); ++i) {
            TextGrammarParser.GrammarToken token = (TextGrammarParser.GrammarToken)tokens.get(i);
            if (token.texttoken()) {
                builder.append(token.getText());
                continue;
            }
            builder.append("?");
            if (paramSize == 0) {
                _sqlInfo.setLastValueVarName(token.getText());
            }
            ++paramSize;
        }
        _sqlInfo.setParamSize(paramSize);
        _sqlInfo.setSql(builder.toString());
        this.sqlInfo = _sqlInfo;
    }

    public org.frameworkset.tran.schedule.SQLInfo getSqlInfo() {
        return this.sqlInfo;
    }

    @Override
    public void beforeInit() {
        this.initDS(this.importContext.getDbConfig());
        this.initDS(this.db2DBContext.getTargetDBConfig());
        this.initSourceSQLInfo();
        TranUtil.initTargetSQLInfo(this.db2DBContext, this.db2DBContext.getTargetDBConfig(), this.db2DBContext.getInsertSqlName());
    }

    @Override
    public String getLastValueVarName() {
        return this.sqlInfo != null ? this.sqlInfo.getLastValueVarName() : null;
    }

    private void commonImportData(ResultSetHandler resultSetHandler) throws Exception {
        if (this.importContext.getDataRefactor() == null || !this.importContext.getDbConfig().isEnableDBTransaction()) {
            if (this.executor == null) {
                SQLExecutor.queryWithDBNameByNullRowHandler((NullRowHandler)resultSetHandler, (String)this.importContext.getDbConfig().getDbName(), (String)this.dbContext.getSql(), (Object[])new Object[0]);
            } else {
                this.executor.queryWithDBNameByNullRowHandler((NullRowHandler)resultSetHandler, this.importContext.getDbConfig().getDbName(), this.dbContext.getSqlName(), new Object[0]);
            }
        } else {
            TransactionManager transactionManager = new TransactionManager();
            try {
                transactionManager.begin(TransactionManager.RW_TRANSACTION);
                if (this.executor == null) {
                    SQLExecutor.queryWithDBNameByNullRowHandler((NullRowHandler)resultSetHandler, (String)this.importContext.getDbConfig().getDbName(), (String)this.dbContext.getSql(), (Object[])new Object[0]);
                } else {
                    this.executor.queryWithDBNameByNullRowHandler((NullRowHandler)resultSetHandler, this.importContext.getDbConfig().getDbName(), this.dbContext.getSqlName(), new Object[0]);
                }
                transactionManager.commit();
            }
            finally {
                transactionManager.releasenolog();
            }
        }
    }

    private void increamentImportData(ResultSetHandler resultSetHandler) throws Exception {
        if (this.importContext.getDataRefactor() == null || !this.importContext.getDbConfig().isEnableDBTransaction()) {
            if (this.executor == null) {
                SQLExecutor.queryBeanWithDBNameByNullRowHandler((NullRowHandler)resultSetHandler, (String)this.importContext.getDbConfig().getDbName(), (String)this.dbContext.getSql(), (Object)this.getParamValue());
            } else {
                this.executor.queryBeanWithDBNameByNullRowHandler((NullRowHandler)resultSetHandler, this.importContext.getDbConfig().getDbName(), this.dbContext.getSqlName(), (Object)this.getParamValue());
            }
        } else {
            TransactionManager transactionManager = new TransactionManager();
            try {
                transactionManager.begin(TransactionManager.RW_TRANSACTION);
                if (this.executor == null) {
                    SQLExecutor.queryBeanWithDBNameByNullRowHandler((NullRowHandler)resultSetHandler, (String)this.importContext.getDbConfig().getDbName(), (String)this.dbContext.getSql(), (Object)this.getParamValue());
                } else {
                    this.executor.queryBeanWithDBNameByNullRowHandler((NullRowHandler)resultSetHandler, this.importContext.getDbConfig().getDbName(), this.dbContext.getSqlName(), (Object)this.getParamValue());
                }
            }
            finally {
                transactionManager.releasenolog();
            }
        }
    }

    @Override
    public void doImportData() throws ESDataImportException {
        DB2DBResultSetHandler resultSetHandler = new DB2DBResultSetHandler(this.importContext);
        try {
            if (this.sqlInfo.getParamSize() == 0) {
                this.commonImportData(resultSetHandler);
            } else if (!this.isIncreamentImport()) {
                this.setForceStop();
            } else {
                this.increamentImportData(resultSetHandler);
            }
        }
        catch (ESDataImportException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ESDataImportException(e);
        }
    }
}

