/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.frameworkset.tran.ESDataImportException;
import org.frameworkset.tran.config.BaseImportConfig;
import org.frameworkset.tran.context.ImportContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataStream {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ImportContext importContext;
    protected BaseImportConfig importConfig;
    private boolean inited;
    private Lock lock = new ReentrantLock();
    private String configString;

    protected abstract ImportContext buildImportContext(BaseImportConfig var1);

    public void setImportConfig(BaseImportConfig importConfig) {
        this.importConfig = importConfig;
    }

    public void execute() throws ESDataImportException {
        try {
            this.init();
            this.importContext.importData();
        }
        catch (Exception e) {
            throw new ESDataImportException(e);
        }
    }

    public void destroy() {
        if (this.importContext != null) {
            this.importContext.destroy();
        }
    }

    public String getConfigString() {
        return this.configString;
    }

    public void setConfigString(String configString) {
        this.configString = configString;
    }

    public void init() {
        if (this.inited) {
            this.importContext.resume();
            return;
        }
        if (this.importConfig == null) {
            throw new ESDataImportException("import Config is null.");
        }
        try {
            this.lock.lock();
            this.importContext = this.buildImportContext(this.importConfig);
            this.inited = true;
        }
        catch (Exception e) {
            this.inited = true;
            throw new ESDataImportException(e);
        }
        finally {
            this.lock.unlock();
        }
    }
}

