/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran;

import java.util.Date;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.frameworkset.tran.AsynTranResultSet;
import org.frameworkset.tran.Data;
import org.frameworkset.tran.DefaultTranMetaData;
import org.frameworkset.tran.ESDataImportException;
import org.frameworkset.tran.Record;
import org.frameworkset.tran.TranMeta;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.util.TranUtil;

public abstract class AsynBaseTranResultSet<T extends Data>
implements AsynTranResultSet<T> {
    private Record record;
    private List<Object> records;
    private int pos = 0;
    private int size;
    public static int STATUS_STOP = 1;
    private int status;
    private BlockingQueue<T> queue;
    protected ImportContext importContext;
    private boolean reachEnd;

    public AsynBaseTranResultSet(ImportContext importContext) {
        this.queue = new ArrayBlockingQueue<T>(importContext.getTranDataBufferQueue());
        this.importContext = importContext;
    }

    protected abstract Record buildRecord(Object var1);

    @Override
    public void appendData(T datas) {
        try {
            this.queue.put(datas);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Object getValue(int i, String colName, int sqlType) throws ESDataImportException {
        return this.getValue(colName);
    }

    @Override
    public Object getValue(String colName) throws ESDataImportException {
        return this.record.getValue(colName);
    }

    @Override
    public Object getValue(String colName, int sqlType) throws ESDataImportException {
        return this.getValue(colName);
    }

    @Override
    public Object getMetaValue(String fieldName) {
        return this.record.getMetaValue(fieldName);
    }

    @Override
    public Date getDateTimeValue(String colName) throws ESDataImportException {
        Object value = this.getValue(colName);
        if (value == null) {
            return null;
        }
        return TranUtil.getDateTimeValue(colName, value, this.importContext);
    }

    @Override
    public void stop() {
        this.status = STATUS_STOP;
    }

    public void reachEend() {
        this.reachEnd = true;
    }

    @Override
    public Boolean next() throws ESDataImportException {
        if (this.pos < this.size) {
            this.record = this.buildRecord(this.records.get(this.pos));
            ++this.pos;
            return true;
        }
        if (this.status == STATUS_STOP) {
            return false;
        }
        try {
            Data datas = (Data)this.queue.poll(this.importContext.getAsynResultPollTimeOut(), TimeUnit.MILLISECONDS);
            if (this.status == STATUS_STOP) {
                return false;
            }
            if (datas != null) {
                this.records = datas.getDatas();
                int n = this.size = this.records != null ? this.records.size() : 0;
            }
            if (datas == null || this.size == 0) {
                long pollStartTime = System.currentTimeMillis();
                while (true) {
                    datas = (Data)this.queue.poll(this.importContext.getAsynResultPollTimeOut(), TimeUnit.MILLISECONDS);
                    if (this.status == STATUS_STOP) {
                        return false;
                    }
                    if (datas == null) {
                        long interval;
                        if (this.reachEnd) break;
                        if (this.importContext.getFlushInterval() <= 0L || (interval = System.currentTimeMillis() - pollStartTime) <= this.importContext.getFlushInterval()) continue;
                        return null;
                    }
                    this.records = datas.getDatas();
                    int n = this.size = this.records != null ? this.records.size() : 0;
                    if (this.size > 0) break;
                }
                if (datas == null && this.reachEnd) {
                    return false;
                }
            }
            this.pos = 0;
            this.record = this.buildRecord(this.records.get(this.pos));
            ++this.pos;
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public TranMeta getMetaData() {
        return new DefaultTranMetaData(this.record.getKeys());
    }

    @Override
    public Object getRecord() {
        return this.record.getData();
    }
}

