/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client.schedule;

import com.frameworkset.common.poolman.SQLExecutor;
import com.frameworkset.common.poolman.StatementInfo;
import com.frameworkset.common.poolman.handle.NullRowHandler;
import com.frameworkset.common.poolman.handle.ResultSetHandler;
import com.frameworkset.common.poolman.util.SQLUtil;
import java.io.File;
import java.sql.ResultSet;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.frameworkset.elasticsearch.client.ESDataImportException;
import org.frameworkset.elasticsearch.client.ESJDBC;
import org.frameworkset.elasticsearch.client.JDBCRestClientUtil;
import org.frameworkset.elasticsearch.client.schedule.SQLInfo;
import org.frameworkset.elasticsearch.client.schedule.Status;
import org.frameworkset.elasticsearch.client.schedule.StoreStatusTask;
import org.frameworkset.util.tokenizer.TextGrammarParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleService {
    private static Logger logger = LoggerFactory.getLogger(ScheduleService.class);
    private volatile Status currentStatus;
    private volatile Status firstStatus;
    private volatile boolean insertedCheck = false;
    private Lock insertedCheckLock = new ReentrantLock();
    private ESJDBC esjdbc;
    private String updateSQL;
    private String insertSQL;
    private String selectSQL;
    private String existSQL;
    private int lastValueType = 0;
    private int id = 1;
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private Date initLastDate = null;
    private String dbname;
    private String statusTableName;
    private StoreStatusTask storeStatusTask;
    private SQLInfo sqlInfo;
    private Timer timer;

    public SQLInfo getSqlInfo() {
        return this.sqlInfo;
    }

    public void addStatus(Status currentStatus) throws Exception {
        SQLExecutor.insertWithDBName((String)this.dbname, (String)this.insertSQL, (Object[])new Object[]{currentStatus.getId(), currentStatus.getTime(), currentStatus.getLastValue(), this.lastValueType});
    }

    public void updateStatus(Status currentStatus) throws Exception {
        SQLExecutor.updateWithDBName((String)this.dbname, (String)this.updateSQL, (Object[])new Object[]{currentStatus.getTime(), currentStatus.getLastValue(), this.lastValueType, currentStatus.getId()});
    }

    private void initLastValueStatus(boolean update) throws Exception {
        Status currentStatus = new Status();
        currentStatus.setId(this.id);
        currentStatus.setTime(new Date().getTime());
        if (this.lastValueType == 1) {
            currentStatus.setLastValue(this.initLastDate.getTime());
        } else if (this.esjdbc.getImportIncreamentConfig().getLastValue() != null) {
            currentStatus.setLastValue(this.esjdbc.getImportIncreamentConfig().getLastValue());
        } else {
            currentStatus.setLastValue(0);
        }
        currentStatus.setLastValueType(this.lastValueType);
        if (!update) {
            this.addStatus(currentStatus);
        } else {
            this.updateStatus(currentStatus);
        }
        this.currentStatus = currentStatus;
        this.firstStatus = (Status)currentStatus.clone();
        this.insertedCheck = true;
        logger.info("init LastValue Status: " + currentStatus.toString());
    }

    private void scheduleImportData(final int batchSize) throws Exception {
        if (!this.esjdbc.assertCondition()) {
            if (logger.isWarnEnabled()) {
                logger.warn("Task Assert Execute Condition Failed, Ignore");
            }
            return;
        }
        SQLInfo sqlInfo = this.getLastValueSQL();
        ResultSetHandler resultSetHandler = new ResultSetHandler(){

            public void handleResult(ResultSet resultSet, StatementInfo statementInfo) throws Exception {
                ScheduleService.this.esjdbc.setResultSet(resultSet);
                ScheduleService.this.esjdbc.setMetaData(statementInfo.getMeta());
                JDBCRestClientUtil jdbcRestClientUtil = new JDBCRestClientUtil();
                jdbcRestClientUtil.addDocuments(ScheduleService.this.esjdbc.getIndex(), ScheduleService.this.esjdbc.getIndexType(), ScheduleService.this.esjdbc, ScheduleService.this.esjdbc.getRefreshOption(), batchSize);
            }
        };
        if (sqlInfo.getParamSize() == 0) {
            SQLExecutor.queryWithDBNameByNullRowHandler((NullRowHandler)resultSetHandler, (String)this.esjdbc.getDbName(), (String)this.esjdbc.getSql(), (Object[])new Object[0]);
        } else {
            SQLExecutor.queryBeanWithDBNameByNullRowHandler((NullRowHandler)resultSetHandler, (String)this.esjdbc.getDbName(), (String)this.esjdbc.getSql(), (Object)this.getParamValue());
        }
    }

    public void timeSchedule() throws Exception {
        this.timer = new Timer();
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    ScheduleService.this.scheduleImportData(ScheduleService.this.esjdbc.getScheduleBatchSize());
                }
                catch (Exception e) {
                    logger.error("scheduleImportData failed:", (Throwable)e);
                }
            }
        };
        Date scheduleDate = this.esjdbc.getScheduleConfig().getScheduleDate();
        Long delay = this.esjdbc.getScheduleConfig().getDeyLay();
        if (scheduleDate != null) {
            if (this.esjdbc.getScheduleConfig().getFixedRate() != null && this.esjdbc.getScheduleConfig().getFixedRate().booleanValue()) {
                this.timer.scheduleAtFixedRate(timerTask, scheduleDate, (long)this.esjdbc.getScheduleConfig().getPeriod());
            } else if (this.esjdbc.getScheduleConfig().getPeriod() != null) {
                this.timer.schedule(timerTask, scheduleDate, (long)this.esjdbc.getScheduleConfig().getPeriod());
            } else {
                this.timer.schedule(timerTask, scheduleDate);
            }
        } else {
            if (delay == null) {
                delay = 1000L;
            }
            if (this.esjdbc.getScheduleConfig().getFixedRate() != null && this.esjdbc.getScheduleConfig().getFixedRate().booleanValue()) {
                this.timer.scheduleAtFixedRate(timerTask, delay, (long)this.esjdbc.getScheduleConfig().getPeriod());
            } else if (this.esjdbc.getScheduleConfig().getPeriod() != null) {
                this.timer.schedule(timerTask, delay, (long)this.esjdbc.getScheduleConfig().getPeriod());
            } else {
                this.timer.schedule(timerTask, delay);
            }
        }
    }

    public void storeStatus() {
        try {
            this.updateStatus(this.currentStatus);
        }
        catch (Exception e) {
            throw new ESDataImportException(e);
        }
    }

    private void assertCondition() {
        this.statusTableName = this.esjdbc.getImportIncreamentConfig().getLastValueStoreTableName();
        if (this.statusTableName == null) {
            this.statusTableName = "increament_tab";
        }
        if (this.esjdbc.getImportIncreamentConfig().getLastValueStorePath() == null) {
            throw new ESDataImportException("Must set lastValueStorePath by ImportBuilder.");
        }
    }

    private void initDatasource() {
        this.dbname = this.esjdbc.getDbName() + "_config";
        String dbJNDIName = this.esjdbc.getDbName() + "_config";
        try {
            File dbpath = new File(this.esjdbc.getImportIncreamentConfig().getLastValueStorePath());
            logger.info("initDatasource dbpath:" + dbpath.getCanonicalPath());
            SQLUtil.startPool((String)this.dbname, (String)"org.sqlite.JDBC", (String)("jdbc:sqlite://" + dbpath.getCanonicalPath()), (String)"root", (String)"root", null, null, (String)"select 1", (String)dbJNDIName, (int)10, (int)10, (int)20, (boolean)true, (boolean)false, null, (boolean)false, (boolean)false);
        }
        catch (Exception e) {
            throw new ESDataImportException(e);
        }
        this.lastValueType = this.esjdbc.getImportIncreamentConfig().getDateLastValueColumn() != null ? 1 : (this.esjdbc.getImportIncreamentConfig().getNumberLastValueColumn() != null ? 0 : (this.esjdbc.getImportIncreamentConfig().getLastValueType() != null ? this.esjdbc.getImportIncreamentConfig().getLastValueType() : 0));
        this.existSQL = "select 1 from " + this.statusTableName;
        this.selectSQL = "select id,lasttime,lastvalue,lastvaluetype from " + this.statusTableName + " where id=?";
        this.updateSQL = "update " + this.statusTableName + " set lasttime = ?,lastvalue = ? ,lastvaluetype= ? where id=?";
        this.insertSQL = "insert into " + this.statusTableName + " (id,lasttime,lastvalue,lastvaluetype) values(?,?,?,?)";
    }

    public void updateStatus(long time, Object currentValue) {
        this.currentStatus.setTime(time);
        this.currentStatus.setLastValue(currentValue);
    }

    private void initTableAndStatus() {
        try {
            this.initLastDate = this.dateFormat.parse("1970-01-01");
            SQLExecutor.queryObjectWithDBName(Integer.TYPE, (String)this.dbname, (String)this.existSQL, (Object[])new Object[0]);
        }
        catch (Exception e) {
            String tsql = "create table " + this.statusTableName + " (ID number(2),lasttime number(10),lastvalue number(10),lastvaluetype number(1),PRIMARY KEY (ID))";
            logger.info(this.statusTableName + " table \u4e0d\u5b58\u5728\uff0c" + this.statusTableName + "\uff1a" + tsql + "\u3002");
            try {
                SQLExecutor.updateWithDBName((String)this.dbname, (String)tsql, (Object[])new Object[0]);
                logger.info("\u521b\u5efa" + this.statusTableName + "\u8868\u6210\u529f\uff1a" + tsql + "\u3002");
            }
            catch (Exception e1) {
                logger.info("\u521b\u5efa" + this.statusTableName + "\u8868\u5931\u8d25\uff1a" + tsql + "\u3002", (Throwable)e1);
                throw new ESDataImportException(e1);
            }
        }
        try {
            this.currentStatus = (Status)SQLExecutor.queryObjectWithDBName(Status.class, (String)this.dbname, (String)this.selectSQL, (Object[])new Object[]{this.id});
            if (this.currentStatus == null) {
                this.initLastValueStatus(false);
            } else if (this.esjdbc.getImportIncreamentConfig().isFromFirst()) {
                this.initLastValueStatus(true);
            } else {
                this.firstStatus = (Status)this.currentStatus.clone();
            }
        }
        catch (Exception e) {
            throw new ESDataImportException(e);
        }
    }

    private void startStoreStatusTask() {
        this.storeStatusTask = new StoreStatusTask(this);
        this.storeStatusTask.start();
    }

    public void init(ESJDBC esjdbc) {
        this.esjdbc = esjdbc;
        this.assertCondition();
        this.initDatasource();
        this.initTableAndStatus();
        this.esjdbc.setScheduleService(this);
    }

    public SQLInfo getLastValueSQL() {
        if (this.sqlInfo == null) {
            String originSQL = this.esjdbc.getSql();
            List tokens = TextGrammarParser.parser((String)originSQL, (String)"#[", (String)"]");
            SQLInfo _sqlInfo = new SQLInfo();
            int paramSize = 0;
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < tokens.size(); ++i) {
                TextGrammarParser.GrammarToken token = (TextGrammarParser.GrammarToken)tokens.get(i);
                if (token.texttoken()) {
                    builder.append(token.getText());
                    continue;
                }
                builder.append("?");
                if (paramSize == 0) {
                    _sqlInfo.setLastValueVarName(token.getText());
                }
                ++paramSize;
            }
            _sqlInfo.setParamSize(paramSize);
            _sqlInfo.setSql(builder.toString());
            this.sqlInfo = _sqlInfo;
        }
        return this.sqlInfo;
    }

    public Map getParamValue() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.lastValueType == 0) {
            params.put(this.sqlInfo.getLastValueVarName(), this.currentStatus.getLastValue());
        } else if (this.currentStatus.getLastValue() instanceof Date) {
            params.put(this.sqlInfo.getLastValueVarName(), this.currentStatus.getLastValue());
        } else {
            params.put(this.sqlInfo.getLastValueVarName(), new Date((Long)this.currentStatus.getLastValue()));
        }
        return params;
    }

    public void stop() {
        this.timer.cancel();
        try {
            SQLUtil.stopPool((String)this.dbname);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    public void flushLastValue(Object lastValue) {
        this.currentStatus.setTime(System.currentTimeMillis());
        this.currentStatus.setLastValue(lastValue);
        this.storeStatus();
    }

    public Status getFirstStatus() {
        return this.firstStatus;
    }

    public void setFirstStatus(Status firstStatus) {
        this.firstStatus = firstStatus;
    }
}

