/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import org.apache.http.client.ResponseHandler;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.client.ESJDBC;
import org.frameworkset.elasticsearch.client.ErrorWrapper;
import org.frameworkset.elasticsearch.client.TaskFailedException;
import org.frameworkset.elasticsearch.handler.ESVoidResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCall
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(TaskCall.class);
    private String refreshOption;
    private ClientInterface clientInterface;
    private String datas;
    private ErrorWrapper errorWrapper;
    private int taskNo;

    public TaskCall(String refreshOption, String datas, ErrorWrapper errorWrapper, int taskNo) {
        this.refreshOption = refreshOption;
        this.clientInterface = errorWrapper.getClientInterface();
        this.datas = datas;
        this.errorWrapper = errorWrapper;
        this.taskNo = taskNo;
    }

    public static String call(String refreshOption, ClientInterface clientInterface, String datas, ESJDBC esjdbc) {
        if (esjdbc.isDebugResponse()) {
            String data = null;
            if (refreshOption == null) {
                data = clientInterface.executeHttp("_bulk", datas, "post");
                logger.info(data);
            } else {
                data = clientInterface.executeHttp("_bulk?" + refreshOption, datas, "post");
                logger.info(data);
            }
            return data;
        }
        if (esjdbc.isDiscardBulkResponse()) {
            ESVoidResponseHandler esVoidResponseHandler = new ESVoidResponseHandler();
            if (refreshOption == null) {
                clientInterface.executeHttp("_bulk", datas, "post", (ResponseHandler)esVoidResponseHandler);
            } else {
                clientInterface.executeHttp("_bulk?" + refreshOption, datas, "post", (ResponseHandler)esVoidResponseHandler);
            }
            if (esVoidResponseHandler.getElasticSearchException() != null) {
                throw esVoidResponseHandler.getElasticSearchException();
            }
            return null;
        }
        String data = null;
        data = refreshOption == null ? clientInterface.executeHttp("_bulk", datas, "post") : clientInterface.executeHttp("_bulk?" + refreshOption, datas, "post");
        return data;
    }

    @Override
    public void run() {
        StringBuilder info;
        long start;
        block8: {
            if (!this.errorWrapper.assertCondition()) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Task[" + this.taskNo + "] Assert Execute Condition Failed, Ignore");
                }
                return;
            }
            start = System.currentTimeMillis();
            info = null;
            try {
                if (logger.isDebugEnabled()) {
                    info = new StringBuilder();
                    info.append("Task[").append(this.taskNo).append("] starting ......");
                    logger.debug(info.toString());
                }
                TaskCall.call(this.refreshOption, this.clientInterface, this.datas, this.errorWrapper.getESJDBC());
            }
            catch (Exception e) {
                this.errorWrapper.setError(e);
                if (logger.isDebugEnabled()) {
                    long end = System.currentTimeMillis();
                    info.setLength(0);
                    info.append("Task[").append(this.taskNo).append("] failed,take ").append(end - start).append("\u6beb\u79d2");
                    logger.debug(info.toString());
                }
                if (!this.errorWrapper.getESJDBC().isContinueOnError()) {
                    throw new TaskFailedException("Task[" + this.taskNo + "] Execute Failed", e);
                }
                if (!logger.isErrorEnabled()) break block8;
                logger.error("Task[" + this.taskNo + "] Execute Failed,but continue On Error!", (Throwable)e);
            }
        }
        if (logger.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            info.setLength(0);
            info.append("Task[").append(this.taskNo).append("] completed,take ").append(end - start).append("\u6beb\u79d2");
            logger.debug(info.toString());
        }
    }
}

