/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import com.frameworkset.common.poolman.StatementInfo;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.frameworkset.elasticsearch.client.DataRefactor;
import org.frameworkset.elasticsearch.client.DataStream;
import org.frameworkset.elasticsearch.client.ESJDBC;
import org.frameworkset.elasticsearch.client.FieldMeta;
import org.frameworkset.elasticsearch.client.schedule.ImportIncreamentConfig;
import org.frameworkset.elasticsearch.client.schedule.ScheduleConfig;
import org.frameworkset.spi.assemble.PropertiesContainer;
import org.frameworkset.util.annotations.DateFormateMeta;

public class ImportBuilder {
    private String applicationPropertiesFile;
    private boolean freezen;
    private String sql;
    private String sqlFilepath;
    private Integer jdbcFetchSize;
    private boolean showSql;
    private String dbName;
    private String dbDriver;
    private String dbUrl;
    private String dbUser;
    private String dbPassword;
    private String validateSQL;
    private boolean usePool = false;
    private String refreshOption;
    private int batchSize = 1000;
    private Integer scheduleBatchSize;
    private String index;
    private String indexType;
    private String esIdField;
    private String esParentIdField;
    private String esParentIdValue;
    private String routingField;
    private String routingValue;
    private Boolean esDocAsUpsert;
    private Integer esRetryOnConflict;
    private Boolean esReturnSource;
    private String esVersionField;
    private Object esVersionValue;
    private String esVersionType;
    private Boolean useJavaName;
    private String dateFormat;
    private String locale;
    private String timeZone;
    private ResultSet resultSet;
    private StatementInfo statementInfo;
    private boolean discardBulkResponse = true;
    private boolean debugResponse;
    private ScheduleConfig scheduleConfig;
    private ImportIncreamentConfig importIncreamentConfig;
    private Map<String, FieldMeta> fieldMetaMap = new HashMap<String, FieldMeta>();
    private List<FieldMeta> fieldValues = new ArrayList<FieldMeta>();
    private DataRefactor dataRefactor;
    private boolean parallel;
    private int threadCount = 200;
    private int queue = 1000;
    private boolean asyn;
    private boolean continueOnError;

    private ImportBuilder() {
    }

    public boolean isShowSql() {
        return this.showSql;
    }

    public ImportBuilder setShowSql(boolean showSql) {
        this.showSql = showSql;
        return this;
    }

    public boolean isFreezen() {
        return this.freezen;
    }

    public void setFreezen(boolean freezen) {
        this.freezen = freezen;
    }

    public String getSql() {
        return this.sql;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getDbDriver() {
        return this.dbDriver;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public String getValidateSQL() {
        return this.validateSQL;
    }

    public boolean isUsePool() {
        return this.usePool;
    }

    public String getRefreshOption() {
        return this.refreshOption;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public String getIndex() {
        return this.index;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public String getEsIdField() {
        return this.esIdField;
    }

    public String getEsParentIdField() {
        return this.esParentIdField;
    }

    public String getRoutingField() {
        return this.routingField;
    }

    public String getRoutingValue() {
        return this.routingValue;
    }

    public Boolean getEsDocAsUpsert() {
        return this.esDocAsUpsert;
    }

    public Integer getEsRetryOnConflict() {
        return this.esRetryOnConflict;
    }

    public Boolean getEsReturnSource() {
        return this.esReturnSource;
    }

    public String getEsVersionField() {
        return this.esVersionField;
    }

    public String getEsVersionType() {
        return this.esVersionType;
    }

    public Boolean getUseJavaName() {
        return this.useJavaName;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public boolean isContinueOnError() {
        return this.continueOnError;
    }

    public static ImportBuilder newInstance() {
        return new ImportBuilder();
    }

    public ImportBuilder setResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
        return this;
    }

    public ImportBuilder setStatementInfo(StatementInfo statementInfo) {
        this.statementInfo = statementInfo;
        return this;
    }

    private FieldMeta buildFieldMeta(String dbColumnName, String esFieldName, String dateFormat) {
        FieldMeta fieldMeta = new FieldMeta();
        fieldMeta.setDbColumnName(dbColumnName);
        fieldMeta.setEsFieldName(esFieldName);
        fieldMeta.setIgnore(false);
        fieldMeta.setDateFormateMeta(dateFormat == null ? null : DateFormateMeta.buildDateFormateMeta((String)dateFormat, (String)this.locale, (String)this.timeZone));
        return fieldMeta;
    }

    private static FieldMeta buildIgnoreFieldMeta(String dbColumnName) {
        FieldMeta fieldMeta = new FieldMeta();
        fieldMeta.setDbColumnName(dbColumnName);
        fieldMeta.setIgnore(true);
        return fieldMeta;
    }

    private FieldMeta buildFieldMeta(String dbColumnName, String esFieldName, String dateFormat, String locale, String timeZone) {
        FieldMeta fieldMeta = new FieldMeta();
        fieldMeta.setDbColumnName(dbColumnName);
        fieldMeta.setEsFieldName(esFieldName);
        fieldMeta.setIgnore(false);
        fieldMeta.setDateFormateMeta(dateFormat == null ? null : DateFormateMeta.buildDateFormateMeta((String)dateFormat, (String)locale, (String)timeZone));
        return fieldMeta;
    }

    public ImportBuilder addFieldMapping(String dbColumnName, String esFieldName) {
        this.fieldMetaMap.put(dbColumnName, this.buildFieldMeta(dbColumnName, esFieldName, null));
        return this;
    }

    public ImportBuilder addIgnoreFieldMapping(String dbColumnName) {
        ImportBuilder.addIgnoreFieldMapping(this.fieldMetaMap, dbColumnName);
        return this;
    }

    public static void addIgnoreFieldMapping(Map<String, FieldMeta> fieldMetaMap, String dbColumnName) {
        fieldMetaMap.put(dbColumnName, ImportBuilder.buildIgnoreFieldMeta(dbColumnName));
    }

    public ImportBuilder addFieldMapping(String dbColumnName, String esFieldName, String dateFormat) {
        this.fieldMetaMap.put(dbColumnName, this.buildFieldMeta(dbColumnName, esFieldName, dateFormat));
        return this;
    }

    public ImportBuilder addFieldMapping(String dbColumnName, String esFieldName, String dateFormat, String locale, String timeZone) {
        this.fieldMetaMap.put(dbColumnName, this.buildFieldMeta(dbColumnName, esFieldName, dateFormat, locale, timeZone));
        return this;
    }

    public ImportBuilder setTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public ImportBuilder setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    public ImportBuilder setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    public ImportBuilder setUseJavaName(Boolean useJavaName) {
        this.useJavaName = useJavaName;
        return this;
    }

    public ImportBuilder setEsVersionType(String esVersionType) {
        this.esVersionType = esVersionType;
        return this;
    }

    public ImportBuilder setEsVersionField(String esVersionField) {
        this.esVersionField = esVersionField;
        return this;
    }

    public ImportBuilder setEsReturnSource(Boolean esReturnSource) {
        this.esReturnSource = esReturnSource;
        return this;
    }

    public ImportBuilder setEsRetryOnConflict(Integer esRetryOnConflict) {
        this.esRetryOnConflict = esRetryOnConflict;
        return this;
    }

    public ImportBuilder setEsDocAsUpsert(Boolean esDocAsUpsert) {
        this.esDocAsUpsert = esDocAsUpsert;
        return this;
    }

    public ImportBuilder setRoutingValue(String routingValue) {
        this.routingValue = routingValue;
        return this;
    }

    public ImportBuilder setRoutingField(String routingField) {
        this.routingField = routingField;
        return this;
    }

    public ImportBuilder setEsParentIdField(String esParentIdField) {
        this.esParentIdField = esParentIdField;
        return this;
    }

    public ImportBuilder setEsIdField(String esIdField) {
        this.esIdField = esIdField;
        return this;
    }

    private void buildDBConfig() {
        if (!this.freezen) {
            String _jdbcFetchSize;
            PropertiesContainer propertiesContainer = new PropertiesContainer();
            if (this.applicationPropertiesFile == null) {
                propertiesContainer.addConfigPropertiesFile("application.properties");
            } else {
                propertiesContainer.addConfigPropertiesFile(this.applicationPropertiesFile);
            }
            this.dbName = propertiesContainer.getProperty("db.name");
            this.dbUser = propertiesContainer.getProperty("db.user");
            this.dbPassword = propertiesContainer.getProperty("db.password");
            this.dbDriver = propertiesContainer.getProperty("db.driver");
            this.dbUrl = propertiesContainer.getProperty("db.url");
            String _usePool = propertiesContainer.getProperty("db.usePool");
            if (_usePool != null && !_usePool.equals("")) {
                this.usePool = Boolean.parseBoolean(_usePool);
            }
            this.validateSQL = propertiesContainer.getProperty("db.validateSQL");
            String _showSql = propertiesContainer.getProperty("db.showsql");
            if (_showSql != null && !_showSql.equals("")) {
                this.showSql = Boolean.parseBoolean(_showSql);
            }
            if ((_jdbcFetchSize = propertiesContainer.getProperty("db.jdbcFetchSize")) != null && !_jdbcFetchSize.equals("")) {
                this.jdbcFetchSize = Integer.parseInt(_jdbcFetchSize);
            }
        }
    }

    private ESJDBC buildESConfig() {
        ESJDBC esjdbcResultSet = new ESJDBC();
        esjdbcResultSet.setImportBuilder(this);
        esjdbcResultSet.setDateFormat(this.dateFormat);
        esjdbcResultSet.setLocale(this.locale);
        esjdbcResultSet.setTimeZone(this.timeZone);
        esjdbcResultSet.setEsDocAsUpsert(this.esDocAsUpsert);
        esjdbcResultSet.setEsIdField(this.esIdField);
        esjdbcResultSet.setEsParentIdField(this.esParentIdField);
        esjdbcResultSet.setEsParentIdValue(this.esParentIdValue);
        esjdbcResultSet.setEsRetryOnConflict(this.esRetryOnConflict);
        esjdbcResultSet.setEsReturnSource(this.esReturnSource);
        esjdbcResultSet.setEsVersionField(this.esVersionField);
        esjdbcResultSet.setEsVersionValue(this.esVersionValue);
        esjdbcResultSet.setEsVersionType(this.esVersionType);
        esjdbcResultSet.setRoutingField(this.routingField);
        esjdbcResultSet.setRoutingValue(this.routingValue);
        esjdbcResultSet.setUseJavaName(this.useJavaName);
        esjdbcResultSet.setFieldMetaMap(this.fieldMetaMap);
        esjdbcResultSet.setFieldValues(this.fieldValues);
        esjdbcResultSet.setDataRefactor(this.dataRefactor);
        esjdbcResultSet.setSql(this.sql);
        esjdbcResultSet.setDbName(this.dbName);
        esjdbcResultSet.setShowSql(this.showSql);
        esjdbcResultSet.setRefreshOption(this.refreshOption);
        esjdbcResultSet.setBatchSize(this.batchSize);
        esjdbcResultSet.setJdbcFetchSize(this.jdbcFetchSize);
        esjdbcResultSet.setIndex(this.index);
        esjdbcResultSet.setIndexType(this.indexType);
        esjdbcResultSet.setDbDriver(this.dbDriver);
        esjdbcResultSet.setDbUrl(this.dbUrl);
        esjdbcResultSet.setDbUser(this.dbUser);
        esjdbcResultSet.setDbPassword(this.dbPassword);
        esjdbcResultSet.setValidateSQL(this.validateSQL);
        esjdbcResultSet.setUsePool(this.usePool);
        esjdbcResultSet.setApplicationPropertiesFile(this.applicationPropertiesFile);
        esjdbcResultSet.setParallel(this.parallel);
        esjdbcResultSet.setThreadCount(this.threadCount);
        esjdbcResultSet.setQueue(this.queue);
        esjdbcResultSet.setAsyn(this.asyn);
        esjdbcResultSet.setContinueOnError(this.continueOnError);
        esjdbcResultSet.setDiscardBulkResponse(this.discardBulkResponse);
        esjdbcResultSet.setDebugResponse(this.debugResponse);
        esjdbcResultSet.setScheduleConfig(this.scheduleConfig);
        esjdbcResultSet.setImportIncreamentConfig(this.importIncreamentConfig);
        esjdbcResultSet.setSqlFilepath(this.sqlFilepath);
        if (this.scheduleBatchSize != null) {
            esjdbcResultSet.setScheduleBatchSize(this.scheduleBatchSize);
        } else {
            esjdbcResultSet.setScheduleBatchSize(this.batchSize);
        }
        return esjdbcResultSet;
    }

    public DataStream builder() {
        this.buildDBConfig();
        ESJDBC esjdbcResultSet = this.buildESConfig();
        DataStream dataStream = new DataStream();
        dataStream.setEsjdbc(esjdbcResultSet);
        return dataStream;
    }

    public ImportBuilder setIndexType(String indexType) {
        this.indexType = indexType;
        return this;
    }

    public ImportBuilder setIndex(String index) {
        this.index = index;
        return this;
    }

    public ImportBuilder setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public ImportBuilder setRefreshOption(String refreshOption) {
        this.refreshOption = refreshOption;
        return this;
    }

    public ImportBuilder setDbName(String dbName) {
        this.freezen = true;
        this.dbName = dbName;
        return this;
    }

    public ImportBuilder setSql(String sql) {
        this.sql = sql;
        return this;
    }

    public ImportBuilder setDbDriver(String dbDriver) {
        this.freezen = true;
        this.dbDriver = dbDriver;
        return this;
    }

    public ImportBuilder setDbUrl(String dbUrl) {
        this.freezen = true;
        this.dbUrl = dbUrl;
        return this;
    }

    public ImportBuilder setDbUser(String dbUser) {
        this.freezen = true;
        this.dbUser = dbUser;
        return this;
    }

    public ImportBuilder setDbPassword(String dbPassword) {
        this.freezen = true;
        this.dbPassword = dbPassword;
        return this;
    }

    public ImportBuilder setValidateSQL(String validateSQL) {
        this.freezen = true;
        this.validateSQL = validateSQL;
        return this;
    }

    public ImportBuilder setUsePool(boolean usePool) {
        this.freezen = true;
        this.usePool = usePool;
        return this;
    }

    public String getApplicationPropertiesFile() {
        return this.applicationPropertiesFile;
    }

    public void setApplicationPropertiesFile(String applicationPropertiesFile) {
        this.applicationPropertiesFile = applicationPropertiesFile;
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public ImportBuilder setParallel(boolean parallel) {
        this.parallel = parallel;
        return this;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public ImportBuilder setThreadCount(int threadCount) {
        this.threadCount = threadCount;
        return this;
    }

    public int getQueue() {
        return this.queue;
    }

    public void setQueue(int queue) {
        this.queue = queue;
    }

    public boolean isAsyn() {
        return this.asyn;
    }

    public ImportBuilder setAsyn(boolean asyn) {
        this.asyn = asyn;
        return this;
    }

    public ImportBuilder setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
        return this;
    }

    public ImportBuilder addFieldValue(String fieldName, Object value) {
        ImportBuilder.addFieldValue(this.fieldValues, fieldName, value);
        return this;
    }

    public ImportBuilder addFieldValue(String fieldName, String dateFormat, Object value) {
        ImportBuilder.addFieldValue(this.fieldValues, fieldName, dateFormat, value, this.locale, this.timeZone);
        return this;
    }

    public ImportBuilder addFieldValue(String fieldName, String dateFormat, Object value, String locale, String timeZone) {
        ImportBuilder.addFieldValue(this.fieldValues, fieldName, dateFormat, value, locale, timeZone);
        return this;
    }

    public static void addFieldValue(List<FieldMeta> fieldValues, String fieldName, Object value) {
        FieldMeta fieldMeta = new FieldMeta();
        fieldMeta.setEsFieldName(fieldName);
        fieldMeta.setValue(value);
        fieldValues.add(fieldMeta);
    }

    public static void addFieldValue(List<FieldMeta> fieldValues, String fieldName, String dateFormat, Object value, String locale, String timeZone) {
        FieldMeta fieldMeta = new FieldMeta();
        fieldMeta.setEsFieldName(fieldName);
        fieldMeta.setValue(value);
        fieldMeta.setDateFormateMeta(ImportBuilder.buildDateFormateMeta(dateFormat, locale, timeZone));
        fieldValues.add(fieldMeta);
    }

    public DateFormateMeta buildDateFormateMeta(String dateFormat) {
        return dateFormat == null ? null : DateFormateMeta.buildDateFormateMeta((String)dateFormat, (String)this.locale, (String)this.timeZone);
    }

    public static DateFormateMeta buildDateFormateMeta(String dateFormat, String locale, String timeZone) {
        return dateFormat == null ? null : DateFormateMeta.buildDateFormateMeta((String)dateFormat, (String)locale, (String)timeZone);
    }

    public DataRefactor getDataRefactor() {
        return this.dataRefactor;
    }

    public ImportBuilder setDataRefactor(DataRefactor dataRefactor) {
        this.dataRefactor = dataRefactor;
        return this;
    }

    public String getEsParentIdValue() {
        return this.esParentIdValue;
    }

    public void setEsParentIdValue(String esParentIdValue) {
        this.esParentIdValue = esParentIdValue;
    }

    public Object getEsVersionValue() {
        return this.esVersionValue;
    }

    public ImportBuilder setEsVersionValue(Object esVersionValue) {
        this.esVersionValue = esVersionValue;
        return this;
    }

    public boolean isDiscardBulkResponse() {
        return this.discardBulkResponse;
    }

    public ImportBuilder setDiscardBulkResponse(boolean discardBulkResponse) {
        this.discardBulkResponse = discardBulkResponse;
        return this;
    }

    public boolean isDebugResponse() {
        return this.debugResponse;
    }

    public ImportBuilder setDebugResponse(boolean debugResponse) {
        this.debugResponse = debugResponse;
        return this;
    }

    public ImportBuilder setPeriod(Long period) {
        if (this.scheduleConfig == null) {
            this.scheduleConfig = new ScheduleConfig();
        }
        this.scheduleConfig.setPeriod(period);
        return this;
    }

    public ImportBuilder setDeyLay(Long deyLay) {
        if (this.scheduleConfig == null) {
            this.scheduleConfig = new ScheduleConfig();
        }
        this.scheduleConfig.setDeyLay(deyLay);
        return this;
    }

    public ImportBuilder setScheduleDate(Date scheduleDate) {
        if (this.scheduleConfig == null) {
            this.scheduleConfig = new ScheduleConfig();
        }
        this.scheduleConfig.setScheduleDate(scheduleDate);
        return this;
    }

    public ImportBuilder setFixedRate(Boolean fixedRate) {
        if (this.scheduleConfig == null) {
            this.scheduleConfig = new ScheduleConfig();
        }
        this.scheduleConfig.setFixedRate(fixedRate);
        return this;
    }

    public ScheduleConfig getScheduleConfig() {
        return this.scheduleConfig;
    }

    public ImportIncreamentConfig getImportIncreamentConfig() {
        return this.importIncreamentConfig;
    }

    public ImportBuilder setDateLastValueColumn(String dateLastValueColumn) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setDateLastValueColumn(dateLastValueColumn);
        return this;
    }

    public ImportBuilder setNumberLastValueColumn(String numberLastValueColumn) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setNumberLastValueColumn(numberLastValueColumn);
        return this;
    }

    public ImportBuilder setLastValueStorePath(String lastValueStorePath) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setLastValueStorePath(lastValueStorePath);
        return this;
    }

    public ImportBuilder setLastValueStoreTableName(String lastValueStoreTableName) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setLastValueStoreTableName(lastValueStoreTableName);
        return this;
    }

    public ImportBuilder setFromFirst(boolean fromFirst) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setFromFirst(fromFirst);
        return this;
    }

    public ImportBuilder setLastValue(Long lastValue) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setLastValue(lastValue);
        return this;
    }

    public ImportBuilder setLastValueType(int lastValueType) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setLastValueType(lastValueType);
        return this;
    }

    public ImportBuilder setSqlFilepath(String sqlFilepath) {
        this.sqlFilepath = sqlFilepath;
        return this;
    }

    public ImportBuilder setJdbcFetchSize(Integer jdbcFetchSize) {
        this.jdbcFetchSize = jdbcFetchSize;
        return this;
    }

    public Integer getScheduleBatchSize() {
        return this.scheduleBatchSize;
    }

    public ImportBuilder setScheduleBatchSize(Integer scheduleBatchSize) {
        this.scheduleBatchSize = scheduleBatchSize;
        return this;
    }
}

