/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import com.frameworkset.common.poolman.SQLExecutor;
import com.frameworkset.common.poolman.StatementInfo;
import com.frameworkset.common.poolman.handle.NullRowHandler;
import com.frameworkset.common.poolman.handle.ResultSetHandler;
import com.frameworkset.common.poolman.util.SQLUtil;
import com.frameworkset.util.SimpleStringUtil;
import java.sql.ResultSet;
import org.frameworkset.elasticsearch.boot.ElasticSearchBoot;
import org.frameworkset.elasticsearch.client.ESDataImportException;
import org.frameworkset.elasticsearch.client.ESJDBC;
import org.frameworkset.elasticsearch.client.JDBCRestClientUtil;
import org.frameworkset.elasticsearch.client.schedule.ScheduleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStream {
    private ESJDBC esjdbc;
    private ScheduleService scheduleService;
    private static Logger logger = LoggerFactory.getLogger(DataStream.class);

    public void db2es() throws ESDataImportException {
        if (this.esjdbc == null) {
            throw new ESDataImportException("ESJDBC is null.");
        }
        try {
            this.initES();
            this.initDS();
            this.initSchedule();
            this.importData();
        }
        catch (Exception e) {
            throw new ESDataImportException(e);
        }
    }

    public void setEsjdbc(ESJDBC esjdbc) {
        this.esjdbc = esjdbc;
    }

    private void initES() {
        if (SimpleStringUtil.isNotEmpty((String)this.esjdbc.getApplicationPropertiesFile())) {
            ElasticSearchBoot.boot((String)this.esjdbc.getApplicationPropertiesFile());
        }
    }

    private void initSchedule() {
        if (this.esjdbc.getScheduleConfig() != null) {
            this.scheduleService = new ScheduleService();
            this.scheduleService.init(this.esjdbc);
        }
    }

    private void initDS() {
        if (SimpleStringUtil.isNotEmpty((String)this.esjdbc.getDbDriver()) && SimpleStringUtil.isNotEmpty((String)this.esjdbc.getDbUrl())) {
            SQLUtil.startPool((String)this.esjdbc.getDbName(), (String)this.esjdbc.getDbDriver(), (String)this.esjdbc.getDbUrl(), (String)this.esjdbc.getDbUser(), (String)this.esjdbc.getDbPassword(), null, null, (String)this.esjdbc.getValidateSQL(), (String)(this.esjdbc.getDbName() + "_jndi"), (int)10, (int)10, (int)20, (boolean)this.esjdbc.isUsePool(), (boolean)false, null, (boolean)this.esjdbc.isShowSql(), (boolean)false, (int)(this.esjdbc.getJdbcFetchSize() == null ? 0 : this.esjdbc.getJdbcFetchSize()));
        }
    }

    private void firstImportData() throws Exception {
        SQLExecutor.queryWithDBNameByNullRowHandler((NullRowHandler)new ResultSetHandler(){

            public void handleResult(ResultSet resultSet, StatementInfo statementInfo) throws Exception {
                DataStream.this.esjdbc.setResultSet(resultSet);
                DataStream.this.esjdbc.setMetaData(statementInfo.getMeta());
                JDBCRestClientUtil jdbcRestClientUtil = new JDBCRestClientUtil();
                jdbcRestClientUtil.addDocuments(DataStream.this.esjdbc.getIndex(), DataStream.this.esjdbc.getIndexType(), DataStream.this.esjdbc, DataStream.this.esjdbc.getRefreshOption(), DataStream.this.esjdbc.getBatchSize());
            }
        }, (String)this.esjdbc.getDbName(), (String)this.esjdbc.getSql(), (Object[])new Object[0]);
    }

    private void importData() throws Exception {
        if (this.scheduleService == null) {
            this.firstImportData();
        } else {
            this.scheduleService.timeSchedule();
        }
    }
}

