/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.frameworkset.elasticsearch.client.Context;
import org.frameworkset.elasticsearch.client.ESJDBC;
import org.frameworkset.elasticsearch.client.FieldMeta;
import org.frameworkset.elasticsearch.client.ImportBuilder;

public class ContextImpl
implements Context {
    private List<FieldMeta> fieldValues;
    private Map<String, FieldMeta> fieldMetaMap;
    private ESJDBC esjdbc;

    public ContextImpl(ESJDBC esjdbc) {
        this.esjdbc = esjdbc;
    }

    @Override
    public List<FieldMeta> getFieldValues() {
        return this.fieldValues;
    }

    @Override
    public Map<String, FieldMeta> getFieldMetaMap() {
        return this.fieldMetaMap;
    }

    @Override
    public Context addFieldValue(String fieldName, Object value) {
        if (this.fieldValues == null) {
            this.fieldValues = new ArrayList<FieldMeta>();
        }
        ImportBuilder.addFieldValue(this.fieldValues, fieldName, value);
        return this;
    }

    @Override
    public Context addFieldValue(String fieldName, String dateFormat, Object value) {
        if (this.fieldValues == null) {
            this.fieldValues = new ArrayList<FieldMeta>();
        }
        ImportBuilder.addFieldValue(this.fieldValues, fieldName, dateFormat, value, this.esjdbc.getLocale(), this.esjdbc.getTimeZone());
        return this;
    }

    @Override
    public Context addFieldValue(String fieldName, String dateFormat, Object value, String locale, String timeZone) {
        if (this.fieldValues == null) {
            this.fieldValues = new ArrayList<FieldMeta>();
        }
        ImportBuilder.addFieldValue(this.fieldValues, fieldName, dateFormat, value, locale, timeZone);
        return this;
    }

    @Override
    public Context addIgnoreFieldMapping(String dbColumnName) {
        if (this.fieldMetaMap == null) {
            this.fieldMetaMap = new HashMap<String, FieldMeta>();
        }
        ImportBuilder.addIgnoreFieldMapping(this.fieldMetaMap, dbColumnName);
        return this;
    }

    @Override
    public ESJDBC getEsjdbc() {
        return this.esjdbc;
    }

    @Override
    public Object getValue(String fieldName) throws Exception {
        return this.esjdbc.getValue(fieldName);
    }

    @Override
    public FieldMeta getMappingName(String colName) {
        FieldMeta fieldMeta;
        if (this.fieldMetaMap != null && (fieldMeta = this.fieldMetaMap.get(colName)) != null) {
            return fieldMeta;
        }
        return this.esjdbc.getMappingName(colName);
    }
}

