/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.hbase.input.db;

import org.apache.hadoop.hbase.client.ResultScanner;
import org.frameworkset.tran.DBConfig;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.db.output.AsynDBOutPutDataTran;
import org.frameworkset.tran.db.output.DBOutPutContext;
import org.frameworkset.tran.hbase.HBaseInputPlugin;
import org.frameworkset.tran.hbase.HBaseResultSet;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.util.TranUtil;

public class HBase2DBInputPlugin
extends HBaseInputPlugin {
    protected DBOutPutContext dbOutPutContext;

    public HBase2DBInputPlugin(ImportContext importContext, ImportContext targetImportContext) {
        super(importContext, targetImportContext);
        this.dbOutPutContext = (DBOutPutContext)targetImportContext;
    }

    @Override
    public void beforeInit() {
        if (this.importContext.getDbConfig() != null) {
            this.initDS(this.importContext.getDbConfig());
        }
        if (this.dbOutPutContext.getTargetDBConfig() != null) {
            this.initDS(this.dbOutPutContext.getTargetDBConfig());
            TranUtil.initTargetSQLInfo((DBOutPutContext)this.dbOutPutContext, (DBConfig)this.dbOutPutContext.getTargetDBConfig());
        } else {
            TranUtil.initTargetSQLInfo((DBOutPutContext)this.dbOutPutContext, (DBConfig)this.importContext.getDbConfig());
        }
        super.beforeInit();
    }

    @Override
    protected void doTran(ResultScanner rs, TaskContext taskContext) {
        HBaseResultSet hBaseResultSet = new HBaseResultSet(this.importContext, rs);
        AsynDBOutPutDataTran asynDBOutPutDataTran = new AsynDBOutPutDataTran(taskContext, (TranResultSet)hBaseResultSet, this.importContext, this.targetImportContext, this.currentStatus);
        asynDBOutPutDataTran.init();
        asynDBOutPutDataTran.tran();
    }
}

