/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.hbase;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.frameworkset.tran.DefaultTranMetaData;
import org.frameworkset.tran.ESDataImportException;
import org.frameworkset.tran.LastValue;
import org.frameworkset.tran.Record;
import org.frameworkset.tran.TranMeta;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.hbase.HBaseContextImpl;
import org.frameworkset.tran.hbase.HBaseRecord;
import org.frameworkset.tran.util.TranUtil;

public class HBaseResultSet
extends LastValue
implements TranResultSet {
    private ResultScanner resultScanner;
    private Record record;
    private boolean incrementByTimeRange;
    private Map<String, byte[][]> familys;

    public HBaseResultSet(ImportContext importContext, ResultScanner resultScanner) {
        this.importContext = importContext;
        this.resultScanner = resultScanner;
        this.familys = new HashMap<String, byte[][]>();
        this.incrementByTimeRange = ((HBaseContextImpl)importContext).isIncrementByTimeRange();
    }

    public Object getValue(int i, String colName, int sqlType) throws ESDataImportException {
        return this.getValue(colName);
    }

    public Object getValue(String colName) throws ESDataImportException {
        Object value = this.record.getValue(colName);
        return value;
    }

    public Object getValue(String colName, int sqlType) throws ESDataImportException {
        return this.getValue(colName);
    }

    public Date getDateTimeValue(String colName) throws ESDataImportException {
        Object value = this.getValue(colName);
        if (value == null) {
            return null;
        }
        Long time = Bytes.toLong((byte[])((byte[])value));
        return TranUtil.getDateTimeValue((String)colName, (Object)time, (ImportContext)this.importContext);
    }

    public Boolean next() throws ESDataImportException {
        try {
            Result record = this.resultScanner.next();
            if (record != null) {
                this.record = new HBaseRecord(this.familys, record);
                return true;
            }
        }
        catch (IOException e) {
            throw new ESDataImportException("Get next hbase result failed:", (Throwable)e);
        }
        return false;
    }

    public TranMeta getMetaData() {
        return new DefaultTranMetaData(null);
    }

    public Object getKeys() {
        return this.record.getKeys();
    }

    public Object getRecord() {
        return this.record;
    }

    public void stop() {
    }

    public void stopTranOnly() {
    }

    public Object getMetaValue(String fieldName) {
        return this.record.getMetaValue(fieldName);
    }

    public Object getLastValue(TranResultSet tranResultSet, ImportContext importContext, String colName) throws ESDataImportException {
        try {
            if (importContext.getLastValueType() == null || importContext.getLastValueType() == 0) {
                Object value = tranResultSet.getValue(importContext.getLastValueColumnName());
                Long l = Bytes.toLong((byte[])((byte[])value));
                return l;
            }
            if (this.incrementByTimeRange) {
                return tranResultSet.getMetaValue("timestamp");
            }
            if (importContext.getLastValueType() == 1) {
                return tranResultSet.getDateTimeValue(importContext.getLastValueColumnName());
            }
        }
        catch (ESDataImportException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ESDataImportException((Throwable)e);
        }
        throw new ESDataImportException("Unsupport last value type:" + importContext.getLastValueType());
    }

    public boolean removed() {
        return this.record.removed();
    }

    public boolean reachEOFClosed() {
        return this.record.reachEOFClosed();
    }
}

