/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.hbase;

import java.util.Date;
import java.util.Map;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.ESDataImportException;
import org.frameworkset.tran.Record;

public class HBaseRecord
implements Record {
    private Result data;
    private Map<String, byte[][]> familys;

    public HBaseRecord(Map<String, byte[][]> familys, Result data) {
        this.familys = familys;
        this.data = data;
    }

    public boolean removed() {
        return false;
    }

    public boolean reachEOFClosed() {
        return false;
    }

    private byte[][] parser(String colName) {
        byte[][] cs = this.familys.get(colName);
        if (cs != null) {
            return cs;
        }
        cs = HBaseRecord.parserColumn(colName);
        this.familys.put(colName, cs);
        return cs;
    }

    public static byte[][] parserColumn(String colName) {
        try {
            String[] infos = colName.split(":");
            byte[] f = Bytes.toBytes((String)infos[0]);
            byte[] c = Bytes.toBytes((String)infos[1]);
            byte[][] cs = new byte[][]{f, c};
            return cs;
        }
        catch (Exception e) {
            throw new DataImportException("Parser Column failed: [" + colName + "] is not a hbase colname like c:name", (Throwable)e);
        }
    }

    public Object getValue(String colName) {
        byte[][] cs = this.parser(colName);
        return this.data.getValue(cs[0], cs[1]);
    }

    public Object getMetaValue(String colName) {
        if (colName.equals("rowkey")) {
            return this.data.getRow();
        }
        if (colName.equals("timestamp")) {
            return new Date(this.data.rawCells()[0].getTimestamp());
        }
        throw new ESDataImportException("Get Meta Value failed: " + colName + " is not a elasticsearch document meta field.");
    }

    public long getOffset() {
        return 0L;
    }

    public Object getKeys() {
        return null;
    }

    public Object getData() {
        return this.data;
    }

    public static void main(String[] args) {
        String c = "c:d";
        String[] cs = c.split(":");
        System.out.println(cs[0] + ":" + cs[1]);
    }
}

