/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.hbase;

import com.frameworkset.orm.annotation.BatchContext;
import java.io.IOException;
import java.util.Date;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.frameworkset.nosql.hbase.HBaseHelper;
import org.frameworkset.nosql.hbase.TableFactory;
import org.frameworkset.tran.BaseDataTranPlugin;
import org.frameworkset.tran.DataTranPlugin;
import org.frameworkset.tran.ESDataImportException;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.context.Context;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.hbase.HBaseContext;
import org.frameworkset.tran.hbase.HBaseRecord;
import org.frameworkset.tran.hbase.HBaseRecordContextImpl;
import org.frameworkset.tran.schedule.TaskContext;

public abstract class HBaseInputPlugin
extends BaseDataTranPlugin
implements DataTranPlugin {
    private TableFactory tableFactory;
    private HBaseContext hbaseContext;
    private byte[] incrementFamily;
    private byte[] incrementColumn;
    private Long lastValue;

    protected void init(ImportContext importContext, ImportContext targetImportContext) {
        super.init(importContext, targetImportContext);
        this.hbaseContext = (HBaseContext)importContext;
    }

    public Context buildContext(TaskContext taskContext, TranResultSet jdbcResultSet, BatchContext batchContext) {
        return new HBaseRecordContextImpl(taskContext, this.importContext, this.targetImportContext, jdbcResultSet, batchContext);
    }

    public HBaseInputPlugin(ImportContext importContext, ImportContext targetImportContext) {
        super(importContext, targetImportContext);
    }

    public void destroy(boolean waitTranStop) {
        super.destroy(waitTranStop);
        HBaseHelper.destroy();
    }

    public void beforeInit() {
        this.initHBase();
    }

    protected abstract void doTran(ResultScanner var1, TaskContext var2);

    protected void initHBase() {
        HBaseHelper.buildHBaseClient(this.hbaseContext.getHbaseClientProperties(), this.hbaseContext.getHbaseClientThreadCount(), this.hbaseContext.getHbaseClientThreadQueue(), this.hbaseContext.getHbaseClientKeepAliveTime(), this.hbaseContext.getHbaseClientBlockedWaitTimeout(), this.hbaseContext.getHbaseClientWarnMultsRejects(), this.hbaseContext.isHbaseClientPreStartAllCoreThreads(), this.hbaseContext.getHbaseClientThreadDaemon(), this.hbaseContext.getHbaseAsynMetricsEnable());
        this.tableFactory = HBaseHelper.getTableFactory();
    }

    public void afterInit() {
        this.initIncrementInfos();
    }

    public void initStatusTableId() {
        if (this.isIncreamentImport()) {
            String statusTableId = this.hbaseContext.getHbaseTable();
            if (this.hbaseContext.getIncrementFamilyName() != null) {
                statusTableId = statusTableId + "|" + this.hbaseContext.getIncrementFamilyName();
            }
            if (this.importContext.getLastValueColumnName() != null) {
                statusTableId = statusTableId + "|" + this.importContext.getLastValueColumnName();
            }
            if (this.hbaseContext.getStartRow() != null) {
                statusTableId = statusTableId + "|" + this.hbaseContext.getStartRow();
            }
            if (this.hbaseContext.getEndRow() != null) {
                statusTableId = statusTableId + "|" + this.hbaseContext.getEndRow();
            }
            this.importContext.setStatusTableId(statusTableId.hashCode());
        }
    }

    private void exportESData(TaskContext taskContext) {
        Table table = null;
        try {
            table = this.tableFactory.getTable(TableName.valueOf((String)this.hbaseContext.getHbaseTable()));
            Scan scan = new Scan();
            if (this.hbaseContext.getStartRow() != null) {
                scan.setStartRow(Bytes.toBytes((String)this.hbaseContext.getStartRow()));
            }
            if (this.hbaseContext.getEndRow() != null) {
                scan.setStopRow(Bytes.toBytes((String)this.hbaseContext.getEndRow()));
            }
            if (this.hbaseContext.getHbaseBatch() != null) {
                scan.setBatch(this.hbaseContext.getHbaseBatch().intValue());
            }
            if (this.hbaseContext.getMaxResultSize() != null) {
                scan.setMaxResultSize(this.hbaseContext.getMaxResultSize().longValue());
            }
            if (this.hbaseContext.getStartTimestamp() != null && this.hbaseContext.getEndTimestamp() != null) {
                scan.setTimeRange(this.hbaseContext.getStartTimestamp().longValue(), this.hbaseContext.getEndTimestamp().longValue());
            }
            if (this.isIncreamentImport()) {
                this.putLastParamValue(scan);
            } else if (this.hbaseContext.getScanFilters() != null) {
                scan.setFilter((Filter)this.hbaseContext.getScanFilters());
            } else if (this.hbaseContext.getScanFilter() != null) {
                scan.setFilter(this.hbaseContext.getScanFilter());
            }
            if (this.importContext.getFetchSize() != null) {
                scan.setCaching(this.importContext.getFetchSize().intValue());
            }
            ResultScanner rs = table.getScanner(scan);
            this.doTran(rs, taskContext);
        }
        catch (Exception e) {
            throw new ESDataImportException((Throwable)e);
        }
        finally {
            if (this.tableFactory != null && table != null) {
                this.tableFactory.releaseTable(table);
            }
        }
    }

    private void initIncrementInfos() {
        if (this.getLastValueVarName() != null && !this.getLastValueVarName().equals("_")) {
            if (this.hbaseContext.getIncrementFamilyName() != null) {
                this.incrementFamily = Bytes.toBytes((String)this.hbaseContext.getIncrementFamilyName());
                this.incrementColumn = Bytes.toBytes((String)this.getLastValueVarName());
            } else {
                byte[][] infos = HBaseRecord.parserColumn(this.getLastValueVarName());
                this.incrementFamily = infos[0];
                this.incrementColumn = infos[1];
            }
        }
    }

    public Long getTimeRangeLastValue() {
        return this.lastValue;
    }

    public void putLastParamValue(Scan scan) throws IOException {
        if (this.lastValueType == 0) {
            SingleColumnValueFilter scvf = new SingleColumnValueFilter(this.incrementFamily, this.incrementColumn, CompareFilter.CompareOp.GREATER, Bytes.toBytes((long)((Long)this.currentStatus.getLastValue())));
            if (this.hbaseContext.getFilterIfMissing() != null) {
                scvf.setFilterIfMissing(this.hbaseContext.getFilterIfMissing().booleanValue());
            }
            if (this.hbaseContext.getScanFilters() != null) {
                FilterList list = new FilterList(FilterList.Operator.MUST_PASS_ALL);
                list.addFilter((Filter)this.hbaseContext.getScanFilters());
                list.addFilter((Filter)scvf);
                scan.setFilter((Filter)list);
            } else if (this.hbaseContext.getScanFilter() != null) {
                FilterList list = new FilterList(FilterList.Operator.MUST_PASS_ALL);
                list.addFilter(this.hbaseContext.getScanFilter());
                list.addFilter((Filter)scvf);
                scan.setFilter((Filter)list);
            } else {
                scan.setFilter((Filter)scvf);
            }
        } else if (this.hbaseContext.isIncrementByTimeRange()) {
            if (this.lastValue == null) {
                this.lastValue = ((Date)this.currentStatus.getLastValue()).getTime();
            }
            long temp = System.currentTimeMillis();
            scan.setTimeRange(this.lastValue.longValue(), temp);
            this.lastValue = temp;
            if (this.hbaseContext.getScanFilters() != null) {
                scan.setFilter((Filter)this.hbaseContext.getScanFilters());
            } else if (this.hbaseContext.getScanFilter() != null) {
                scan.setFilter(this.hbaseContext.getScanFilter());
            }
        } else {
            Object lv = null;
            lv = this.currentStatus.getLastValue() instanceof Date ? this.currentStatus.getLastValue() : (this.currentStatus.getLastValue() instanceof Long ? new Date((Long)this.currentStatus.getLastValue()) : (this.currentStatus.getLastValue() instanceof Integer ? new Date(((Integer)this.currentStatus.getLastValue()).longValue()) : (this.currentStatus.getLastValue() instanceof Short ? new Date(((Short)this.currentStatus.getLastValue()).longValue()) : new Date(((Number)this.currentStatus.getLastValue()).longValue()))));
            SingleColumnValueFilter scvf = new SingleColumnValueFilter(this.incrementFamily, this.incrementColumn, CompareFilter.CompareOp.GREATER, Bytes.toBytes((long)((Date)this.currentStatus.getLastValue()).getTime()));
            if (this.hbaseContext.getFilterIfMissing() != null) {
                scvf.setFilterIfMissing(this.hbaseContext.getFilterIfMissing().booleanValue());
            }
            if (this.hbaseContext.getScanFilters() != null) {
                FilterList list = new FilterList(FilterList.Operator.MUST_PASS_ALL);
                list.addFilter((Filter)this.hbaseContext.getScanFilters());
                list.addFilter((Filter)scvf);
                scan.setFilter((Filter)list);
            } else if (this.hbaseContext.getScanFilter() != null) {
                FilterList list = new FilterList(FilterList.Operator.MUST_PASS_ALL);
                list.addFilter(this.hbaseContext.getScanFilter());
                list.addFilter((Filter)scvf);
                scan.setFilter((Filter)list);
            } else {
                scan.setFilter((Filter)scvf);
            }
        }
        if (this.isPrintTaskLog()) {
            this.logger.info("Current values: " + this.currentStatus.getLastValue());
        }
    }

    public void doImportData(TaskContext taskContext) throws ESDataImportException {
        try {
            this.exportESData(taskContext);
        }
        catch (ESDataImportException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ESDataImportException((Throwable)e);
        }
    }
}

