/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.hbase;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.frameworkset.tran.DataStream;
import org.frameworkset.tran.DataTranPlugin;
import org.frameworkset.tran.ExportResultHandler;
import org.frameworkset.tran.WrapedExportResultHandler;
import org.frameworkset.tran.config.BaseImportBuilder;
import org.frameworkset.tran.config.BaseImportConfig;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.es.ESExportResultHandler;
import org.frameworkset.tran.hbase.HBaseContextImpl;
import org.frameworkset.tran.hbase.HBaseEsIdGenerator;
import org.frameworkset.tran.hbase.HBaseImportConfig;
import org.frameworkset.tran.hbase.input.es.HBase2ESInputPlugin;

public class HBaseExportBuilder
extends BaseImportBuilder {
    private Map<String, String> hbaseClientProperties;
    private Boolean hbaseAsynMetricsEnable;
    private int hbaseClientThreadCount;
    private int hbaseClientThreadQueue;
    private long hbaseClientKeepAliveTime;
    private long hbaseClientBlockedWaitTimeout;
    private int hbaseClientWarnMultsRejects;
    private boolean hbaseClientPreStartAllCoreThreads;
    private Boolean hbaseClientThreadDaemon;
    private String hbaseTable;
    private String startRow;
    private String endRow;
    private Long maxResultSize;
    private Integer hbaseBatch;
    private FilterList filterList;
    private Filter filter;
    private Boolean filterIfMissing;
    private String incrementFamilyName;
    private Long startTimestamp;
    private Long endTimestamp;

    public HBaseExportBuilder setHbaseClientProperties(Map<String, String> hbaseClientProperties) {
        this.hbaseClientProperties = hbaseClientProperties;
        return this;
    }

    public Boolean getHbaseAsynMetricsEnable() {
        return this.hbaseAsynMetricsEnable;
    }

    public DataTranPlugin buildDataTranPlugin(ImportContext importContext, ImportContext targetImportContext) {
        return new HBase2ESInputPlugin(importContext, targetImportContext);
    }

    public HBaseExportBuilder setHbaseAsynMetricsEnable(Boolean hbaseAsynMetricsEnable) {
        this.hbaseAsynMetricsEnable = hbaseAsynMetricsEnable;
        return this;
    }

    public Map<String, String> getHbaseClientProperties() {
        return this.hbaseClientProperties;
    }

    public static HBaseExportBuilder newInstance() {
        return new HBaseExportBuilder();
    }

    public HBaseExportBuilder addHbaseClientProperty(String name, String value) {
        if (this.hbaseClientProperties == null) {
            this.hbaseClientProperties = new HashMap<String, String>();
        }
        this.hbaseClientProperties.put(name, value);
        return this;
    }

    protected ImportContext buildImportContext(BaseImportConfig importConfig) {
        HBaseContextImpl hBaseContext = new HBaseContextImpl((HBaseImportConfig)importConfig);
        hBaseContext.init();
        return hBaseContext;
    }

    protected void setTargetImportContext(DataStream dataStream) {
        dataStream.setTargetImportContext(dataStream.getImportContext());
    }

    public int getHbaseClientThreadCount() {
        return this.hbaseClientThreadCount;
    }

    public HBaseExportBuilder setHbaseClientThreadCount(int hbaseClientThreadCount) {
        this.hbaseClientThreadCount = hbaseClientThreadCount;
        return this;
    }

    public int getHbaseClientThreadQueue() {
        return this.hbaseClientThreadQueue;
    }

    public HBaseExportBuilder setHbaseClientThreadQueue(int hbaseClientThreadQueue) {
        this.hbaseClientThreadQueue = hbaseClientThreadQueue;
        return this;
    }

    public long getHbaseClientKeepAliveTime() {
        return this.hbaseClientKeepAliveTime;
    }

    public HBaseExportBuilder setHbaseClientKeepAliveTime(long hbaseClientKeepAliveTime) {
        this.hbaseClientKeepAliveTime = hbaseClientKeepAliveTime;
        return this;
    }

    public long getHbaseClientBlockedWaitTimeout() {
        return this.hbaseClientBlockedWaitTimeout;
    }

    public HBaseExportBuilder setHbaseClientBlockedWaitTimeout(long hbaseClientBlockedWaitTimeout) {
        this.hbaseClientBlockedWaitTimeout = hbaseClientBlockedWaitTimeout;
        return this;
    }

    public int getHbaseClientWarnMultsRejects() {
        return this.hbaseClientWarnMultsRejects;
    }

    public HBaseExportBuilder setHbaseClientWarnMultsRejects(int hbaseClientWarnMultsRejects) {
        this.hbaseClientWarnMultsRejects = hbaseClientWarnMultsRejects;
        return this;
    }

    public boolean isHbaseClientPreStartAllCoreThreads() {
        return this.hbaseClientPreStartAllCoreThreads;
    }

    public HBaseExportBuilder setHbaseClientPreStartAllCoreThreads(boolean hbaseClientPreStartAllCoreThreads) {
        this.hbaseClientPreStartAllCoreThreads = hbaseClientPreStartAllCoreThreads;
        return this;
    }

    public Boolean getHbaseClientThreadDaemon() {
        return this.hbaseClientThreadDaemon;
    }

    public HBaseExportBuilder setHbaseClientThreadDaemon(Boolean hbaseClientThreadDaemon) {
        this.hbaseClientThreadDaemon = hbaseClientThreadDaemon;
        return this;
    }

    protected WrapedExportResultHandler buildExportResultHandler(ExportResultHandler exportResultHandler) {
        return new ESExportResultHandler(exportResultHandler);
    }

    public DataStream builder() {
        HBaseImportConfig hBaseImportConfig;
        block9: {
            block8: {
                super.builderConfig();
                try {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("HBase Import Configs:");
                        this.logger.info(this.toString());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                hBaseImportConfig = new HBaseImportConfig();
                super.buildImportConfig((BaseImportConfig)hBaseImportConfig);
                if (hBaseImportConfig.getEsIdGenerator() == null) break block8;
                if (hBaseImportConfig.getEsIdGenerator() != HBaseImportConfig.DEFAULT_EsIdGenerator) break block9;
            }
            hBaseImportConfig.setEsIdGenerator(new HBaseEsIdGenerator());
        }
        if (this.importIncreamentConfig != null && this.importIncreamentConfig.isLastValueDateType() && this.importIncreamentConfig.getLastValueColumn() == null) {
            hBaseImportConfig.setIncrementByTimeRange(true);
            this.importIncreamentConfig.setLastValueColumn("_");
        }
        hBaseImportConfig.setHbaseClientProperties(this.hbaseClientProperties);
        hBaseImportConfig.setHbaseAsynMetricsEnable(this.hbaseAsynMetricsEnable);
        hBaseImportConfig.setHbaseClientThreadCount(this.hbaseClientThreadCount);
        hBaseImportConfig.setHbaseClientThreadQueue(this.hbaseClientThreadQueue);
        hBaseImportConfig.setHbaseClientKeepAliveTime(this.hbaseClientKeepAliveTime);
        hBaseImportConfig.setHbaseClientBlockedWaitTimeout(this.hbaseClientBlockedWaitTimeout);
        hBaseImportConfig.setHbaseClientWarnMultsRejects(this.hbaseClientWarnMultsRejects);
        hBaseImportConfig.setHbaseClientPreStartAllCoreThreads(this.hbaseClientPreStartAllCoreThreads);
        hBaseImportConfig.setHbaseClientThreadDaemon(this.hbaseClientThreadDaemon);
        hBaseImportConfig.setHbaseTable(this.hbaseTable);
        hBaseImportConfig.setStartRow(this.startRow);
        hBaseImportConfig.setEndRow(this.endRow);
        hBaseImportConfig.setMaxResultSize(this.maxResultSize);
        hBaseImportConfig.setHbaseBatch(this.hbaseBatch);
        hBaseImportConfig.setFilterList(this.filterList);
        hBaseImportConfig.setFilter(this.filter);
        hBaseImportConfig.setFilterIfMissing(this.filterIfMissing);
        hBaseImportConfig.setIncrementFamilyName(this.incrementFamilyName);
        hBaseImportConfig.setStartTimestamp(this.startTimestamp);
        hBaseImportConfig.setEndTimestamp(this.endTimestamp);
        DataStream dataStream = this.createDataStream();
        dataStream.setImportConfig((BaseImportConfig)hBaseImportConfig);
        dataStream.setImportContext(this.buildImportContext(hBaseImportConfig));
        this.setTargetImportContext(dataStream);
        dataStream.setDataTranPlugin(this.buildDataTranPlugin(dataStream.getImportContext(), dataStream.getTargetImportContext()));
        return dataStream;
    }

    public String getHbaseTable() {
        return this.hbaseTable;
    }

    public HBaseExportBuilder setHbaseTable(String hbaseTable) {
        this.hbaseTable = hbaseTable;
        return this;
    }

    public String getStartRow() {
        return this.startRow;
    }

    public HBaseExportBuilder setStartRow(String startRow) {
        this.startRow = startRow;
        return this;
    }

    public String getEndRow() {
        return this.endRow;
    }

    public HBaseExportBuilder setEndRow(String endRow) {
        this.endRow = endRow;
        return this;
    }

    public Long getMaxResultSize() {
        return this.maxResultSize;
    }

    public HBaseExportBuilder setMaxResultSize(Long maxResultSize) {
        this.maxResultSize = maxResultSize;
        return this;
    }

    public Integer getHbaseBatch() {
        return this.hbaseBatch;
    }

    public HBaseExportBuilder setHbaseBatch(Integer hbaseBatch) {
        this.hbaseBatch = hbaseBatch;
        return this;
    }

    public FilterList getFilterList() {
        return this.filterList;
    }

    public HBaseExportBuilder setFilterList(FilterList filterList) {
        this.filterList = filterList;
        return this;
    }

    public Boolean getFilterIfMissing() {
        return this.filterIfMissing;
    }

    public HBaseExportBuilder setFilterIfMissing(Boolean filterIfMissing) {
        this.filterIfMissing = filterIfMissing;
        return this;
    }

    public String getIncrementFamilyName() {
        return this.incrementFamilyName;
    }

    public HBaseExportBuilder setIncrementFamilyName(String incrementFamilyName) {
        this.incrementFamilyName = incrementFamilyName;
        return this;
    }

    public Long getStartTimestamp() {
        return this.startTimestamp;
    }

    public HBaseExportBuilder setStartTimestamp(Long startTimestamp) {
        this.startTimestamp = startTimestamp;
        return this;
    }

    public Long getEndTimestamp() {
        return this.endTimestamp;
    }

    public HBaseExportBuilder setEndTimestamp(Long endTimestamp) {
        this.endTimestamp = endTimestamp;
        return this;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public HBaseExportBuilder setFilter(Filter filter) {
        this.filter = filter;
        return this;
    }
}

