/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.nosql.hbase.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.frameworkset.nosql.hbase.HBaseAsyncOperation;

public class HBaseAsyncOperationMetrics
implements MetricSet {
    private static final String HBASE_ASYNC_OPS = "hbase.async.ops";
    private static final String COUNT = "hbase.async.ops.count";
    private static final String REJECTED_COUNT = "hbase.async.ops.rejected.count";
    private static final String FAILED_COUNT = "hbase.async.ops.failed.count";
    private static final String WAITING_COUNT = "hbase.async.ops.waiting.count";
    private static final String AVERAGE_LATENCY = "hbase.async.ops.latency.value";
    private static final String REGION_SERVER_COUNT = "hbase.async.ops.region.count";
    private static final String REGION_SERVER_FAILED_COUNT = "hbase.async.ops.region.failed.count";
    private static final String REGION_SERVER_AVERAGE_LATENCY = "hbase.async.ops.region.latency.value";
    private final HBaseAsyncOperation hBaseAsyncOperation;

    public HBaseAsyncOperationMetrics(HBaseAsyncOperation hBaseAsyncOperation) {
        if (hBaseAsyncOperation == null) {
            throw new NullPointerException("null");
        }
        this.hBaseAsyncOperation = hBaseAsyncOperation;
    }

    public Map<String, Metric> getMetrics() {
        if (!this.hBaseAsyncOperation.isAvailable()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> gauges = new HashMap<String, Object>(3);
        gauges.put(COUNT, new Gauge<Long>(){

            public Long getValue() {
                return HBaseAsyncOperationMetrics.this.hBaseAsyncOperation.getOpsCount();
            }
        });
        gauges.put(REJECTED_COUNT, new Gauge<Long>(){

            public Long getValue() {
                return HBaseAsyncOperationMetrics.this.hBaseAsyncOperation.getOpsRejectedCount();
            }
        });
        gauges.put(FAILED_COUNT, new Gauge<Long>(){

            public Long getValue() {
                return HBaseAsyncOperationMetrics.this.hBaseAsyncOperation.getOpsFailedCount();
            }
        });
        gauges.put(WAITING_COUNT, new Gauge<Long>(){

            public Long getValue() {
                return HBaseAsyncOperationMetrics.this.hBaseAsyncOperation.getCurrentOpsCount();
            }
        });
        gauges.put(AVERAGE_LATENCY, new Gauge<Long>(){

            public Long getValue() {
                return HBaseAsyncOperationMetrics.this.hBaseAsyncOperation.getOpsAverageLatency();
            }
        });
        gauges.put(REGION_SERVER_COUNT, new Gauge<Map>(){

            public Map getValue() {
                return HBaseAsyncOperationMetrics.this.hBaseAsyncOperation.getCurrentOpsCountForEachRegionServer();
            }
        });
        gauges.put(REGION_SERVER_FAILED_COUNT, new Gauge<Map<String, Long>>(){

            public Map<String, Long> getValue() {
                return HBaseAsyncOperationMetrics.this.hBaseAsyncOperation.getOpsFailedCountForEachRegionServer();
            }
        });
        gauges.put(REGION_SERVER_AVERAGE_LATENCY, new Gauge<Map<String, Long>>(){

            public Map<String, Long> getValue() {
                return HBaseAsyncOperationMetrics.this.hBaseAsyncOperation.getOpsAverageLatencyForEachRegionServer();
            }
        });
        return Collections.unmodifiableMap(gauges);
    }
}

