/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.nosql.hbase.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Slf4jReporter;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.frameworkset.LoggerUtils;
import org.frameworkset.nosql.hbase.HBaseAsyncOperation;
import org.frameworkset.nosql.hbase.metrics.HBaseAsyncOperationMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectorMetric {
    public static final String REPORTER_LOGGER_NAME = "org.frameworkset.nosql.hbase.StateReport";
    private final Logger reporterLogger = LoggerFactory.getLogger((String)"org.frameworkset.nosql.hbase.StateReport");
    private MetricRegistry metricRegistry;
    private HBaseAsyncOperationMetrics hBaseAsyncOperationMetrics;
    private HBaseAsyncOperation hBaseAsyncOperation;
    private ScheduledReporter reporter;
    private final boolean isEnable = this.isEnable0("org.frameworkset.nosql.hbase.StateReport");

    public void start(HBaseAsyncOperation hBaseAsyncOperation) {
        this.initRegistry(hBaseAsyncOperation);
        this.initReporters();
    }

    public boolean isEnable() {
        return this.isEnable;
    }

    private boolean isEnable0(String loggerName) {
        Logger logger = LoggerFactory.getLogger((String)loggerName);
        int loggerLevel = LoggerUtils.getLoggerLevel(logger);
        return loggerLevel < 30;
    }

    private void initRegistry(HBaseAsyncOperation hBaseAsyncOperation) {
        this.hBaseAsyncOperation = hBaseAsyncOperation;
        if (this.metricRegistry == null) {
            this.metricRegistry = new MetricRegistry();
        }
        if (this.hBaseAsyncOperationMetrics == null) {
            this.hBaseAsyncOperationMetrics = new HBaseAsyncOperationMetrics(hBaseAsyncOperation);
        }
        if (this.hBaseAsyncOperationMetrics != null) {
            Map<String, Metric> metrics = this.hBaseAsyncOperationMetrics.getMetrics();
            for (Map.Entry<String, Metric> metric : metrics.entrySet()) {
                this.metricRegistry.register(metric.getKey(), metric.getValue());
            }
        }
    }

    private void initReporters() {
        Slf4jReporter.Builder builder = Slf4jReporter.forRegistry((MetricRegistry)this.metricRegistry);
        builder.convertRatesTo(TimeUnit.SECONDS);
        builder.convertDurationsTo(TimeUnit.MILLISECONDS);
        builder.outputTo(this.reporterLogger);
        this.reporter = builder.build();
        this.reporter.start(60L, TimeUnit.SECONDS);
    }

    public void shutdown() {
        try {
            if (this.reporter == null) {
                return;
            }
            this.reporter.stop();
            this.reporter = null;
        }
        catch (Exception e) {
            this.reporterLogger.warn("", (Throwable)e);
        }
    }
}

