/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.nosql.hbase;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Table;
import org.frameworkset.nosql.hbase.HbaseSystemException;
import org.frameworkset.nosql.hbase.Objects;
import org.frameworkset.nosql.hbase.TableFactory;

public class HbaseTableFactory
implements TableFactory {
    private final Connection connection;

    public HbaseTableFactory(Connection connection) {
        this.connection = Objects.requireNonNull(connection, "connection must not be null");
    }

    @Override
    public Table getTable(TableName tableName) {
        try {
            return this.connection.getTable(tableName);
        }
        catch (IOException e) {
            throw new HbaseSystemException(e);
        }
    }

    @Override
    public Table getTable(TableName tableName, ExecutorService executorService) {
        try {
            return this.connection.getTable(tableName, executorService);
        }
        catch (IOException e) {
            throw new HbaseSystemException(e);
        }
    }

    @Override
    public void releaseTable(Table table) {
        if (table == null) {
            return;
        }
        try {
            table.close();
        }
        catch (IOException ex) {
            throw new HbaseSystemException(ex);
        }
    }
}

