/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.nosql.hbase;

import java.nio.charset.Charset;
import org.apache.hadoop.conf.Configuration;
import org.frameworkset.nosql.hbase.Charsets;
import org.frameworkset.nosql.hbase.TableFactory;

public abstract class HbaseAccessor {
    private String encoding;
    private static final Charset CHARSET = Charsets.UTF_8;
    private TableFactory tableFactory;
    private Configuration configuration;

    public void setTableFactory(TableFactory tableFactory) {
        this.tableFactory = tableFactory;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public TableFactory getTableFactory() {
        return this.tableFactory;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Charset getCharset() {
        return HbaseAccessor.hasText(this.encoding) ? Charset.forName(this.encoding) : CHARSET;
    }

    public static boolean hasText(String str) {
        return HbaseAccessor.hasLength(str) && HbaseAccessor.containsText(str);
    }

    private static boolean containsText(CharSequence str) {
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLength(String str) {
        return str != null && !str.isEmpty();
    }
}

