/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.nosql.hbase;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.HTableMultiplexer;
import org.apache.hadoop.hbase.client.Put;
import org.frameworkset.nosql.hbase.HBaseAsyncOperation;

public class HBaseAsyncTemplate
implements HBaseAsyncOperation {
    private final HTableMultiplexer hTableMultiplexer;
    private final AtomicInteger opsCount = new AtomicInteger();
    private final AtomicInteger opsRejectCount = new AtomicInteger();

    public HBaseAsyncTemplate(Configuration conf, int perRegionServerBufferQueueSize) throws IOException {
        this.hTableMultiplexer = new HTableMultiplexer(conf, perRegionServerBufferQueueSize);
    }

    public HBaseAsyncTemplate(Connection connection, Configuration conf, int perRegionServerBufferQueueSize) throws IOException {
        this.hTableMultiplexer = new HTableMultiplexer(connection, conf, perRegionServerBufferQueueSize);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean put(TableName tableName, Put put) {
        this.opsCount.incrementAndGet();
        boolean success = this.hTableMultiplexer.put(tableName, put);
        if (!success) {
            this.opsRejectCount.incrementAndGet();
        }
        return success;
    }

    @Override
    public List<Put> put(TableName tableName, List<Put> puts) {
        this.opsCount.addAndGet(puts.size());
        List rejectPuts = this.hTableMultiplexer.put(tableName, puts);
        if (rejectPuts != null && rejectPuts.size() > 0) {
            this.opsRejectCount.addAndGet(rejectPuts.size());
        }
        return rejectPuts;
    }

    @Override
    public Long getOpsCount() {
        return this.opsCount.longValue();
    }

    @Override
    public Long getOpsRejectedCount() {
        return this.opsRejectCount.longValue();
    }

    @Override
    public Long getCurrentOpsCount() {
        return this.hTableMultiplexer.getHTableMultiplexerStatus().getTotalBufferedCounter();
    }

    @Override
    public Long getOpsFailedCount() {
        return this.hTableMultiplexer.getHTableMultiplexerStatus().getTotalFailedCounter();
    }

    @Override
    public Long getOpsAverageLatency() {
        return this.hTableMultiplexer.getHTableMultiplexerStatus().getOverallAverageLatency();
    }

    @Override
    public Map<String, Long> getCurrentOpsCountForEachRegionServer() {
        return this.hTableMultiplexer.getHTableMultiplexerStatus().getBufferedCounterForEachRegionServer();
    }

    @Override
    public Map<String, Long> getOpsFailedCountForEachRegionServer() {
        return this.hTableMultiplexer.getHTableMultiplexerStatus().getFailedCounterForEachRegionServer();
    }

    @Override
    public Map<String, Long> getOpsAverageLatencyForEachRegionServer() {
        return this.hTableMultiplexer.getHTableMultiplexerStatus().getAverageLatencyForEachRegionServer();
    }
}

