/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.nosql.hbase;

import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.frameworkset.nosql.hbase.AdminCallback;
import org.frameworkset.nosql.hbase.AdminFactory;
import org.frameworkset.nosql.hbase.HbaseSystemException;
import org.frameworkset.nosql.hbase.Objects;

public class HBaseAdminTemplate {
    private final AdminFactory adminFactory;

    public HBaseAdminTemplate(AdminFactory adminFactory) {
        this.adminFactory = Objects.requireNonNull(adminFactory, "adminFactory must not be null");
    }

    public boolean createTableIfNotExists(final HTableDescriptor htd) {
        return this.execute(new AdminCallback<Boolean>(){

            @Override
            public Boolean doInAdmin(Admin admin) throws Throwable {
                TableName tableName = htd.getTableName();
                if (!admin.tableExists(tableName)) {
                    admin.createTable((TableDescriptor)htd);
                    return true;
                }
                return false;
            }
        });
    }

    public boolean tableExists(final TableName tableName) {
        return this.execute(new AdminCallback<Boolean>(){

            @Override
            public Boolean doInAdmin(Admin admin) throws Throwable {
                return admin.tableExists(tableName);
            }
        });
    }

    public boolean dropTableIfExists(final TableName tableName) {
        return this.execute(new AdminCallback<Boolean>(){

            @Override
            public Boolean doInAdmin(Admin admin) throws Throwable {
                if (admin.tableExists(tableName)) {
                    admin.disableTable(tableName);
                    admin.deleteTable(tableName);
                    return true;
                }
                return false;
            }
        });
    }

    public void dropTable(final TableName tableName) {
        this.execute(new AdminCallback<Void>(){

            @Override
            public Void doInAdmin(Admin admin) throws Throwable {
                admin.disableTable(tableName);
                admin.deleteTable(tableName);
                return null;
            }
        });
    }

    public final <T> T execute(AdminCallback<T> action) {
        Objects.requireNonNull(action, "action must not be null");
        Admin admin = this.adminFactory.getAdmin();
        try {
            T t = action.doInAdmin(admin);
            return t;
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new HbaseSystemException((Exception)e);
        }
        finally {
            this.adminFactory.releaseAdmin(admin);
        }
    }
}

