/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.input.file;

import java.io.File;
import java.io.FilenameFilter;
import org.frameworkset.tran.input.file.FileConfig;
import org.frameworkset.tran.input.file.FileListenerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogDirScanThread
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(LogDirScanThread.class);
    private final long interval;
    private FileConfig fileConfig;
    private Thread thread = null;
    private volatile boolean running = false;
    private FileListenerService fileListenerService;

    public LogDirScanThread(long interval, FileConfig fileConfig, FileListenerService fileListenerService) {
        this.interval = interval;
        this.fileConfig = fileConfig;
        this.fileListenerService = fileListenerService;
    }

    public long getInterval() {
        return this.interval;
    }

    public synchronized void start() throws IllegalStateException {
        if (this.running) {
            throw new IllegalStateException("Monitor is already running");
        }
        this.running = true;
        this.thread = new Thread((Runnable)this, "LogFile-Change-monitor");
        this.thread.start();
    }

    public synchronized void stop() throws Exception {
        this.stop(this.interval);
    }

    public synchronized void stop(long stopInterval) throws Exception {
        if (!this.running) {
            throw new IllegalStateException("Monitor is not running");
        }
        this.running = false;
        try {
            this.thread.interrupt();
            this.thread.join(stopInterval);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void run() {
        while (this.running) {
            this.checkAndNotify();
            if (!this.running) break;
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void checkAndNotify() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("scan new log file in dir {} with filename regex {}.", (Object)this.fileConfig.getLogDir(), (Object)this.fileConfig.getFileNameRegular());
        }
        File logDir = this.fileConfig.getLogDir();
        FilenameFilter filter = this.fileConfig.getFilter();
        if (logDir.isDirectory() && logDir.exists()) {
            File[] files = logDir.listFiles(filter);
            File file = null;
            for (int i = 0; files != null && i < files.length; ++i) {
                file = files[i];
                if (!file.isFile() || !file.exists()) continue;
                this.fileListenerService.checkNewFile(file, this.fileConfig);
            }
        } else {
            this.logger.info("{} must be a directory or must be exists.", (Object)this.fileConfig.getSourcePath());
        }
    }
}

