/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.input.file;

import com.frameworkset.util.BaseSimpleStringUtil;
import com.frameworkset.util.SimpleStringUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.frameworkset.tran.BaseDataTran;
import org.frameworkset.tran.Data;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.Record;
import org.frameworkset.tran.file.monitor.FileInodeHandler;
import org.frameworkset.tran.input.file.FileConfig;
import org.frameworkset.tran.input.file.FileListenerService;
import org.frameworkset.tran.input.file.FileLogRecord;
import org.frameworkset.tran.record.CommonData;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.util.TranUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileReaderTask {
    private static Logger logger = LoggerFactory.getLogger(FileReaderTask.class);
    private File file;
    private String fileId;
    private long pointer;
    private FileListenerService fileListenerService;
    private Pattern pattern;
    private boolean rootLevel;
    private boolean enableMeta;
    private String charsetEncode;
    private String filePath;
    private BaseDataTran fileDataTran;
    private RandomAccessFile raf;
    public static final int STATUS_OK = 0;
    public static final int STATUS_NO = 1;
    private int status = 0;
    private Status currentStatus;
    private volatile boolean taskEnded;
    private boolean jsondata;
    private FileConfig fileConfig;
    private Thread worker;
    private long oldLastModifyTime = -1L;
    private long checkFileModifyInterval = 3000L;

    public FileReaderTask(File file, String fileId, FileConfig fileConfig, FileListenerService fileListenerService, BaseDataTran fileDataTran, Status currentStatus) {
        this.file = file;
        this.filePath = FileInodeHandler.change(file.getAbsolutePath());
        this.pointer = 0L;
        this.fileId = fileId;
        this.fileListenerService = fileListenerService;
        if (fileConfig.getFileHeadLineRexPattern() != null) {
            this.pattern = fileConfig.getFileHeadLineRexPattern();
        }
        this.rootLevel = this.fileListenerService.getFileImportContext().getFileImportConfig().isRootLevel();
        this.jsondata = this.fileListenerService.getFileImportContext().getFileImportConfig().isJsondata();
        this.charsetEncode = this.fileListenerService.getFileImportContext().getFileImportConfig().getCharsetEncode();
        this.enableMeta = this.fileListenerService.getFileImportContext().getFileImportConfig().isEnableMeta();
        this.checkFileModifyInterval = this.fileListenerService.getFileImportContext().getFileImportConfig().getCheckFileModifyInterval();
        this.fileDataTran = fileDataTran;
        this.currentStatus = currentStatus;
        this.fileConfig = fileConfig;
    }

    public FileReaderTask(String fileId, Status currentStatus) {
        this.fileId = fileId;
        this.currentStatus = currentStatus;
    }

    public int fileExist(String logFileId) {
        if (!this.fileConfig.isEnableInode()) {
            return 1;
        }
        File logDir = this.fileConfig.getLogDir();
        FilenameFilter filter = this.fileConfig.getFilter();
        try {
            if (logDir.isDirectory() && logDir.exists()) {
                File[] files = logDir.listFiles(filter);
                File file = null;
                for (int i = 0; files != null && i < files.length; ++i) {
                    file = files[i];
                    String fileId = FileInodeHandler.inode(file, this.fileConfig.isEnableInode());
                    if (!fileId.equals(logFileId)) continue;
                    return 2;
                }
            }
            return 1;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public boolean fileRenamed(File logFile) {
        if (!this.fileConfig.isEnableInode()) {
            return false;
        }
        String logFileId = FileInodeHandler.inode(logFile, this.fileConfig.isEnableInode());
        return !this.fileId.equals(logFileId);
    }

    public FileReaderTask(File file, String fileId, FileConfig fileConfig, long pointer, FileListenerService fileListenerService, BaseDataTran fileDataTran, Status currentStatus) {
        this(file, fileId, fileConfig, fileListenerService, fileDataTran, currentStatus);
        this.pointer = pointer;
    }

    public void start() {
        this.worker = new Thread((Runnable)new Work(), "FileReaderTask-Thread");
        this.worker.start();
    }

    public String getFilePath() {
        return this.filePath;
    }

    public boolean isEnableInode() {
        return this.fileConfig.isEnableInode();
    }

    public Status getCurrentStatus() {
        return this.currentStatus;
    }

    public final Line readLine(long startPointer) throws IOException {
        StringBuilder input = new StringBuilder();
        int c = -1;
        boolean eol = false;
        block4: while (!eol) {
            c = this.raf.read();
            switch (c) {
                case -1: 
                case 10: {
                    eol = true;
                    continue block4;
                }
                case 13: {
                    eol = true;
                    long cur = this.raf.getFilePointer();
                    if (this.raf.read() == 10) continue block4;
                    this.raf.seek(cur);
                    continue block4;
                }
            }
            input.append((char)c);
        }
        if (c == -1) {
            if (input.length() == 0) {
                return new Line(null, true, true);
            }
            if (this.fileConfig.isCloseEOF()) {
                return new Line(input.toString(), true, false);
            }
            this.raf.seek(startPointer);
            return new Line(null, true, false);
        }
        return new Line(input.toString(), false, eol);
    }

    private boolean reachEOFClosed(Line line) {
        return this.fileConfig.isCloseEOF() && line.isEof();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void execute() {
        reachEOFClosed = false;
        try {
            if (this.taskEnded) {
                return;
            }
            if (this.raf == null) {
                raf = new RandomAccessFile(this.file, "r");
                if (this.pointer > raf.length()) {
                    this.pointer = 0L;
                    this.currentStatus.setLastValue((Object)0L);
                }
                raf.seek(this.pointer);
                this.raf = raf;
            }
            builder = new StringBuilder();
            line = null;
            recordList /* !! */  = new ArrayList<Record>();
            fetchSize = this.fileListenerService.getFileImportContext().getFetchSize();
            startPointer = this.pointer;
            do lbl-1000:
            // 3 sources

            {
                block27: {
                    line_ = this.readLine(startPointer);
                    reachEOFClosed = this.reachEOFClosed(line_);
                    if (line_.getLine() == null) break;
                    line = line_.getLine();
                    if (this.charsetEncode != null) {
                        line = new String(line.getBytes("ISO-8859-1"), this.charsetEncode);
                    }
                    if (null == this.pattern) break block27;
                    m = this.pattern.matcher(line);
                    if (m.find() && builder.length() > 0) {
                        this.pointer = this.raf.getFilePointer();
                        this.result(this.file, this.pointer, builder.toString(), recordList /* !! */ , reachEOFClosed);
                        startPointer = this.pointer;
                        if (fetchSize > 0 && recordList /* !! */ .size() >= fetchSize) {
                            this.fileDataTran.appendData((Data)new CommonData(recordList /* !! */ ));
                            recordList /* !! */  = new ArrayList<E>();
                        }
                        builder.setLength(0);
                    }
                    if (builder.length() > 0) {
                        builder.append(TranUtil.lineSeparator);
                    }
                    builder.append(line);
                    if (!reachEOFClosed) ** GOTO lbl-1000
                    this.pointer = this.raf.getFilePointer();
                    this.result(this.file, this.pointer, builder.toString(), recordList /* !! */ , reachEOFClosed);
                    startPointer = this.pointer;
                    builder.setLength(0);
                    break;
                }
                this.pointer = this.raf.getFilePointer();
                this.result(this.file, this.pointer, line, recordList /* !! */ , reachEOFClosed);
                startPointer = this.pointer;
                if (fetchSize <= 0 || recordList /* !! */ .size() < fetchSize) continue;
                this.fileDataTran.appendData((Data)new CommonData(recordList /* !! */ ));
                recordList /* !! */  = new ArrayList<E>();
            } while (!reachEOFClosed);
            if (builder.length() > 0) {
                if (!line_.isRollbackPreLine()) {
                    this.pointer = this.raf.getFilePointer();
                    this.result(this.file, this.pointer, builder.toString(), recordList /* !! */ , reachEOFClosed);
                }
                builder.setLength(0);
                builder = null;
            }
            if (recordList /* !! */ .size() > 0) {
                this.fileDataTran.appendData((Data)new CommonData(recordList /* !! */ ));
            }
            if (reachEOFClosed) {
                if (FileReaderTask.logger.isInfoEnabled()) {
                    FileReaderTask.logger.info("{} reached eof and will be closed.", (Object)this.toString());
                }
                this.fileListenerService.moveTaskToComplete(this);
                this.taskEnded();
            }
        }
        catch (Exception e) {
            throw new DataImportException("", (Throwable)e);
        }
        finally {
            this.destroy();
            try {
                if (reachEOFClosed && this.fileConfig.isDeleteEOFFile()) {
                    this.file.delete();
                }
            }
            catch (Exception var11_13) {}
        }
    }

    public void destroy() {
        if (this.raf != null) {
            try {
                this.raf.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.raf = null;
        }
    }

    private boolean check(String line) {
        Pattern[] includes = this.fileConfig.getIncludeLinesRexPattern();
        Pattern[] excludes = this.fileConfig.getExcludeLinesRexPattern();
        if (includes != null && includes.length > 0) {
            Pattern inc;
            boolean find = false;
            Pattern[] patternArray = includes;
            int n = patternArray.length;
            for (int i = 0; i < n && !(find = (inc = patternArray[i]).matcher(line).find()); ++i) {
            }
            if (find && excludes != null && excludes.length > 0) {
                for (Pattern exc : excludes) {
                    if (!exc.matcher(line).find()) continue;
                    find = false;
                    break;
                }
            }
            return find;
        }
        boolean find = true;
        if (excludes != null && excludes.length > 0) {
            for (Pattern exc : excludes) {
                if (!exc.matcher(line).find()) continue;
                find = false;
                break;
            }
        }
        return find;
    }

    private String checkMaxLength(String line) {
        int maxLength = this.fileConfig.getMaxBytes();
        if (line.length() > maxLength) {
            line = line.substring(0, maxLength);
        }
        return line;
    }

    private void result(File file, long pointer, String line, List<Record> recordList, boolean reachEOFClosed) {
        if (!this.check(line)) {
            recordList.add((Record)new FileLogRecord(true, pointer, reachEOFClosed));
        } else {
            HashMap<String, Object> result;
            block13: {
                result = new HashMap<String, Object>();
                try {
                    if (this.jsondata) {
                        Map<String, Object> ignoreFields;
                        Map json = (Map)SimpleStringUtil.json2Object((String)line, Map.class);
                        Map<String, Object> addFields = this.fileConfig.getAddFields();
                        if (addFields != null && addFields.size() > 0) {
                            json.putAll(addFields);
                        }
                        if ((ignoreFields = this.fileConfig.getIgnoreFields()) != null && ignoreFields.size() > 0) {
                            Iterator<String> iterator = ignoreFields.keySet().iterator();
                            while (iterator.hasNext()) {
                                json.remove(iterator.next());
                            }
                        }
                        if (this.rootLevel) {
                            result = json;
                        } else {
                            result.put("json", json);
                        }
                    } else {
                        line = this.checkMaxLength(line);
                        result.put("@message", line);
                        Map<String, Object> addFields = this.fileConfig.getAddFields();
                        if (addFields != null && addFields.size() > 0) {
                            result.putAll(addFields);
                        }
                    }
                }
                catch (Exception e) {
                    result.put("@message", line);
                    Map<String, Object> addFields = this.fileConfig.getAddFields();
                    if (addFields == null || addFields.size() <= 0) break block13;
                    result.putAll(addFields);
                }
            }
            Map common = this.common(file, pointer, result);
            if (this.enableMeta) {
                result.put("@filemeta", common);
            }
            recordList.add((Record)new FileLogRecord(common, result, pointer, reachEOFClosed));
        }
    }

    private Map common(File file, long pointer, Map result) {
        HashMap<String, Object> common = new HashMap<String, Object>();
        common.put("hostIp", BaseSimpleStringUtil.getIp());
        common.put("hostName", BaseSimpleStringUtil.getHostName());
        common.put("filePath", FileInodeHandler.change(file.getAbsolutePath()));
        common.put("timestamp", new Date());
        common.put("pointer", pointer);
        common.put("fileId", this.fileId);
        return common;
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void changeFile(File file) {
        this.file = file;
        if (this.currentStatus != null) {
            this.currentStatus.setFilePath(FileInodeHandler.change(file.getAbsolutePath()));
        }
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String toString() {
        return "{\"file\":\"" + FileInodeHandler.change(this.file.getAbsolutePath()) + "\",\"fileId\":\"" + this.fileId + "\",\"pointer\":" + this.pointer + "}";
    }

    public boolean isTaskEnded() {
        return this.taskEnded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskEnded() {
        if (this.taskEnded) {
            return;
        }
        FileReaderTask fileReaderTask = this;
        synchronized (fileReaderTask) {
            if (this.taskEnded) {
                return;
            }
            this.taskEnded = true;
            this.fileDataTran.stopTranOnly();
        }
    }

    public BaseDataTran getFileDataTran() {
        return this.fileDataTran;
    }

    class Line {
        private String line;
        private boolean eof;
        private boolean eol;

        Line(String line, boolean eof, boolean eol) {
            this.line = line;
            this.eof = eof;
            this.eol = eol;
        }

        public String getLine() {
            return this.line;
        }

        public boolean isEof() {
            return this.eof;
        }

        public boolean isRollbackPreLine() {
            return this.eof && !this.eol && !FileReaderTask.this.fileConfig.isCloseEOF();
        }
    }

    class Work
    implements Runnable {
        Work() {
        }

        @Override
        public void run() {
            boolean delete = false;
            while (!FileReaderTask.this.taskEnded && !FileReaderTask.this.fileListenerService.getBaseDataTranPlugin().checkTranToStop()) {
                if (FileReaderTask.this.file.exists()) {
                    long lastModifyTime = FileReaderTask.this.file.lastModified();
                    if (FileReaderTask.this.oldLastModifyTime == -1L) {
                        FileReaderTask.this.oldLastModifyTime = lastModifyTime;
                        FileReaderTask.this.execute();
                        continue;
                    }
                    if (FileReaderTask.this.oldLastModifyTime == lastModifyTime) {
                        try {
                            Thread.sleep(FileReaderTask.this.checkFileModifyInterval);
                            continue;
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                    if (FileReaderTask.this.fileRenamed(FileReaderTask.this.file)) {
                        try {
                            Thread.sleep(FileReaderTask.this.checkFileModifyInterval);
                            continue;
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                    FileReaderTask.this.oldLastModifyTime = lastModifyTime;
                    FileReaderTask.this.execute();
                    continue;
                }
                int lable = FileReaderTask.this.fileExist(FileReaderTask.this.fileId);
                if (lable == 1) {
                    FileReaderTask.this.fileListenerService.doDelete(FileReaderTask.this.fileId);
                    delete = true;
                    break;
                }
                try {
                    Thread.sleep(FileReaderTask.this.checkFileModifyInterval);
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            if (delete) {
                FileReaderTask.this.taskEnded();
            }
        }
    }
}

