/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.input.file;

import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.frameworkset.tran.BaseDataTran;
import org.frameworkset.tran.file.monitor.FileInodeHandler;
import org.frameworkset.tran.input.file.FileBaseDataTranPlugin;
import org.frameworkset.tran.input.file.FileConfig;
import org.frameworkset.tran.input.file.FileImportContext;
import org.frameworkset.tran.input.file.FileReaderTask;
import org.frameworkset.tran.schedule.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileListenerService {
    private static Logger logger = LoggerFactory.getLogger(FileListenerService.class);
    private Map<String, FileReaderTask> fileConfigMap;
    private Map<String, FileReaderTask> completedTasks;
    private Map<String, FileReaderTask> oldedTasks;
    private FileImportContext fileImportContext;
    private FileBaseDataTranPlugin baseDataTranPlugin;
    private Lock lock = new ReentrantLock();

    public FileListenerService(FileImportContext fileImportContext, FileBaseDataTranPlugin baseDataTranPlugin) {
        this.fileConfigMap = new HashMap<String, FileReaderTask>();
        this.completedTasks = new HashMap<String, FileReaderTask>();
        this.oldedTasks = new HashMap<String, FileReaderTask>();
        this.fileImportContext = fileImportContext;
        this.baseDataTranPlugin = baseDataTranPlugin;
    }

    public void moveTaskToComplete(FileReaderTask fileReaderTask) {
        try {
            this.lock.lock();
            this.fileConfigMap.remove(fileReaderTask.getFileId());
            this.completedTasks.put(fileReaderTask.getFileId(), fileReaderTask);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addCompletedFileTask(String fileId, FileReaderTask fileReaderTask) {
        try {
            this.lock.lock();
            this.completedTasks.put(fileId, fileReaderTask);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addOldedFileTask(String fileId, FileReaderTask fileReaderTask) {
        try {
            this.lock.lock();
            this.oldedTasks.put(fileId, fileReaderTask);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addFileTask(String fileId, FileReaderTask fileReaderTask) {
        try {
            this.lock.lock();
            this.fileConfigMap.put(fileId, fileReaderTask);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDelete(String fileId) {
        try {
            this.lock.lock();
            FileReaderTask fileReaderTask = this.fileConfigMap.remove(fileId);
            if (fileReaderTask != null) {
                this.completedTasks.put(fileId, fileReaderTask);
                fileReaderTask.taskEnded();
                final FileReaderTask fileReaderTask_ = fileReaderTask;
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        Status currentStatus = fileReaderTask_.getCurrentStatus();
                        FileListenerService.this.baseDataTranPlugin.forceflushLastValue(currentStatus);
                    }
                });
                thread.start();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public FileImportContext getFileImportContext() {
        return this.fileImportContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkTranFinished() {
        try {
            this.lock.lock();
            block5: for (Map.Entry<String, FileReaderTask> entry : this.fileConfigMap.entrySet()) {
                BaseDataTran baseDataTran = entry.getValue().getFileDataTran();
                if (baseDataTran.isTranFinished()) continue;
                while (!baseDataTran.isTranFinished()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        continue block5;
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkNewFile(File file, FileConfig fileConfig) {
        String fileId = FileInodeHandler.inode(file, fileConfig.isEnableInode());
        try {
            String filePath;
            String oldFilePath;
            this.lock.lock();
            FileReaderTask fileReaderTask = this.fileConfigMap.get(fileId);
            if (fileReaderTask == null) {
                if (this.completedTasks.containsKey(fileId)) {
                    return;
                }
                if (this.oldedTasks.containsKey(fileId)) {
                    return;
                }
                if (logger.isInfoEnabled()) {
                    logger.info("Start collect new log file {}", (Object)file.getAbsolutePath());
                }
                Status currentStatus = new Status();
                currentStatus.setId(Integer.valueOf(fileId.hashCode()));
                currentStatus.setTime(new Date().getTime());
                currentStatus.setFileId(fileId);
                currentStatus.setFilePath(FileInodeHandler.change(file.getAbsolutePath()));
                currentStatus.setStatus(0);
                long pointer = fileConfig.getStartPointer() != null && fileConfig.getStartPointer() > 0L ? fileConfig.getStartPointer() : 0L;
                currentStatus.setLastValue((Object)pointer);
                boolean bl = this.baseDataTranPlugin.initFileTask(fileConfig, currentStatus, file, pointer);
            } else if (fileReaderTask.isEnableInode() && !(oldFilePath = fileReaderTask.getFilePath()).equals(filePath = FileInodeHandler.change(file.getAbsolutePath()))) {
                if (logger.isInfoEnabled()) {
                    logger.info("Rename Log file {} to {}", (Object)oldFilePath, (Object)filePath);
                }
                fileReaderTask.changeFile(file);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public FileBaseDataTranPlugin getBaseDataTranPlugin() {
        return this.baseDataTranPlugin;
    }
}

