/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.input.file;

import java.util.ArrayList;
import java.util.List;
import org.frameworkset.tran.config.BaseImportConfig;
import org.frameworkset.tran.input.file.FileConfig;

public class FileImportConfig
extends BaseImportConfig {
    private Long interval = 5000L;
    private Long registLiveTime;
    private boolean rootLevel = true;
    private boolean jsondata;
    private boolean enableMeta;
    private String charsetEncode = "UTF-8";
    private List<FileConfig> fileConfigList;
    private long checkFileModifyInterval = 3000L;

    public List<FileConfig> getFileConfigList() {
        return this.fileConfigList;
    }

    public FileImportConfig addConfig(FileConfig fileConfig) {
        if (this.fileConfigList == null) {
            this.fileConfigList = new ArrayList<FileConfig>();
        }
        fileConfig.init();
        this.fileConfigList.add(fileConfig);
        return this;
    }

    public FileImportConfig addConfig(String sourcePath, String fileNameRegular, String fileHeadLine) {
        if (this.fileConfigList == null) {
            this.fileConfigList = new ArrayList<FileConfig>();
        }
        this.fileConfigList.add(new FileConfig(sourcePath, fileNameRegular, fileHeadLine).init());
        return this;
    }

    public FileImportConfig addConfig(String sourcePath, String fileNameRegular, String fileHeadLine, boolean scanChild) {
        if (this.fileConfigList == null) {
            this.fileConfigList = new ArrayList<FileConfig>();
        }
        this.fileConfigList.add(new FileConfig(sourcePath, fileNameRegular, fileHeadLine, scanChild).init());
        return this;
    }

    public FileImportConfig setInterval(Long interval) {
        this.interval = interval;
        return this;
    }

    public Long getInterval() {
        return this.interval;
    }

    public boolean isRootLevel() {
        return this.rootLevel;
    }

    public boolean isJsondata() {
        return this.jsondata;
    }

    public FileImportConfig setRootLevel(boolean rootLevel) {
        this.rootLevel = rootLevel;
        return this;
    }

    public FileImportConfig setJsondata(boolean jsondata) {
        this.jsondata = jsondata;
        return this;
    }

    public String getCharsetEncode() {
        return this.charsetEncode;
    }

    public FileImportConfig setCharsetEncode(String charsetEncode) {
        this.charsetEncode = charsetEncode;
        return this;
    }

    public boolean isEnableMeta() {
        return this.enableMeta;
    }

    public FileImportConfig setEnableMeta(boolean enableMeta) {
        this.enableMeta = enableMeta;
        return this;
    }

    public Long getRegistLiveTime() {
        return this.registLiveTime;
    }

    public FileImportConfig setRegistLiveTime(Long registLiveTime) {
        this.registLiveTime = registLiveTime;
        return this;
    }

    public long getCheckFileModifyInterval() {
        return this.checkFileModifyInterval;
    }

    public FileImportConfig setCheckFileModifyInterval(long checkFileModifyInterval) {
        this.checkFileModifyInterval = checkFileModifyInterval;
        return this;
    }
}

