/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.input.file;

import com.frameworkset.util.SimpleStringUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.frameworkset.tran.file.monitor.FileInodeHandler;
import org.frameworkset.util.OSInfo;

public class FileConfig {
    private String sourcePath;
    private boolean deleteEOFFile;
    private String normalSourcePath;
    private Pattern normalSourcePathPattern;
    private String fileNameRegular;
    private Pattern fileNameRexPattern;
    private String fileHeadLineRegular;
    private Pattern fileHeadLineRexPattern;
    private String[] includeLines;
    private Pattern[] includeLinesRexPattern;
    private String[] excludeLines;
    private Pattern[] excludeLinesRexPattern;
    private int maxBytes = 0x100000;
    private boolean closeEOF;
    private Long startPointer;
    private boolean enableInode = true;
    private Long ignoreOlderTime;
    private Long closeOlderTime;
    private boolean scanChild;
    private FilenameFilter filter;
    private File logDir;
    private Map<String, Object> addFields;
    private Map<String, Object> ignoreFields;
    private boolean inited = false;

    public Long getIgnoreOlderTime() {
        return this.ignoreOlderTime;
    }

    public void setIgnoreOlderTime(Long ignoreOlderTime) {
        this.ignoreOlderTime = ignoreOlderTime;
    }

    public Long getCloseOlderTime() {
        return this.closeOlderTime;
    }

    public void setCloseOlderTime(Long closeOlderTime) {
        this.closeOlderTime = closeOlderTime;
    }

    public FileConfig(String sourcePath, String fileNameRegular, String fileHeadLineRegular) {
        this.sourcePath = sourcePath;
        this.normalSourcePath = SimpleStringUtil.getPath((String)FileInodeHandler.change(sourcePath).toLowerCase(), (String)fileNameRegular);
        this.fileNameRegular = fileNameRegular;
        this.fileHeadLineRegular = fileHeadLineRegular;
    }

    public FileConfig(String sourcePath, String fileNameRegular, String fileHeadLineRegular, boolean scanChild) {
        this.sourcePath = sourcePath;
        this.normalSourcePath = SimpleStringUtil.getPath((String)FileInodeHandler.change(sourcePath).toLowerCase(), (String)fileNameRegular);
        this.fileNameRegular = fileNameRegular;
        this.fileHeadLineRegular = fileHeadLineRegular;
        this.scanChild = scanChild;
    }

    public FileConfig addField(String name, Object value) {
        if (this.addFields == null) {
            this.addFields = new HashMap<String, Object>();
        }
        this.addFields.put(name, value);
        return this;
    }

    public Map<String, Object> getAddFields() {
        return this.addFields;
    }

    public Map<String, Object> getIgnoreFields() {
        return this.ignoreFields;
    }

    public FileConfig ignoreField(String name) {
        if (this.ignoreFields == null) {
            this.ignoreFields = new HashMap<String, Object>();
        }
        this.ignoreFields.put(name, 1);
        return this;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public FileConfig setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
        return this;
    }

    public String getFileNameRegular() {
        return this.fileNameRegular;
    }

    public FileConfig setFileNameRegular(String fileNameRegular) {
        this.fileNameRegular = fileNameRegular;
        return this;
    }

    public Pattern getFileHeadLineRexPattern() {
        return this.fileHeadLineRexPattern;
    }

    public Pattern getFileNameRexPattern() {
        return this.fileNameRexPattern;
    }

    public Pattern[] getExcludeLinesRexPattern() {
        return this.excludeLinesRexPattern;
    }

    public Pattern[] getIncludeLinesRexPattern() {
        return this.includeLinesRexPattern;
    }

    public String getFileHeadLineRegular() {
        return this.fileHeadLineRegular;
    }

    public FileConfig setFileHeadLineRegular(String fileHeadLineRegular) {
        this.fileHeadLineRegular = fileHeadLineRegular;
        return this;
    }

    public boolean isScanChild() {
        return this.scanChild;
    }

    public String getNormalSourcePath() {
        return this.normalSourcePath;
    }

    public FileConfig setNormalSourcePath(String normalSourcePath) {
        this.normalSourcePath = normalSourcePath;
        return this;
    }

    public String[] getIncludeLines() {
        return this.includeLines;
    }

    public FileConfig setIncludeLines(String[] includeLines) {
        this.includeLines = includeLines;
        return this;
    }

    public String[] getExcludeLines() {
        return this.excludeLines;
    }

    public FileConfig setExcludeLines(String[] excludeLines) {
        this.excludeLines = excludeLines;
        return this;
    }

    public int getMaxBytes() {
        return this.maxBytes;
    }

    public FileConfig setMaxBytes(int maxBytes) {
        this.maxBytes = maxBytes;
        return this;
    }

    public boolean isCloseEOF() {
        return this.closeEOF;
    }

    public FileConfig setCloseEOF(boolean closeEOF) {
        this.closeEOF = closeEOF;
        return this;
    }

    public Long getStartPointer() {
        return this.startPointer;
    }

    public FileConfig setStartPointer(Long startPointer) {
        this.startPointer = startPointer;
        return this;
    }

    public FileConfig init() {
        int i;
        if (this.inited) {
            return this;
        }
        this.inited = true;
        this.normalSourcePathPattern = Pattern.compile(this.normalSourcePath);
        if (StringUtils.isNotEmpty((String)this.fileHeadLineRegular)) {
            this.fileHeadLineRexPattern = Pattern.compile(this.fileHeadLineRegular);
        }
        if (StringUtils.isNotEmpty((String)this.fileNameRegular)) {
            this.fileNameRexPattern = Pattern.compile(this.fileNameRegular);
        }
        if (this.includeLines != null && this.includeLines.length > 0) {
            this.includeLinesRexPattern = new Pattern[this.includeLines.length];
            for (i = 0; i < this.includeLines.length; ++i) {
                this.includeLinesRexPattern[i] = Pattern.compile(this.includeLines[i]);
            }
        }
        if (this.excludeLines != null && this.excludeLines.length > 0) {
            this.excludeLinesRexPattern = new Pattern[this.excludeLines.length];
            for (i = 0; i < this.excludeLines.length; ++i) {
                this.excludeLinesRexPattern[i] = Pattern.compile(this.excludeLines[i]);
            }
        }
        this.logDir = new File(this.sourcePath);
        this.filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                Matcher m = FileConfig.this.getFileNameRexPattern().matcher(name);
                return m.matches();
            }
        };
        if (OSInfo.isWindows()) {
            this.enableInode = false;
        }
        return this;
    }

    public File getLogDir() {
        return this.logDir;
    }

    public FilenameFilter getFilter() {
        return this.filter;
    }

    public Pattern getNormalSourcePathPattern() {
        return this.normalSourcePathPattern;
    }

    public boolean isEnableInode() {
        return this.enableInode;
    }

    public FileConfig setEnableInode(boolean enableInode) {
        this.enableInode = enableInode;
        return this;
    }

    public boolean isDeleteEOFFile() {
        return this.deleteEOFFile;
    }

    public void setDeleteEOFFile(boolean deleteEOFFile) {
        this.deleteEOFFile = deleteEOFFile;
    }
}

