/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.input.file;

import com.frameworkset.common.poolman.SQLExecutor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.frameworkset.tran.BaseDataTran;
import org.frameworkset.tran.BaseDataTranPlugin;
import org.frameworkset.tran.ESDataImportException;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.file.monitor.FileInodeHandler;
import org.frameworkset.tran.input.file.FileConfig;
import org.frameworkset.tran.input.file.FileImportContext;
import org.frameworkset.tran.input.file.FileListenerService;
import org.frameworkset.tran.input.file.FileReaderTask;
import org.frameworkset.tran.input.file.FileResultSet;
import org.frameworkset.tran.input.file.LogDirScanThread;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;

public abstract class FileBaseDataTranPlugin
extends BaseDataTranPlugin {
    protected FileImportContext fileImportContext;
    protected FileListenerService fileListenerService;

    public FileBaseDataTranPlugin(ImportContext importContext, ImportContext targetImportContext) {
        super(importContext, targetImportContext);
        this.fileImportContext = (FileImportContext)importContext;
    }

    public boolean isMultiTran() {
        return true;
    }

    public void setFileListenerService(FileListenerService fileListenerService) {
        this.fileListenerService = fileListenerService;
    }

    public FileListenerService getFileListenerService() {
        return this.fileListenerService;
    }

    public void initLastValueClumnName() {
    }

    public Status getCurrentStatus() {
        throw new UnsupportedOperationException("getCurrentStatus");
    }

    public FileConfig getFileConfig(String filePath) {
        filePath = FileInodeHandler.change(filePath).toLowerCase();
        List<FileConfig> list = this.fileImportContext.getFileConfigList();
        for (FileConfig config : list) {
            Pattern source = config.getNormalSourcePathPattern();
            if (!source.matcher(filePath).matches()) continue;
            return config;
        }
        return null;
    }

    public boolean initFileTask(FileConfig fileConfig, Status status, File file, long pointer) {
        if (fileConfig == null) {
            return false;
        }
        this.addStatus(status);
        FileResultSet kafkaResultSet = new FileResultSet((ImportContext)this.fileImportContext);
        final BaseDataTran fileDataTran = this.createBaseDataTran(null, (TranResultSet)kafkaResultSet, status);
        Thread tranThread = null;
        try {
            if (fileDataTran != null) {
                tranThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        fileDataTran.tran();
                    }
                }, "file-log-tran");
                tranThread.start();
                String fileId = FileInodeHandler.inode(file, fileConfig.isEnableInode());
                FileReaderTask task = new FileReaderTask(file, fileId, fileConfig, pointer, this.fileListenerService, fileDataTran, status);
                this.fileListenerService.addFileTask(fileId, task);
                task.start();
            }
            return true;
        }
        catch (ESDataImportException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ESDataImportException((Throwable)e);
        }
    }

    private boolean isOlded(Status status, FileConfig fileConfig) {
        if (fileConfig.getIgnoreOlderTime() == null) {
            return false;
        }
        long lastTime = status.getTime();
        long oldedTime = fileConfig.getIgnoreOlderTime();
        long stopTime = System.currentTimeMillis() - oldedTime;
        return lastTime <= stopTime;
    }

    protected void loadCurrentStatus() {
        try {
            List statuses = SQLExecutor.queryListWithDBName(Status.class, (String)this.statusDbname, (String)this.selectAllSQL, (Object[])new Object[0]);
            if (statuses == null || statuses.size() == 0) {
                return;
            }
            boolean fromFirst = this.importContext.isFromFirst();
            ArrayList<Status> completed = new ArrayList<Status>();
            ArrayList<Status> olded = new ArrayList<Status>();
            for (Status status : statuses) {
                if (this.isComplete(status)) {
                    completed.add(status);
                    this.fileListenerService.addCompletedFileTask(status.getFileId(), new FileReaderTask(status.getFileId(), status));
                    continue;
                }
                String filePath = status.getFilePath();
                FileConfig fileConfig = this.getFileConfig(filePath);
                if (fileConfig == null) {
                    completed.add(status);
                    this.fileListenerService.addCompletedFileTask(status.getFileId(), new FileReaderTask(status.getFileId(), status));
                    continue;
                }
                if (this.isOlded(status, fileConfig)) {
                    olded.add(status);
                    this.fileListenerService.addOldedFileTask(status.getFileId(), new FileReaderTask(status.getFileId(), status));
                    continue;
                }
                FileResultSet kafkaResultSet = new FileResultSet((ImportContext)this.fileImportContext);
                final BaseDataTran fileDataTran = this.createBaseDataTran(null, (TranResultSet)kafkaResultSet, status);
                Thread tranThread = null;
                try {
                    if (fileDataTran == null) continue;
                    tranThread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            fileDataTran.tran();
                        }
                    }, "file-log-tran");
                    tranThread.start();
                    Object lastValue = status.getLastValue();
                    long pointer = 0L;
                    if (!fromFirst) {
                        if (lastValue instanceof Long) {
                            pointer = (Long)lastValue;
                        } else if (lastValue instanceof Integer) {
                            pointer = ((Integer)lastValue).longValue();
                        } else if (lastValue instanceof Short) {
                            pointer = ((Short)lastValue).longValue();
                        }
                    } else {
                        status.setLastValue((Object)0L);
                    }
                    FileReaderTask task = new FileReaderTask(new File(filePath), status.getFileId(), fileConfig, pointer, this.fileListenerService, fileDataTran, status);
                    this.fileListenerService.addFileTask(task.getFileId(), task);
                    task.start();
                }
                catch (ESDataImportException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ESDataImportException((Throwable)e);
                }
            }
            if (completed.size() > 0 && this.fileImportContext.getFileImportConfig().getRegistLiveTime() != null) {
                this.handleCompletedTasks(completed, false, this.fileImportContext.getFileImportConfig().getRegistLiveTime());
            }
            if (olded.size() > 0) {
                this.handleOldedTasks(olded);
            }
        }
        catch (ESDataImportException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ESDataImportException((Throwable)e);
        }
    }

    public void destroy(boolean waitTranStop) {
        this.status = 2;
        this.fileListenerService.checkTranFinished();
        super.destroy(false);
    }

    protected abstract BaseDataTran createBaseDataTran(TaskContext var1, TranResultSet var2, Status var3);

    public void beforeInit() {
    }

    protected void initFileListener(TaskContext taskContext) {
        if (this.fileImportContext.getFileImportConfig() != null) {
            List<FileConfig> fileConfigs = this.fileImportContext.getFileConfigList();
            for (FileConfig fileConfig : fileConfigs) {
                LogDirScanThread logDirScanThread = new LogDirScanThread(this.fileImportContext.getFileImportConfig().getInterval(), fileConfig, this.getFileListenerService());
                logDirScanThread.start();
            }
        }
    }

    public void afterInit() {
    }

    public void initStatusTableId() {
    }

    public void importData() throws ESDataImportException {
        long importStartTime = System.currentTimeMillis();
        this.doImportData(null);
        long importEndTime = System.currentTimeMillis();
        if (this.isPrintTaskLog()) {
            this.logger.info("Execute job Take " + (importEndTime - importStartTime) + " ms");
        }
    }

    public void doImportData(TaskContext taskContext) throws ESDataImportException {
        this.initFileListener(taskContext);
    }

    public void initSchedule() {
        this.logger.info("Ignore initSchedule for plugin {}", (Object)((Object)((Object)this)).getClass().getName());
    }
}

