/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.file.monitor;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import org.frameworkset.util.OSInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileInodeHandler {
    protected static Logger logger = LoggerFactory.getLogger(FileInodeHandler.class);

    public static String inode(File file) {
        return FileInodeHandler.inode(file, true);
    }

    public static String inode(File file, boolean enableInode) {
        String fileId = null;
        if (!OSInfo.isWindows() && enableInode) {
            try {
                BasicFileAttributes bfa = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                fileId = bfa.fileKey().toString();
                if (fileId != null) {
                    fileId = fileId.substring(1, fileId.length() - 1);
                    String[] arr = fileId.split(",");
                    String dev = null;
                    String ino = null;
                    for (String one : arr) {
                        String[] k_v = one.split("=");
                        if ("dev".equals(k_v[0])) {
                            dev = k_v[1];
                            continue;
                        }
                        ino = k_v[1];
                    }
                    fileId = dev + "|" + ino;
                }
            }
            catch (IOException e) {
                logger.error("inode error", (Throwable)e);
            }
        } else {
            fileId = FileInodeHandler.change(file.getAbsolutePath());
        }
        return fileId;
    }

    public static String change(String str) {
        return str.replaceAll("\\\\", "/");
    }
}

