/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.metrics.job;

import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.frameworkset.tran.metrics.entity.TimeMetric;
import org.frameworkset.tran.metrics.job.KeyTimeMetrics;

public class FlushOlder
extends Thread {
    private KeyTimeMetrics keyTimeMetrics;
    private boolean stop;
    private BlockingQueue<Map<String, Map<String, TimeMetric>>> queue = new ArrayBlockingQueue<Map<String, Map<String, TimeMetric>>>(5);

    public FlushOlder() {
        super("KeyTimeMetrics-FlushOlder");
    }

    public void setKeyTimeMetrics(KeyTimeMetrics keyTimeMetrics) {
        this.keyTimeMetrics = keyTimeMetrics;
    }

    public void add(Map<String, Map<String, TimeMetric>> timeMetrics) {
        try {
            this.queue.put(timeMetrics);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopFlush() {
        if (this.stop) {
            return;
        }
        FlushOlder flushOlder = this;
        synchronized (flushOlder) {
            if (this.stop) {
                return;
            }
            this.stop = true;
        }
        try {
            this.interrupt();
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        try {
            while (true) {
                Map<String, Map<String, TimeMetric>> timeMetrics;
                if ((timeMetrics = this.queue.poll(10L, TimeUnit.SECONDS)) != null) {
                    this.keyTimeMetrics.persistentOlder(timeMetrics);
                    continue;
                }
                if (this.stop) break;
            }
        }
        catch (InterruptedException e) {}
    }
}

