/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.task;

import com.frameworkset.orm.annotation.BatchContext;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.frameworkset.tran.BaseCommonRecordDataTran;
import org.frameworkset.tran.BaseDataTran;
import org.frameworkset.tran.CommonRecord;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.TranErrorWrapper;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.WaitTasksCompleteCallBack;
import org.frameworkset.tran.context.Context;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.metrics.ImportCount;
import org.frameworkset.tran.metrics.ParallImportCount;
import org.frameworkset.tran.metrics.SerialImportCount;
import org.frameworkset.tran.metrics.job.BuildMapDataContext;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.task.BaseTranJob;
import org.frameworkset.tran.task.ParrelTranCommand;
import org.frameworkset.tran.task.SerialTranCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonRecordTranJob
extends BaseTranJob {
    private static Logger logger = LoggerFactory.getLogger(CommonRecordTranJob.class);

    @Override
    public String batchExecute(SerialTranCommand serialTranCommand, Status currentStatus, ImportContext importContext, TranResultSet tranResultSet, BaseDataTran baseDataTran) {
        int count = 0;
        ArrayList<CommonRecord> records = new ArrayList<CommonRecord>();
        String ret = null;
        int taskNo = 0;
        Exception exception = null;
        BaseCommonRecordDataTran baseCommonRecordDataTran = (BaseCommonRecordDataTran)baseDataTran;
        Object currentValue = currentStatus != null ? currentStatus.getLastValue() : null;
        Object lastValue = null;
        long start = System.currentTimeMillis();
        long istart = 0L;
        long end = 0L;
        long totalCount = 0L;
        long ignoreTotalCount = 0L;
        SerialImportCount importCount = new SerialImportCount(baseDataTran);
        int batchsize = importContext.getStoreBatchSize();
        boolean reachEOFClosed = false;
        try {
            istart = start;
            BatchContext batchContext = new BatchContext();
            BuildMapDataContext buildMapDataContext = this.buildMapDataContext(importContext);
            while (true) {
                Boolean hasNext;
                if ((hasNext = tranResultSet.next()) == null) {
                    if (count <= 0) continue;
                    int _count = count;
                    count = 0;
                    taskNo = serialTranCommand.hanBatchActionTask(importCount, _count, taskNo, lastValue, records, reachEOFClosed, null);
                    records = new ArrayList();
                    if (!baseDataTran.isPrintTaskLog()) continue;
                    end = System.currentTimeMillis();
                    logger.info("Batch import Force flush datas Task[" + taskNo + "] complete,take time:" + (end - istart) + "ms" + ",import " + _count + " records.");
                    istart = end;
                    continue;
                }
                if (!hasNext.booleanValue()) break;
                lastValue = lastValue == null ? importContext.max(currentValue, baseDataTran.getLastValue()) : importContext.max(lastValue, baseDataTran.getLastValue());
                Context context = importContext.buildContext(baseDataTran.getTaskContext(), tranResultSet, batchContext);
                if (!reachEOFClosed) {
                    reachEOFClosed = context.reachEOFClosed();
                }
                if (context.removed()) {
                    if (!reachEOFClosed) {
                        ((ImportCount)importCount).increamentIgnoreTotalCount();
                        continue;
                    }
                    importContext.flushLastValue(lastValue, currentStatus, reachEOFClosed);
                    continue;
                }
                context.refactorData();
                context.afterRefactor();
                if (context.isDrop()) {
                    ((ImportCount)importCount).increamentIgnoreTotalCount();
                    continue;
                }
                CommonRecord record = baseCommonRecordDataTran.buildRecord(context);
                super.metricsMap(record, buildMapDataContext, importContext);
                records.add(record);
                if (++count < batchsize && !serialTranCommand.splitCheck(++totalCount)) continue;
                int _count = count;
                count = 0;
                taskNo = serialTranCommand.hanBatchActionTask(importCount, _count, taskNo, lastValue, records, reachEOFClosed, null);
                records = new ArrayList();
                if (!baseDataTran.isPrintTaskLog()) continue;
                end = System.currentTimeMillis();
                logger.info("Batch import Task[" + taskNo + "] complete,take time:" + (end - istart) + "ms" + ",import " + batchsize + " records.");
                istart = end;
            }
            taskNo = serialTranCommand.endSerialActionTask(importCount, count, taskNo, lastValue, records, reachEOFClosed, null);
            if (count > 0 && baseDataTran.isPrintTaskLog()) {
                end = System.currentTimeMillis();
                logger.info("Batch import Task[" + taskNo + "] complete,take time:" + (end - istart) + "ms" + ",import " + count + " records,IgnoreTotalCount " + ignoreTotalCount + " records.");
            }
            if (baseDataTran.isPrintTaskLog()) {
                end = System.currentTimeMillis();
                logger.info("Batch import Execute Tasks:" + taskNo + ",All Take time:" + (end - start) + "ms" + ",Import total " + totalCount + " records,IgnoreTotalCount " + ignoreTotalCount + " records.");
            }
        }
        catch (DataImportException e) {
            exception = e;
            throw e;
        }
        catch (Exception e) {
            exception = e;
            throw new DataImportException(e);
        }
        finally {
            if (!TranErrorWrapper.assertCondition(exception, importContext)) {
                if (!importContext.getDataTranPlugin().isMultiTran()) {
                    baseDataTran.stop();
                } else {
                    baseDataTran.stopTranOnly();
                }
            }
            baseDataTran.endJob(reachEOFClosed, importCount, exception);
        }
        return ret;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String parallelBatchExecute(ParrelTranCommand parrelTranCommand, Status currentStatus, ImportContext importContext, TranResultSet tranResultSet, BaseDataTran baseDataTran) {
        int count = 0;
        long totalSize = 0L;
        ArrayList<CommonRecord> records = new ArrayList<CommonRecord>();
        String ret = null;
        ExecutorService service = importContext.buildThreadPool();
        ArrayList<Future> tasks = new ArrayList<Future>();
        int taskNo = 0;
        ParallImportCount totalCount = new ParallImportCount(baseDataTran);
        Exception exception = null;
        BaseCommonRecordDataTran baseCommonRecordDataTran = (BaseCommonRecordDataTran)baseDataTran;
        Object currentValue = currentStatus != null ? currentStatus.getLastValue() : null;
        Object lastValue = null;
        TranErrorWrapper tranErrorWrapper = new TranErrorWrapper(importContext);
        int batchsize = importContext.getStoreBatchSize();
        boolean reachEOFClosed = false;
        try {
            BatchContext batchContext = new BatchContext();
            BuildMapDataContext buildMapDataContext = this.buildMapDataContext(importContext);
            while (true) {
                if (!tranErrorWrapper.assertCondition()) {
                    tranResultSet.stop();
                    Exception ex = tranErrorWrapper.throwError();
                    if (ex == null) break;
                    throw ex;
                }
                Boolean hasNext = tranResultSet.next();
                if (hasNext == null) {
                    if (count <= 0) continue;
                    int _count = count;
                    count = 0;
                    taskNo = parrelTranCommand.hanBatchActionTask(totalCount, _count, taskNo, lastValue, records, reachEOFClosed, null, service, tasks, tranErrorWrapper);
                    records = new ArrayList();
                    continue;
                }
                if (!hasNext.booleanValue()) break;
                lastValue = lastValue == null ? importContext.max(currentValue, baseDataTran.getLastValue()) : importContext.max(lastValue, baseDataTran.getLastValue());
                Context context = importContext.buildContext(baseDataTran.getTaskContext(), tranResultSet, batchContext);
                if (!reachEOFClosed) {
                    reachEOFClosed = context.reachEOFClosed();
                }
                if (context.removed()) {
                    if (reachEOFClosed) continue;
                    ((ImportCount)totalCount).increamentIgnoreTotalCount();
                    continue;
                }
                context.refactorData();
                context.afterRefactor();
                if (context.isDrop()) {
                    ((ImportCount)totalCount).increamentIgnoreTotalCount();
                    continue;
                }
                CommonRecord record = baseCommonRecordDataTran.buildRecord(context);
                super.metricsMap(record, buildMapDataContext, importContext);
                records.add(record);
                if (++count < batchsize && !parrelTranCommand.splitCheck(++totalSize)) continue;
                int _count = count;
                count = 0;
                taskNo = parrelTranCommand.hanBatchActionTask(totalCount, _count, taskNo, lastValue, records, reachEOFClosed, null, service, tasks, tranErrorWrapper);
                records = new ArrayList();
            }
            if (count > 0) {
                Exception e;
                if (!tranErrorWrapper.assertCondition() && (e = tranErrorWrapper.throwError()) != null) {
                    throw e;
                }
                taskNo = parrelTranCommand.hanBatchActionTask(totalCount, count, taskNo, lastValue, records, reachEOFClosed, null, service, tasks, tranErrorWrapper);
            }
            if (baseDataTran.isPrintTaskLog()) {
                logger.info("Pararrel batch submit tasks:" + taskNo);
            }
            boolean _reachEOFClosed = reachEOFClosed;
        }
        catch (DataImportException e) {
            try {
                exception = e;
                throw e;
                catch (Exception e2) {
                    exception = e2;
                    throw new DataImportException(e2);
                }
            }
            catch (Throwable throwable) {
                boolean _reachEOFClosed = reachEOFClosed;
                baseDataTran.waitTasksComplete(tasks, service, exception, lastValue, totalCount, tranErrorWrapper, new WaitTasksCompleteCallBack(parrelTranCommand){
                    final /* synthetic */ ParrelTranCommand val$parrelTranCommand;
                    {
                        this.val$parrelTranCommand = parrelTranCommand;
                    }

                    @Override
                    public void call() {
                        this.val$parrelTranCommand.parrelCompleteAction();
                    }
                }, reachEOFClosed);
                throw throwable;
            }
        }
        baseDataTran.waitTasksComplete(tasks, service, exception, lastValue, totalCount, tranErrorWrapper, new /* invalid duplicate definition of identical inner class */, reachEOFClosed);
        return ret;
    }

    @Override
    public String serialExecute(SerialTranCommand serialTranCommand, Status currentStatus, ImportContext importContext, TranResultSet tranResultSet, BaseDataTran baseDataTran) {
        if (importContext.serialAllData()) {
            return this.serialExecuteAllRecoreds(serialTranCommand, currentStatus, importContext, tranResultSet, baseDataTran);
        }
        return this.serialExecuteOneRecord(serialTranCommand, currentStatus, importContext, tranResultSet, baseDataTran);
    }

    private String serialExecuteOneRecord(SerialTranCommand serialTranCommand, Status currentStatus, ImportContext importContext, TranResultSet tranResultSet, BaseDataTran baseDataTran) {
        Object lastValue = null;
        Exception exception = null;
        long start = System.currentTimeMillis();
        long lastSend = 0L;
        Object currentValue = currentStatus != null ? currentStatus.getLastValue() : null;
        SerialImportCount importCount = new SerialImportCount(baseDataTran);
        long totalCount = 0L;
        BaseCommonRecordDataTran baseCommonRecordDataTran = (BaseCommonRecordDataTran)baseDataTran;
        boolean reachEOFClosed = false;
        try {
            Object temp = null;
            long logInterval = 60000L;
            boolean printed = false;
            BatchContext batchContext = new BatchContext();
            BuildMapDataContext buildMapDataContext = this.buildMapDataContext(importContext);
            while (true) {
                Boolean hasNext;
                if ((hasNext = tranResultSet.next()) == null) {
                    if (!baseDataTran.isPrintTaskLog() || printed) continue;
                    if (lastSend > 0L) {
                        long end = System.currentTimeMillis();
                        long interval = end - lastSend;
                        if (interval < logInterval) continue;
                        logger.info("Auto Log Send datas Take time:" + (end - start) + "ms" + ",Send total " + totalCount + " records,IgnoreTotalCount " + ((ImportCount)importCount).getIgnoreTotalCount() + " records,FailedTotalCount " + ((ImportCount)importCount).getFailedCount() + " records.");
                        lastSend = 0L;
                        printed = true;
                        continue;
                    }
                    lastSend = System.currentTimeMillis();
                    continue;
                }
                if (!hasNext.booleanValue()) break;
                lastSend = 0L;
                printed = false;
                try {
                    long end;
                    lastValue = lastValue == null ? importContext.max(currentValue, baseDataTran.getLastValue()) : importContext.max(lastValue, baseDataTran.getLastValue());
                    Context context = importContext.buildContext(baseDataTran.getTaskContext(), tranResultSet, batchContext);
                    if (!reachEOFClosed) {
                        reachEOFClosed = context.reachEOFClosed();
                    }
                    if (context.removed()) {
                        if (!reachEOFClosed) {
                            ((ImportCount)importCount).increamentIgnoreTotalCount();
                            continue;
                        }
                        importContext.flushLastValue(lastValue, currentStatus, reachEOFClosed);
                        continue;
                    }
                    context.refactorData();
                    context.afterRefactor();
                    if (context.isDrop()) {
                        ((ImportCount)importCount).increamentIgnoreTotalCount();
                        continue;
                    }
                    CommonRecord record = baseCommonRecordDataTran.buildRecord(context);
                    super.metricsMap(record, buildMapDataContext, importContext);
                    serialTranCommand.hanBatchActionTask(importCount, 1L, -1, lastValue, record, reachEOFClosed, record);
                    if (++totalCount == Long.MAX_VALUE) {
                        if (baseDataTran.isPrintTaskLog()) {
                            end = System.currentTimeMillis();
                            logger.info("Send datas  Take time:" + (end - start) + "ms" + ",Send total" + totalCount + " records,IgnoreTotalCount " + ((ImportCount)importCount).getIgnoreTotalCount() + " records,FailedTotalCount " + ((ImportCount)importCount).getFailedCount() + " records. totalCount has reach Long.MAX_VALUE and reset");
                        }
                        totalCount = 0L;
                        continue;
                    }
                    if (!baseDataTran.isPrintTaskLog() || importContext.getLogsendTaskMetric() <= 0L || totalCount % importContext.getLogsendTaskMetric() != 0L) continue;
                    end = System.currentTimeMillis();
                    logger.info("Send datas Take time:" + (end - start) + "ms" + ",Send total " + totalCount + " records,IgnoreTotalCount " + ((ImportCount)importCount).getIgnoreTotalCount() + " records,FailedTotalCount " + ((ImportCount)importCount).getFailedCount() + " records.");
                }
                catch (Exception e) {
                    throw new DataImportException(e);
                }
            }
            serialTranCommand.endSerialActionTask(importCount, -1L, -1, lastValue, null, reachEOFClosed, null);
            if (baseDataTran.isPrintTaskLog()) {
                long end = System.currentTimeMillis();
                logger.info("Send datas Take time:" + (end - start) + "ms" + ",Send total " + totalCount + " records,IgnoreTotalCount " + ((ImportCount)importCount).getIgnoreTotalCount() + " records,FailedTotalCount " + ((ImportCount)importCount).getFailedCount() + " records.");
            }
        }
        catch (DataImportException e) {
            exception = e;
            throw e;
        }
        catch (Exception e) {
            exception = e;
            throw new DataImportException(e);
        }
        finally {
            if (!TranErrorWrapper.assertCondition(exception, importContext)) {
                if (!importContext.getDataTranPlugin().isMultiTran()) {
                    baseDataTran.stop();
                } else {
                    baseDataTran.stopTranOnly();
                }
            }
            if (importContext.isCurrentStoped()) {
                baseDataTran.stopTranOnly();
            }
            baseDataTran.endJob(reachEOFClosed, importCount, exception);
        }
        return null;
    }

    private String serialExecuteAllRecoreds(SerialTranCommand serialTranCommand, Status currentStatus, ImportContext importContext, TranResultSet tranResultSet, BaseDataTran baseDataTran) {
        ArrayList<CommonRecord> records = new ArrayList<CommonRecord>();
        Object lastValue = null;
        Exception exception = null;
        long start = System.currentTimeMillis();
        Object currentValue = currentStatus != null ? currentStatus.getLastValue() : null;
        SerialImportCount importCount = new SerialImportCount(baseDataTran);
        BaseCommonRecordDataTran baseCommonRecordDataTran = (BaseCommonRecordDataTran)baseDataTran;
        int taskNo = 0;
        long totalCount = 0L;
        int count = 0;
        long ignoreTotalCount = 0L;
        boolean reachEOFClosed = false;
        try {
            Object temp = null;
            BatchContext batchContext = new BatchContext();
            BuildMapDataContext buildMapDataContext = this.buildMapDataContext(importContext);
            while (true) {
                Boolean hasNext;
                if ((hasNext = tranResultSet.next()) == null) {
                    String ret = null;
                    if (records.size() > 0) {
                        taskNo = serialTranCommand.hanBatchActionTask(importCount, totalCount, taskNo, lastValue, records, reachEOFClosed, null);
                        records = new ArrayList();
                    } else {
                        ret = "{\"took\":0,\"errors\":false}";
                    }
                    if (!baseDataTran.isPrintTaskLog()) continue;
                    long end = System.currentTimeMillis();
                    logger.info("Force flush datas Take time:" + (end - start) + "ms" + ",Import total " + totalCount + " records,IgnoreTotalCount " + ignoreTotalCount + " records.");
                    continue;
                }
                if (!hasNext.booleanValue()) break;
                try {
                    lastValue = lastValue == null ? importContext.max(currentValue, baseDataTran.getLastValue()) : importContext.max(lastValue, baseDataTran.getLastValue());
                    Context context = importContext.buildContext(baseDataTran.getTaskContext(), tranResultSet, batchContext);
                    if (!reachEOFClosed) {
                        reachEOFClosed = context.reachEOFClosed();
                    }
                    if (context.removed()) {
                        if (!reachEOFClosed) {
                            ((ImportCount)importCount).increamentIgnoreTotalCount();
                            continue;
                        }
                        importContext.flushLastValue(lastValue, currentStatus, reachEOFClosed);
                        continue;
                    }
                    context.refactorData();
                    context.afterRefactor();
                    if (context.isDrop()) {
                        ((ImportCount)importCount).increamentIgnoreTotalCount();
                        continue;
                    }
                    CommonRecord record = baseCommonRecordDataTran.buildRecord(context);
                    super.metricsMap(record, buildMapDataContext, importContext);
                    records.add(record);
                    ++count;
                    if (!serialTranCommand.splitCheck(++totalCount)) continue;
                    int _count = count;
                    count = 0;
                    taskNo = serialTranCommand.hanBatchActionTask(importCount, _count, taskNo, lastValue, records, reachEOFClosed, null);
                    records = new ArrayList();
                }
                catch (Exception e) {
                    throw new DataImportException(e);
                }
            }
            taskNo = serialTranCommand.endSerialActionTask(importCount, totalCount, taskNo, lastValue, records, reachEOFClosed, null);
            if (baseDataTran.isPrintTaskLog()) {
                long end = System.currentTimeMillis();
                logger.info("Serial import Take time:" + (end - start) + "ms" + ",Total Import  " + totalCount + " records,Total Ignore Count " + ((ImportCount)importCount).getIgnoreTotalCount() + " records,Total Failed Count " + ((ImportCount)importCount).getFailedCount() + " records.");
            }
        }
        catch (DataImportException e) {
            exception = e;
            throw e;
        }
        catch (Exception e) {
            exception = e;
            throw new DataImportException(e);
        }
        finally {
            if (!TranErrorWrapper.assertCondition(exception, importContext)) {
                if (!importContext.getDataTranPlugin().isMultiTran()) {
                    baseDataTran.stop();
                } else {
                    baseDataTran.stopTranOnly();
                }
            }
            if (importContext.isCurrentStoped()) {
                baseDataTran.stopTranOnly();
            }
            baseDataTran.endJob(reachEOFClosed, importCount, exception);
        }
        return null;
    }
}

