/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.schedule.timer;

import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.schedule.ScheduleService;
import org.frameworkset.tran.schedule.timer.TimeUtil;
import org.frameworkset.tran.schedule.timer.TimerScheduleConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleTimer
implements Runnable {
    private TimerScheduleConfig timerScheduleConfig;
    private ScheduleService scheduleService;
    private static Logger logger = LoggerFactory.getLogger(ScheduleTimer.class);
    private Thread thread = null;
    protected volatile boolean running = false;

    public ScheduleTimer(TimerScheduleConfig timerScheduleConfig, ScheduleService scheduleService) {
        this.timerScheduleConfig = timerScheduleConfig;
        this.scheduleService = scheduleService;
    }

    public synchronized void start() throws IllegalStateException {
        if (this.running) {
            throw new IllegalStateException("BBossScheduleTimer is already running");
        }
        this.running = true;
        this.thread = new Thread((Runnable)this, "BBossScheduleTimer-" + this.scheduleService.getImportContext().getJobName());
        this.thread.setDaemon(false);
        this.thread.start();
    }

    public synchronized void stop() throws Exception {
        this.stop(this.timerScheduleConfig.getPeriod());
    }

    public synchronized void stop(long stopInterval) throws Exception {
        if (!this.running) {
            throw new IllegalStateException("Monitor is not running");
        }
        this.running = false;
        try {
            this.thread.interrupt();
            this.thread.join(stopInterval);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void run() {
        ImportContext importContext;
        Long deyLay;
        Long interval = this.timerScheduleConfig.getPeriod();
        if (interval == null) {
            interval = 100000L;
        }
        if ((deyLay = (importContext = this.scheduleService.getImportContext()).getDeyLay()) != null) {
            try {
                Thread.sleep(deyLay);
            }
            catch (InterruptedException ignored) {
                return;
            }
        }
        while (this.running) {
            while (true) {
                if (TimeUtil.evalateNeedScan(this.timerScheduleConfig)) {
                    if (this.scheduleService.isSchedulePaused(this.scheduleService.isEnableAutoPauseScheduled())) {
                        if (!logger.isInfoEnabled()) break;
                        logger.info("Ignore  Paussed Schedule Task,waiting for next resume schedule sign to continue.");
                        break;
                    }
                    this.scheduleService.externalTimeSchedule();
                    break;
                }
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                    break;
                }
            }
            if (!this.running) break;
            try {
                Thread.sleep(interval);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

