/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.schedule;

import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.DataStream;
import org.frameworkset.tran.config.ImportBuilder;
import org.frameworkset.tran.schedule.DataStreamBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalScheduler {
    private DataStreamBuilder dataStreamBuilder;
    private DataStream dataStream;
    private static Logger logger = LoggerFactory.getLogger(ExternalScheduler.class);

    public void dataStream(DataStreamBuilder dataStreamBuilder) {
        this.dataStreamBuilder = dataStreamBuilder;
    }

    public void execute(Object params) {
        if (this.dataStream == null) {
            try {
                if (this.dataStream == null) {
                    ImportBuilder db2ESImportBuilder = this.dataStreamBuilder.builder(params);
                    if (!db2ESImportBuilder.isExternalTimer()) {
                        db2ESImportBuilder.setExternalTimer(true);
                    }
                    if (db2ESImportBuilder.isAsyn()) {
                        db2ESImportBuilder.setAsyn(false);
                    }
                    this.dataStream = db2ESImportBuilder.builder();
                }
            }
            catch (DataImportException e) {
                if (logger.isErrorEnabled()) {
                    logger.error("ExternalScheduler execute failed:", (Throwable)e);
                }
                throw e;
            }
            catch (Exception e) {
                if (logger.isErrorEnabled()) {
                    logger.error("ExternalScheduler execute failed:", (Throwable)e);
                }
                throw new DataImportException("ExternalScheduler execute failed:", e);
            }
            catch (Throwable e) {
                if (logger.isErrorEnabled()) {
                    logger.error("ExternalScheduler execute failed:", e);
                }
                throw new DataImportException("ExternalScheduler execute failed:", e);
            }
            if (this.dataStream == null) {
                throw new DataImportException("ExternalScheduler failed: datastream build failed");
            }
        }
        this.dataStream.execute();
    }

    public void destroy() {
        if (this.dataStream != null) {
            this.dataStream.destroy();
            this.dataStream = null;
        }
        this.dataStreamBuilder = null;
    }
}

