/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.record;

import com.frameworkset.util.SimpleStringUtil;
import com.frameworkset.util.ValueObjectUtil;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.frameworkset.tran.record.CellMapping;

public class FieldMappingUtil {
    public static void buildRecord(Map result, String line, List<CellMapping> cellMappingList, String splitChar) {
        String[] vs = line.split(splitChar);
        if (cellMappingList != null) {
            for (CellMapping cellMapping : cellMappingList) {
                if (cellMapping.getCell() >= vs.length) continue;
                String value = vs[cellMapping.getCell()];
                result.put(cellMapping.getFieldName(), FieldMappingUtil.convertValue(cellMapping, value));
            }
        }
    }

    private static Object convertValue(CellMapping cellMapping, String value) {
        if (cellMapping.getCellType() == 1) {
            return value;
        }
        if (cellMapping.getCellType() == 6) {
            return ValueObjectUtil.typeCast((Object)value, Integer.class);
        }
        if (cellMapping.getCellType() == 7) {
            return ValueObjectUtil.typeCast((Object)value, Long.class);
        }
        if (cellMapping.getCellType() == 8) {
            return ValueObjectUtil.typeCast((Object)value, Float.class);
        }
        if (cellMapping.getCellType() == 10) {
            return ValueObjectUtil.typeCast((Object)value, Double.class);
        }
        if (cellMapping.getCellType() == 3) {
            if (SimpleStringUtil.isEmpty((String)cellMapping.getDateFormat())) {
                return ValueObjectUtil.typeCast((Object)value, Date.class);
            }
            return ValueObjectUtil.typeCast((Object)value, value.getClass(), Date.class, (String)cellMapping.getDateFormat());
        }
        if (cellMapping.getCellType() == 2) {
            return ValueObjectUtil.typeCast((Object)value, BigDecimal.class);
        }
        if (cellMapping.getCellType() == 5) {
            return ValueObjectUtil.typeCast((Object)value, Boolean.class);
        }
        if (cellMapping.getCellType() == 9) {
            return ValueObjectUtil.typeCast((Object)value, Short.class);
        }
        return value;
    }
}

