/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.metrics.output;

import java.util.List;
import org.frameworkset.tran.CommonRecord;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.metrics.ImportCount;
import org.frameworkset.tran.metrics.job.BuildMapDataContext;
import org.frameworkset.tran.plugin.metrics.output.MetricsOutputConfig;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.task.BaseTaskCommand;
import org.frameworkset.tran.task.BaseTranJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsTaskCommandImpl
extends BaseTaskCommand<List<CommonRecord>, String> {
    private Logger logger = LoggerFactory.getLogger(MetricsTaskCommandImpl.class);
    private List<CommonRecord> datas;
    private TaskContext taskContext;
    private MetricsOutputConfig metricsOutputConfig;

    public MetricsTaskCommandImpl(ImportCount importCount, ImportContext importContext, List<CommonRecord> datas, int taskNo, String jobNo, Object lastValue, Status currentStatus, boolean reachEOFClosed, TaskContext taskContext) {
        super(importCount, importContext, datas.size(), taskNo, jobNo, lastValue, currentStatus, reachEOFClosed, taskContext);
        this.metricsOutputConfig = (MetricsOutputConfig)importContext.getOutputConfig();
        this.datas = datas;
        if (this.taskContext == null) {
            this.taskContext = new TaskContext(importContext);
        }
    }

    @Override
    public List<CommonRecord> getDatas() {
        return this.datas;
    }

    @Override
    public void setDatas(List<CommonRecord> datas) {
        this.datas = datas;
    }

    @Override
    public String execute() {
        BuildMapDataContext buildMapDataContext = new BuildMapDataContext();
        String dataTimeField = this.metricsOutputConfig.getDataTimeField();
        buildMapDataContext.setDataTimeField(dataTimeField);
        for (CommonRecord commonRecord : this.datas) {
            BaseTranJob.map(commonRecord, buildMapDataContext, this.metricsOutputConfig.getMetrics(), this.metricsOutputConfig.isUseDefaultMapData());
        }
        this.finishTask();
        return null;
    }
}

