/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.http.output;

import java.util.Map;
import org.apache.http.entity.ContentType;
import org.frameworkset.spi.remote.http.HttpRequestProxy;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.config.DynamicParam;
import org.frameworkset.tran.config.DynamicParamContext;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.metrics.ImportCount;
import org.frameworkset.tran.plugin.http.DynamicHeaderContext;
import org.frameworkset.tran.plugin.http.HttpConfigClientProxy;
import org.frameworkset.tran.plugin.http.HttpProxyHelper;
import org.frameworkset.tran.plugin.http.output.HttpOutputConfig;
import org.frameworkset.tran.plugin.http.output.HttpOutputDataTranPlugin;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.task.BaseTaskCommand;
import org.frameworkset.tran.task.TaskCommand;
import org.frameworkset.tran.task.TaskFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTaskCommandImpl
extends BaseTaskCommand<String, String> {
    private HttpOutputConfig httpOutputConfig;
    private String datas;
    private int tryCount;
    private static Logger logger = LoggerFactory.getLogger(TaskCommand.class);

    public HttpTaskCommandImpl(ImportCount importCount, ImportContext importContext, long dataSize, int taskNo, String jobNo, Object lastValue, Status currentStatus, boolean reachEOFClosed, TaskContext taskContext) {
        super(importCount, importContext, dataSize, taskNo, jobNo, lastValue, currentStatus, reachEOFClosed, taskContext);
        this.httpOutputConfig = (HttpOutputConfig)importContext.getOutputConfig();
    }

    @Override
    public String getDatas() {
        return this.datas;
    }

    @Override
    public void setDatas(String datas) {
        this.datas = datas;
    }

    @Override
    public String execute() {
        if (this.importContext.getMaxRetry() > 0 && this.tryCount >= this.importContext.getMaxRetry()) {
            throw new TaskFailedException("task execute failed:reached max retry times " + this.importContext.getMaxRetry());
        }
        ++this.tryCount;
        try {
            String data = null;
            data = this.httpOutputConfig.isDirectSendData() ? this.directSendData() : this.unDirectSendData();
            this.finishTask();
            return data;
        }
        catch (Exception e) {
            throw new DataImportException(this.datas, e);
        }
    }

    private String directSendData() {
        String data = null;
        HttpOutputDataTranPlugin httpOutputDataTranPlugin = (HttpOutputDataTranPlugin)this.importContext.getOutputPlugin();
        DynamicHeaderContext dynamicHeaderContext = null;
        if (this.httpOutputConfig.getDynamicHeaders() != null) {
            dynamicHeaderContext = new DynamicHeaderContext();
            dynamicHeaderContext.setDatas(this.datas);
            dynamicHeaderContext.setTaskContext(this.taskContext);
            dynamicHeaderContext.setImportContext(httpOutputDataTranPlugin.getImportContext());
        }
        data = this.httpOutputConfig.isPostMethod() ? HttpRequestProxy.sendBody((String)this.httpOutputConfig.getTargetHttpPool(), (String)this.datas, (String)this.httpOutputConfig.getServiceUrl(), HttpProxyHelper.getHttpHeaders(this.httpOutputConfig, dynamicHeaderContext), (ContentType)ContentType.APPLICATION_JSON) : HttpRequestProxy.putJson((String)this.httpOutputConfig.getTargetHttpPool(), (String)this.datas, (String)this.httpOutputConfig.getServiceUrl(), HttpProxyHelper.getHttpHeaders(this.httpOutputConfig, dynamicHeaderContext));
        return data;
    }

    private String unDirectSendData() {
        String data = null;
        HttpOutputDataTranPlugin httpOutputDataTranPlugin = (HttpOutputDataTranPlugin)this.importContext.getOutputPlugin();
        HttpConfigClientProxy httpConfigClientProxy = httpOutputDataTranPlugin.getHttpConfigClientProxy();
        DynamicHeaderContext dynamicHeaderContext = null;
        if (this.httpOutputConfig.getDynamicHeaders() != null) {
            dynamicHeaderContext = new DynamicHeaderContext();
            dynamicHeaderContext.setDatas(this.datas);
            dynamicHeaderContext.setTaskContext(this.taskContext);
            dynamicHeaderContext.setImportContext(httpOutputDataTranPlugin.getImportContext());
        }
        Map<String, DynamicParam> dynamicParams = this.importContext.getJobDynamicOutputParams();
        DynamicParamContext dynamicParamContext = null;
        if (dynamicParams != null && dynamicParams.size() > 0) {
            dynamicParamContext = new DynamicParamContext();
            dynamicParamContext.setImportContext(this.importContext);
            dynamicParamContext.setTaskContext(this.taskContext);
            dynamicParamContext.setDatas(this.datas);
        }
        Map params = this.importContext.getDataTranPlugin().getJobOutputParams(dynamicParamContext);
        params.put(this.httpOutputConfig.getDataKey(), this.datas);
        data = this.httpOutputConfig.isPostMethod() ? httpConfigClientProxy.sendBody(httpOutputDataTranPlugin, dynamicHeaderContext, params) : httpConfigClientProxy.putJson(httpOutputDataTranPlugin, dynamicHeaderContext, params);
        return data;
    }

    @Override
    public int getTryCount() {
        return this.tryCount;
    }
}

