/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.http.output;

import com.frameworkset.util.SimpleStringUtil;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.frameworkset.tran.CommonRecord;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.DefualtExportResultHandler;
import org.frameworkset.tran.ExportResultHandler;
import org.frameworkset.tran.WrapedExportResultHandler;
import org.frameworkset.tran.config.ImportBuilder;
import org.frameworkset.tran.config.OutputConfig;
import org.frameworkset.tran.context.Context;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.plugin.OutputPlugin;
import org.frameworkset.tran.plugin.http.BaseHttpConfig;
import org.frameworkset.tran.plugin.http.DynamicHeader;
import org.frameworkset.tran.plugin.http.output.HttpOutputDataTranPlugin;
import org.frameworkset.tran.util.JsonRecordGenerator;
import org.frameworkset.tran.util.RecordGenerator;
import org.frameworkset.tran.util.TranUtil;

public class HttpOutputConfig
extends BaseHttpConfig
implements OutputConfig {
    private Map<String, Object> httpConfigs;
    private String dataDslName;
    private String dataDsl;
    private String dataKey;
    private boolean json = true;
    private String lineSeparator;
    private String targetHttpPool;
    private String serviceUrl;
    private RecordGenerator recordGenerator;
    private boolean directSendData = true;

    public HttpOutputConfig setDslFile(String dslFile) {
        this.dslFile = dslFile;
        return this;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public HttpOutputConfig setShowDsl(boolean showDsl) {
        this.showDsl = showDsl;
        return this;
    }

    public HttpOutputConfig setJson(boolean json) {
        this.json = json;
        return this;
    }

    public boolean isJson() {
        return this.json;
    }

    public HttpOutputConfig setDslNamespace(String dslNamespace) {
        this.dslNamespace = dslNamespace;
        return this;
    }

    public HttpOutputConfig setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
        return this;
    }

    public String getTargetHttpPool() {
        return this.targetHttpPool;
    }

    public HttpOutputConfig setTargetHttpPool(String targetHttpPool) {
        this.targetHttpPool = targetHttpPool;
        return this;
    }

    public RecordGenerator getRecordGenerator() {
        return this.recordGenerator;
    }

    public HttpOutputConfig setRecordGenerator(RecordGenerator recordGenerator) {
        this.recordGenerator = recordGenerator;
        return this;
    }

    public Map<String, Object> getHttpConfigs() {
        return this.httpConfigs;
    }

    private void checkConfigs() {
        if (this.httpConfigs == null) {
            this.httpConfigs = new LinkedHashMap<String, Object>();
        }
    }

    public HttpOutputConfig addTargetHttpPoolName(String nameProperty, String httpPoolName) {
        this.checkConfigs();
        this.httpConfigs.put(nameProperty, httpPoolName);
        this.targetHttpPool = httpPoolName;
        return this;
    }

    public HttpOutputConfig addHttpOutputConfig(String property, Object value) {
        this.checkConfigs();
        this.httpConfigs.put(property, value);
        return this;
    }

    public HttpOutputConfig addDynamicHeader(String header, DynamicHeader dynamicHeader) {
        this._addDynamicHeader(header, dynamicHeader);
        return this;
    }

    public boolean isDirectSendData() {
        return this.directSendData;
    }

    public HttpOutputConfig setDataKey(String dataKey) {
        this.dataKey = dataKey;
        return this;
    }

    public String getDataKey() {
        return this.dataKey;
    }

    @Override
    public void build(ImportBuilder importBuilder) {
        if (SimpleStringUtil.isEmpty((String)this.getServiceUrl())) {
            throw new DataImportException("Input http service url is not setted.");
        }
        if (SimpleStringUtil.isEmpty((String)this.httpMethod)) {
            this.httpMethod = "post";
        }
        if (!this.httpMethod.equals("post") && !this.httpMethod.equals("put")) {
            throw new DataImportException("Input httpMethod must be post or put.");
        }
        this.postMethod = this.httpMethod.equals("post");
        if (SimpleStringUtil.isEmpty((String)this.getDataDsl())) {
            if (!SimpleStringUtil.isEmpty((String)this.getDslFile()) && !SimpleStringUtil.isEmpty((String)this.getDataDslName())) {
                this.directSendData = false;
            }
        } else {
            this.directSendData = false;
            if (SimpleStringUtil.isEmpty((String)this.dataDslName)) {
                this.dataDslName = "datatranSendDslName";
            }
            if (SimpleStringUtil.isEmpty((String)this.dslNamespace)) {
                this.dslNamespace = "datatranSendDslNamespace" + SimpleStringUtil.getUUID();
            }
            if (SimpleStringUtil.isEmpty((String)this.dataKey)) {
                this.dataKey = "httpDatas";
            }
        }
        if (this.getRecordGenerator() == null) {
            this.setRecordGenerator(new JsonRecordGenerator());
        }
        if (this.json) {
            this.lineSeparator = ",";
        } else if (SimpleStringUtil.isEmpty((String)this.lineSeparator)) {
            this.lineSeparator = TranUtil.lineSeparator;
        }
    }

    public HttpOutputConfig setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    @Override
    public OutputPlugin getOutputPlugin(ImportContext importContext) {
        return new HttpOutputDataTranPlugin(importContext);
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public HttpOutputConfig setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
        return this;
    }

    @Override
    public WrapedExportResultHandler buildExportResultHandler(ExportResultHandler exportResultHandler) {
        DefualtExportResultHandler db2ESExportResultHandler = new DefualtExportResultHandler(exportResultHandler);
        return db2ESExportResultHandler;
    }

    public void generateReocord(Context taskContext, CommonRecord record, Writer builder) throws Exception {
        if (builder == null) {
            builder = RecordGenerator.tranDummyWriter;
        }
        this.getRecordGenerator().buildRecord(taskContext, record, builder);
    }

    public HttpOutputConfig addHttpHeaders(Map<String, String> _httpHeaders) {
        this._addHttpHeaders(_httpHeaders);
        return this;
    }

    public HttpOutputConfig addHttpHeader(String header, String value) {
        this._addHttpHeader(header, value);
        return this;
    }

    public String getDataDslName() {
        return this.dataDslName;
    }

    public HttpOutputConfig setDataDslName(String dataDslName) {
        this.dataDslName = dataDslName;
        return this;
    }

    public String getDataDsl() {
        return this.dataDsl;
    }

    public HttpOutputConfig setDataDsl(String dataDsl) {
        this.dataDsl = dataDsl;
        return this;
    }
}

