/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.http.output;

import java.io.Writer;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.frameworkset.soa.BBossStringWriter;
import org.frameworkset.tran.BaseCommonRecordDataTran;
import org.frameworkset.tran.CommonRecord;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.JobCountDownLatch;
import org.frameworkset.tran.TranErrorWrapper;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.context.Context;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.metrics.ImportCount;
import org.frameworkset.tran.plugin.http.output.HttpOutputConfig;
import org.frameworkset.tran.plugin.http.output.HttpTaskCommandImpl;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.task.BaseParrelTranCommand;
import org.frameworkset.tran.task.BaseSerialTranCommand;
import org.frameworkset.tran.task.StringTranJob;
import org.frameworkset.tran.task.TaskCall;
import org.slf4j.Logger;

public class HttpOutPutDataTran
extends BaseCommonRecordDataTran {
    protected HttpOutputConfig httpOutputConfig;
    protected JobCountDownLatch countDownLatch;
    protected String taskInfo;

    @Override
    public void logTaskStart(Logger logger) {
        logger.info(this.taskInfo + " start.");
    }

    @Override
    protected void initTranJob() {
        this.tranJob = new StringTranJob();
    }

    @Override
    protected void initTranTaskCommand() {
        this.parrelTranCommand = new BaseParrelTranCommand(){

            @Override
            public int hanBatchActionTask(ImportCount totalCount, long dataSize, int taskNo, Object lastValue, Object datas, boolean reachEOFClosed, CommonRecord record, ExecutorService service, List<Future> tasks, TranErrorWrapper tranErrorWrapper) {
                if (datas != null) {
                    HttpTaskCommandImpl taskCommand = new HttpTaskCommandImpl(totalCount, HttpOutPutDataTran.this.importContext, dataSize, ++taskNo, HttpOutPutDataTran.this.taskContext.getJobNo(), lastValue, HttpOutPutDataTran.this.currentStatus, reachEOFClosed, HttpOutPutDataTran.this.taskContext);
                    taskCommand.setDatas((String)datas);
                    tasks.add(service.submit(new TaskCall(taskCommand, tranErrorWrapper)));
                }
                return taskNo;
            }

            @Override
            public CommonRecord buildStringRecord(Context context, Writer writer) throws Exception {
                return HttpOutPutDataTran.this.buildStringRecord(context, writer);
            }
        };
        this.serialTranCommand = new BaseSerialTranCommand(){

            @Override
            public int hanBatchActionTask(ImportCount totalCount, long dataSize, int taskNo, Object lastValue, Object datas, boolean reachEOFClosed, CommonRecord record) {
                if (datas != null) {
                    HttpTaskCommandImpl taskCommand = new HttpTaskCommandImpl(totalCount, HttpOutPutDataTran.this.importContext, dataSize, ++taskNo, HttpOutPutDataTran.this.taskContext.getJobNo(), lastValue, HttpOutPutDataTran.this.currentStatus, reachEOFClosed, HttpOutPutDataTran.this.taskContext);
                    taskCommand.setDatas((String)datas);
                    TaskCall.call(taskCommand);
                }
                return taskNo;
            }

            @Override
            public int endSerialActionTask(ImportCount totalCount, long dataSize, int taskNo, Object lastValue, Object datas, boolean reachEOFClosed, CommonRecord record) {
                if (datas != null) {
                    HttpTaskCommandImpl taskCommand = new HttpTaskCommandImpl(totalCount, HttpOutPutDataTran.this.importContext, dataSize, ++taskNo, HttpOutPutDataTran.this.taskContext.getJobNo(), lastValue, HttpOutPutDataTran.this.currentStatus, reachEOFClosed, HttpOutPutDataTran.this.taskContext);
                    taskCommand.setDatas((String)datas);
                    TaskCall.call(taskCommand);
                }
                return taskNo;
            }

            @Override
            public CommonRecord buildStringRecord(Context context, Writer writer) throws Exception {
                return HttpOutPutDataTran.this.buildStringRecord(context, writer);
            }
        };
    }

    @Override
    public void init() {
        super.init();
        this.taskInfo = "Http output datatran job";
    }

    @Override
    public String tran() throws DataImportException {
        try {
            String ret;
            String string = ret = super.tran();
            return string;
        }
        catch (DataImportException dataImportException) {
            if (this.countDownLatch != null) {
                this.countDownLatch.attachException(dataImportException);
            }
            throw dataImportException;
        }
        catch (Exception dataImportException) {
            if (this.countDownLatch != null) {
                this.countDownLatch.attachException(dataImportException);
            }
            throw new DataImportException(dataImportException);
        }
        catch (Throwable dataImportException) {
            if (this.countDownLatch != null) {
                this.countDownLatch.attachException(dataImportException);
            }
            throw new DataImportException(dataImportException);
        }
        finally {
            if (this.countDownLatch != null) {
                this.countDownLatch.countDown();
            }
        }
    }

    public HttpOutPutDataTran(TaskContext taskContext, TranResultSet tranResultSet, ImportContext importContext, Status currentStatus) {
        super(taskContext, tranResultSet, importContext, currentStatus);
        this.httpOutputConfig = (HttpOutputConfig)importContext.getOutputConfig();
    }

    public HttpOutPutDataTran(TaskContext taskContext, TranResultSet tranResultSet, ImportContext importContext, JobCountDownLatch countDownLatch, Status currentStatus) {
        super(taskContext, tranResultSet, importContext, currentStatus);
        this.countDownLatch = countDownLatch;
        this.httpOutputConfig = (HttpOutputConfig)importContext.getOutputConfig();
    }

    protected CommonRecord buildStringRecord(Context context, Writer writer) throws Exception {
        CommonRecord record = context.getCommonRecord();
        if (writer == null) {
            this.httpOutputConfig.generateReocord(context, record, writer);
            writer.write(this.httpOutputConfig.getLineSeparator());
        } else if (writer instanceof BBossStringWriter) {
            BBossStringWriter bBossStringWriter = (BBossStringWriter)writer;
            if (bBossStringWriter.getBuffer().length() == 0) {
                if (this.httpOutputConfig.isJson()) {
                    writer.write("[");
                }
                this.httpOutputConfig.generateReocord(context, record, writer);
            } else {
                writer.write(this.httpOutputConfig.getLineSeparator());
                this.httpOutputConfig.generateReocord(context, record, writer);
            }
        } else {
            this.httpOutputConfig.generateReocord(context, record, writer);
            writer.write(this.httpOutputConfig.getLineSeparator());
        }
        return record;
    }

    @Override
    public void beforeOutputData(BBossStringWriter writer) {
        if (this.httpOutputConfig.isJson() && writer.getBuffer().length() > 0) {
            writer.write("]");
        }
    }
}

