/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.http;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.frameworkset.elasticsearch.client.ConfigHolder;
import org.frameworkset.elasticsearch.template.BaseTemplateContainerImpl;
import org.frameworkset.elasticsearch.template.ConfigDSLUtil;
import org.frameworkset.elasticsearch.template.ESTemplateHelper;
import org.frameworkset.elasticsearch.template.TemplateContainer;
import org.frameworkset.spi.remote.http.BaseURLResponseHandler;
import org.frameworkset.spi.remote.http.HttpRequestProxy;
import org.frameworkset.spi.remote.http.ResponseUtil;
import org.frameworkset.spi.remote.http.proxy.HttpProxyRequestException;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.plugin.http.DynamicHeaderContext;
import org.frameworkset.tran.plugin.http.HttpProxyHelper;
import org.frameworkset.tran.plugin.http.HttpResult;
import org.frameworkset.tran.plugin.http.input.HttpInputConfig;
import org.frameworkset.tran.plugin.http.input.HttpInputDataTranPlugin;
import org.frameworkset.tran.plugin.http.input.HttpResultParserContext;
import org.frameworkset.tran.plugin.http.output.HttpOutputConfig;
import org.frameworkset.tran.plugin.http.output.HttpOutputDataTranPlugin;
import org.frameworkset.util.shutdown.ShutdownUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConfigClientProxy {
    private static Logger logger = LoggerFactory.getLogger(HttpConfigClientProxy.class);
    protected String configFile;
    protected ConfigDSLUtil configDSLUtil;
    private static ConfigHolder configHolder = new ConfigHolder("HttpProxy");

    public HttpConfigClientProxy(String configFile) {
        this.configFile = configFile;
        this.configDSLUtil = configHolder.getConfigDSLUtil(configFile);
    }

    public HttpConfigClientProxy(BaseTemplateContainerImpl templateContainer) {
        templateContainer.setConfigHolder(configHolder);
        this.configDSLUtil = configHolder.getConfigDSLUtil((TemplateContainer)templateContainer);
    }

    protected String evalTemplate(String templateName, Object params) {
        return ESTemplateHelper.evalTemplate((ConfigDSLUtil)this.configDSLUtil, (String)templateName, (Object)params);
    }

    public String httpGetforString(String url) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString((String)url);
    }

    public <T> T httpGetforObject(String url, Class<T> resultType) throws HttpProxyRequestException {
        return (T)HttpRequestProxy.httpGetforObject((String)url, resultType);
    }

    public String httpGetforString(String poolname, String url) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString((String)poolname, (String)url);
    }

    public <T> T httpGetforObject(String poolname, String url, Class<T> resultType) throws HttpProxyRequestException {
        return (T)HttpRequestProxy.httpGetforObject((String)poolname, (String)url, resultType);
    }

    public <T> List<T> httpGetforList(String url, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforList((String)url, resultType);
    }

    public <K, T> Map<K, T> httpGetforMap(String url, Class<K> keyType, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforMap((String)url, keyType, resultType);
    }

    public <T> Set<T> httpGetforSet(String url, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforSet((String)url, resultType);
    }

    public <T> List<T> httpGetforList(String poolName, String url, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforList((String)poolName, (String)url, resultType);
    }

    public <D, T> D httpGetforTypeObject(String url, Class<D> containType, Class<T> resultType) throws HttpProxyRequestException {
        return (D)HttpRequestProxy.httpGetforTypeObject((String)url, containType, resultType);
    }

    public <D, T> D httpGetforTypeObject(String poolName, String url, Class<D> containType, Class<T> resultType) throws HttpProxyRequestException {
        return (D)HttpRequestProxy.httpGetforTypeObject((String)poolName, (String)url, containType, resultType);
    }

    public <T> HttpResult<T> putBodyForList(HttpInputDataTranPlugin httpInputDataTranPlugin, final HttpResultParserContext httpResultParserContext, DynamicHeaderContext dynamicHeaderContext, Map params, final Class<T> resultType) throws HttpProxyRequestException {
        final HttpResult httpResult = new HttpResult();
        final HttpInputConfig httpInputConfig = httpInputDataTranPlugin.getHttpInputConfig();
        String dsl = this.evalTemplate(httpInputConfig.getQueryDslName(), params);
        if (logger.isInfoEnabled() && httpInputConfig.isShowDsl()) {
            logger.info(dsl);
        }
        if (dynamicHeaderContext != null) {
            dynamicHeaderContext.setDatas(dsl);
        }
        BaseURLResponseHandler baseURLResponseHandler = new BaseURLResponseHandler<List<T>>(){

            public List<T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                httpResult.setResponse(response);
                HttpConfigClientProxy.handleListResponse(httpResult, httpInputConfig, httpResultParserContext, this.url, response, resultType);
                return httpResult.getDatas();
            }
        };
        List datas = (List)HttpRequestProxy.putBody((String)httpInputConfig.getSourceHttpPool(), (String)dsl, (String)httpInputConfig.getQueryUrl(), HttpProxyHelper.getHttpHeaders(httpInputConfig, dynamicHeaderContext), (ContentType)ContentType.APPLICATION_JSON, (ResponseHandler)baseURLResponseHandler);
        httpResult.setDatas(datas);
        return httpResult;
    }

    public <T> HttpResult<T> putForList(HttpInputDataTranPlugin httpInputDataTranPlugin, final HttpResultParserContext httpResultParserContext, DynamicHeaderContext dynamicHeaderContext, Map params, final Class<T> resultType) throws HttpProxyRequestException {
        final HttpResult httpResult = new HttpResult();
        final HttpInputConfig httpInputConfig = httpInputDataTranPlugin.getHttpInputConfig();
        List datas = HttpRequestProxy.httpPutforList((String)httpInputConfig.getSourceHttpPool(), (String)httpInputConfig.getQueryUrl(), (Map)params, HttpProxyHelper.getHttpHeaders(httpInputConfig, dynamicHeaderContext), resultType, (BaseURLResponseHandler)new BaseURLResponseHandler<List<T>>(){

            public List<T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                httpResult.setResponse(response);
                HttpConfigClientProxy.handleListResponse(httpResult, httpInputConfig, httpResultParserContext, this.url, response, resultType);
                return httpResult.getDatas();
            }
        });
        httpResult.setDatas(datas);
        return httpResult;
    }

    public static <T> void handleListResponse(HttpResult<T> httpResult, HttpInputConfig httpInputConfig, HttpResultParserContext httpResultParserContext, String url, HttpResponse response, Class<T> resultType) throws ClientProtocolException, IOException {
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && status < 300) {
            if (httpInputConfig.getHttpResultParser() == null) {
                HttpEntity entity = response.getEntity();
                List datas = entity != null ? ResponseUtil.converJson2List((HttpEntity)entity, resultType) : null;
                httpResult.setDatas(datas);
            } else {
                try {
                    httpInputConfig.getHttpResultParser().parserHttpResult(httpResult, httpResultParserContext);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DataImportException("httpInputConfig.getHttpResultParser().parserHttpResult failed:", e);
                }
            }
        } else {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Request url:" + url + ",status:" + status);
                }
                throw new HttpProxyRequestException("Request url:" + url + ",error:" + EntityUtils.toString((HttpEntity)entity));
            }
            throw new HttpProxyRequestException("Request url:" + url + ",Unexpected response status: " + status);
        }
    }

    public String putJson(HttpOutputDataTranPlugin httpOutputDataTranPlugin, DynamicHeaderContext dynamicHeaderContext, Map params) throws HttpProxyRequestException {
        HttpOutputConfig httpOutputConfig = httpOutputDataTranPlugin.getHttpOutputConfig();
        String requestBody = this.evalTemplate(httpOutputConfig.getDataDslName(), params);
        if (logger.isInfoEnabled() && httpOutputConfig.isShowDsl()) {
            logger.info(requestBody);
        }
        return HttpRequestProxy.putJson((String)httpOutputConfig.getTargetHttpPool(), (String)requestBody, (String)httpOutputConfig.getServiceUrl(), HttpProxyHelper.getHttpHeaders(httpOutputConfig, dynamicHeaderContext));
    }

    public String sendBody(HttpOutputDataTranPlugin httpOutputDataTranPlugin, DynamicHeaderContext dynamicHeaderContext, Map params) throws HttpProxyRequestException {
        HttpOutputConfig httpOutputConfig = httpOutputDataTranPlugin.getHttpOutputConfig();
        String requestBody = this.evalTemplate(httpOutputConfig.getDataDslName(), params);
        if (logger.isInfoEnabled() && httpOutputConfig.isShowDsl()) {
            logger.info(requestBody);
        }
        return (String)HttpRequestProxy.sendBody((String)httpOutputConfig.getTargetHttpPool(), (String)requestBody, (String)httpOutputConfig.getServiceUrl(), HttpProxyHelper.getHttpHeaders(httpOutputConfig, dynamicHeaderContext), (ContentType)ContentType.APPLICATION_JSON, (ResponseHandler)new BaseURLResponseHandler<String>(){

            public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return ResponseUtil.handleStringResponse((String)this.url, (HttpResponse)response);
            }
        });
    }

    public <T> HttpResult<T> sendBodyForList(HttpInputDataTranPlugin httpInputDataTranPlugin, final HttpResultParserContext httpResultParserContext, DynamicHeaderContext dynamicHeaderContext, Map params, final Class<T> resultType) throws HttpProxyRequestException {
        final HttpResult httpResult = new HttpResult();
        final HttpInputConfig httpInputConfig = httpInputDataTranPlugin.getHttpInputConfig();
        String dsl = this.evalTemplate(httpInputConfig.getQueryDslName(), params);
        if (logger.isInfoEnabled() && httpInputConfig.isShowDsl()) {
            logger.info(dsl);
        }
        if (dynamicHeaderContext != null) {
            dynamicHeaderContext.setDatas(dsl);
        }
        BaseURLResponseHandler baseURLResponseHandler = new BaseURLResponseHandler<List<T>>(){

            public List<T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                httpResult.setResponse(response);
                HttpConfigClientProxy.handleListResponse(httpResult, httpInputConfig, httpResultParserContext, this.url, response, resultType);
                return httpResult.getDatas();
            }
        };
        List datas = (List)HttpRequestProxy.sendBody((String)httpInputConfig.getSourceHttpPool(), (String)dsl, (String)httpInputConfig.getQueryUrl(), HttpProxyHelper.getHttpHeaders(httpInputConfig, dynamicHeaderContext), (ContentType)ContentType.APPLICATION_JSON, (ResponseHandler)baseURLResponseHandler);
        return httpResult;
    }

    public <T> HttpResult<T> postForList(HttpInputDataTranPlugin httpInputDataTranPlugin, final HttpResultParserContext httpResultParserContext, DynamicHeaderContext dynamicHeaderContext, Map params, final Class<T> resultType) throws HttpProxyRequestException {
        final HttpResult httpResult = new HttpResult();
        final HttpInputConfig httpInputConfig = httpInputDataTranPlugin.getHttpInputConfig();
        List datas = HttpRequestProxy.httpPostForList((String)httpInputConfig.getSourceHttpPool(), (String)httpInputConfig.getQueryUrl(), (Map)params, HttpProxyHelper.getHttpHeaders(httpInputConfig, dynamicHeaderContext), resultType, (BaseURLResponseHandler)new BaseURLResponseHandler<List<T>>(){

            public List<T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                httpResult.setResponse(response);
                HttpConfigClientProxy.handleListResponse(httpResult, httpInputConfig, httpResultParserContext, this.url, response, resultType);
                return httpResult.getDatas();
            }
        });
        return httpResult;
    }

    public <T> HttpResult<T> httpGetforList(HttpInputDataTranPlugin httpInputDataTranPlugin, final HttpResultParserContext httpResultParserContext, DynamicHeaderContext dynamicHeaderContext, Map params, final Class<T> resultType) throws HttpProxyRequestException {
        final HttpResult httpResult = new HttpResult();
        final HttpInputConfig httpInputConfig = httpInputDataTranPlugin.getHttpInputConfig();
        List datas = HttpRequestProxy.httpGetforList((String)httpInputConfig.getSourceHttpPool(), (String)httpInputConfig.getQueryUrl(), (Map)params, HttpProxyHelper.getHttpHeaders(httpInputConfig, dynamicHeaderContext), resultType, (BaseURLResponseHandler)new BaseURLResponseHandler<List<T>>(){

            public List<T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                httpResult.setResponse(response);
                HttpConfigClientProxy.handleListResponse(httpResult, httpInputConfig, httpResultParserContext, this.url, response, resultType);
                return httpResult.getDatas();
            }
        });
        return httpResult;
    }

    public <T> HttpResult<T> sendBodyForList(String poolname, String url, String dslName, Map params, final Class<T> resultType) throws HttpProxyRequestException {
        final HttpResult httpResult = new HttpResult();
        String dsl = this.evalTemplate(dslName, params);
        if (logger.isInfoEnabled()) {
            logger.info(dsl);
        }
        List datas = (List)HttpRequestProxy.sendBody((String)poolname, (String)dsl, (String)url, (Map)null, (ContentType)ContentType.APPLICATION_JSON, (ResponseHandler)new BaseURLResponseHandler<List<T>>(){

            public List<T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                httpResult.setResponse(response);
                return ResponseUtil.handleListResponse((String)this.url, (HttpResponse)response, (Class)resultType);
            }
        });
        httpResult.setDatas(datas);
        return httpResult;
    }

    public <T> T sendBody(String poolname, String requestBody, String url, Map<String, String> headers, ContentType contentType, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return (T)HttpRequestProxy.sendBody((String)poolname, (String)requestBody, (String)url, headers, (ContentType)contentType, responseHandler);
    }

    static {
        ShutdownUtil.addShutdownHook((Runnable)new Runnable(){

            @Override
            public void run() {
                configHolder.stopmonitor();
                configHolder.destory();
            }
        });
    }
}

