/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.es.input;

import com.frameworkset.util.SimpleStringUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.frameworkset.elasticsearch.ElasticSearchHelper;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.entity.ESDatas;
import org.frameworkset.elasticsearch.entity.MetaMap;
import org.frameworkset.elasticsearch.template.BaseTemplateContainerImpl;
import org.frameworkset.elasticsearch.template.BaseTemplateMeta;
import org.frameworkset.elasticsearch.template.DSLParserException;
import org.frameworkset.elasticsearch.template.ESInfo;
import org.frameworkset.elasticsearch.template.TemplateMeta;
import org.frameworkset.tran.BaseDataTran;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.JobCountDownLatch;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.plugin.InputPlugin;
import org.frameworkset.tran.plugin.es.BaseESPlugin;
import org.frameworkset.tran.plugin.es.input.BaseESExporterScrollHandler;
import org.frameworkset.tran.plugin.es.input.ES2TranResultSet;
import org.frameworkset.tran.plugin.es.input.ESDirectExporterScrollHandler;
import org.frameworkset.tran.plugin.es.input.ESExporterScrollHandler;
import org.frameworkset.tran.plugin.es.input.ElasticsearchInputConfig;
import org.frameworkset.tran.schedule.TaskContext;

public class ElasticsearchInputDataTranPlugin
extends BaseESPlugin
implements InputPlugin {
    protected String jobType;
    protected ElasticsearchInputConfig elasticsearchInputConfig;

    public ElasticsearchInputDataTranPlugin(ImportContext importContext) {
        super(importContext);
        this.elasticsearchInputConfig = (ElasticsearchInputConfig)importContext.getInputConfig();
        this.jobType = "ElasticsearchInputDataTranPlugin";
    }

    @Override
    public void init() {
    }

    @Override
    public String getJobType() {
        return this.jobType;
    }

    @Override
    public void beforeInit() {
        this.esConfig = this.elasticsearchInputConfig.getEsConfig();
        this.applicationPropertiesFile = this.importContext.getApplicationPropertiesFile();
        this.initES();
    }

    @Override
    public void afterInit() {
    }

    @Override
    public void initStatusTableId() {
        if (this.dataTranPlugin.isIncreamentImport()) {
            if (this.elasticsearchInputConfig.getDslFile() != null && !this.elasticsearchInputConfig.getDslFile().equals("") && SimpleStringUtil.isNotEmpty((String)this.elasticsearchInputConfig.getDslName())) {
                try {
                    ClientInterface clientInterface = ElasticSearchHelper.getConfigRestClientUtil((String)this.elasticsearchInputConfig.getSourceElasticsearch(), (String)this.elasticsearchInputConfig.getDslFile());
                    ESInfo esInfo = clientInterface.getESInfo(this.elasticsearchInputConfig.getDslName());
                    this.importContext.setStatusTableId(esInfo.getTemplate().hashCode());
                }
                catch (Exception e) {
                    throw new DataImportException(e);
                }
            } else if (SimpleStringUtil.isNotEmpty((String)this.elasticsearchInputConfig.getDsl())) {
                this.importContext.setStatusTableId(this.elasticsearchInputConfig.getDsl().hashCode());
            }
        }
    }

    protected void commonImportData(TaskContext taskContext, BaseESExporterScrollHandler<MetaMap> esExporterScrollHandler) throws Exception {
        Map params = this.dataTranPlugin.getJobInputParams(taskContext);
        params.put("size", this.importContext.getFetchSize());
        if (this.elasticsearchInputConfig.isSliceQuery()) {
            params.put("sliceMax", this.elasticsearchInputConfig.getSliceSize());
        }
        Date date = new Date();
        this.exportESData(taskContext, esExporterScrollHandler, params, date, date);
    }

    protected String getQueryUrl(TaskContext taskContext, Date lastStartValue, Date lastEndValue) {
        if (this.elasticsearchInputConfig.getQueryUrl() != null) {
            return this.elasticsearchInputConfig.getQueryUrl();
        }
        if (this.elasticsearchInputConfig.getQueryUrlFunction() != null) {
            return this.elasticsearchInputConfig.getQueryUrlFunction().queryUrl(taskContext, lastStartValue, lastEndValue);
        }
        throw new DataImportException("query url or query url function not setted.");
    }

    protected void exportESData(TaskContext taskContext, BaseESExporterScrollHandler<MetaMap> esExporterScrollHandler, Map params, Date lastStartValue, Date lastEndValue) {
        if (SimpleStringUtil.isNotEmpty((String)this.elasticsearchInputConfig.getDslFile()) && SimpleStringUtil.isNotEmpty((String)this.elasticsearchInputConfig.getDslName())) {
            ClientInterface clientUtil = ElasticSearchHelper.getConfigRestClientUtil((String)this.elasticsearchInputConfig.getSourceElasticsearch(), (String)this.elasticsearchInputConfig.getDslFile());
            this.dslScriptByConfig(clientUtil, this.elasticsearchInputConfig.getDslName(), taskContext, esExporterScrollHandler, params, lastStartValue, lastEndValue);
        } else if (SimpleStringUtil.isNotEmpty((String)this.elasticsearchInputConfig.getDsl())) {
            final String dslName = this.elasticsearchInputConfig.getDslName();
            ClientInterface clientUtil = ElasticSearchHelper.getConfigRestClientUtil((String)this.elasticsearchInputConfig.getSourceElasticsearch(), (BaseTemplateContainerImpl)new BaseTemplateContainerImpl(this.elasticsearchInputConfig.getDslNamespace()){

                protected Map<String, TemplateMeta> loadTemplateMetas(String namespace) {
                    try {
                        BaseTemplateMeta baseTemplateMeta = new BaseTemplateMeta();
                        baseTemplateMeta.setName(dslName);
                        baseTemplateMeta.setNamespace(namespace);
                        baseTemplateMeta.setDslTemplate(ElasticsearchInputDataTranPlugin.this.elasticsearchInputConfig.getDsl());
                        baseTemplateMeta.setMultiparser(Boolean.valueOf(true));
                        LinkedHashMap<String, TemplateMeta> templateMetaMap = new LinkedHashMap<String, TemplateMeta>();
                        templateMetaMap.put(baseTemplateMeta.getName(), (TemplateMeta)baseTemplateMeta);
                        return templateMetaMap;
                    }
                    catch (Exception e) {
                        throw new DSLParserException((Throwable)e);
                    }
                }

                protected long getLastModifyTime(String namespace) {
                    return -1L;
                }
            });
            this.dslScriptByConfig(clientUtil, dslName, taskContext, esExporterScrollHandler, params, lastStartValue, lastEndValue);
        } else {
            throw new DataImportException("DslFile or DslName or Dsl Script is not setted by ElasticsearchInputConfig.");
        }
    }

    private void dslScriptByConfig(ClientInterface clientUtil, String dslName, TaskContext taskContext, BaseESExporterScrollHandler<MetaMap> esExporterScrollHandler, Map params, Date lastStartValue, Date lastEndValue) {
        ESDatas response = null;
        response = !this.elasticsearchInputConfig.isSliceQuery() ? (this.importContext.isParallel() && esExporterScrollHandler instanceof ESDirectExporterScrollHandler ? clientUtil.scrollParallel(this.getQueryUrl(taskContext, lastStartValue, lastEndValue), dslName, this.elasticsearchInputConfig.getScrollLiveTime(), params, MetaMap.class, esExporterScrollHandler) : clientUtil.scroll(this.getQueryUrl(taskContext, lastStartValue, lastEndValue), dslName, this.elasticsearchInputConfig.getScrollLiveTime(), params, MetaMap.class, esExporterScrollHandler)) : clientUtil.scrollSliceParallel(this.getQueryUrl(taskContext, lastStartValue, lastEndValue), dslName, params, this.elasticsearchInputConfig.getScrollLiveTime(), MetaMap.class, esExporterScrollHandler);
        if (this.logger.isInfoEnabled()) {
            if (response != null) {
                this.logger.info("Export compoleted and export total {} records.", (Object)response.getTotalSize());
            } else {
                this.logger.info("Export compoleted and export no records or failed.");
            }
        }
    }

    @Override
    protected Object formatLastDateValue(Date date) {
        String lastValueDateformat = this.importContext.getLastValueDateformat();
        if (lastValueDateformat != null && !lastValueDateformat.equals("")) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(lastValueDateformat);
            return simpleDateFormat.format(date);
        }
        return date;
    }

    protected void increamentImportData(TaskContext taskContext, BaseESExporterScrollHandler<MetaMap> esExporterScrollHandler) throws Exception {
        Object[] lastValues;
        Object lastValue;
        Map params = this.dataTranPlugin.getJobInputParams(taskContext);
        params.put("size", this.importContext.getFetchSize());
        if (this.elasticsearchInputConfig.isSliceQuery()) {
            params.put("sliceMax", this.elasticsearchInputConfig.getSliceSize());
        }
        if ((lastValue = (lastValues = this.dataTranPlugin.putLastParamValue(params))[0]) instanceof Date) {
            Date lastEndValue = null;
            lastEndValue = this.importContext.increamentEndOffset() != null ? (Date)lastValues[1] : new Date();
            this.exportESData(taskContext, esExporterScrollHandler, params, (Date)lastValue, lastEndValue);
        } else {
            Date date = new Date();
            this.exportESData(taskContext, esExporterScrollHandler, params, date, date);
        }
    }

    @Override
    public void doImportData(TaskContext taskContext) throws DataImportException {
        ES2TranResultSet jdbcResultSet = new ES2TranResultSet(this.importContext);
        JobCountDownLatch countDownLatch = new JobCountDownLatch(1);
        final BaseDataTran es2DBDataTran = this.dataTranPlugin.createBaseDataTran(taskContext, jdbcResultSet, countDownLatch, this.dataTranPlugin.getCurrentStatus());
        ESExporterScrollHandler<MetaMap> esExporterScrollHandler = new ESExporterScrollHandler<MetaMap>(this.importContext, es2DBDataTran);
        try {
            Thread tranThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    es2DBDataTran.tran();
                }
            }, "Elasticsearch-Input-Tran");
            tranThread.start();
            if (!this.importContext.isIncreamentImport()) {
                this.commonImportData(taskContext, esExporterScrollHandler);
            } else {
                this.increamentImportData(taskContext, esExporterScrollHandler);
            }
        }
        catch (DataImportException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataImportException(e);
        }
        finally {
            block15: {
                jdbcResultSet.reachEend();
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException e) {
                    if (!this.logger.isErrorEnabled()) break block15;
                    this.logger.error("", (Throwable)e);
                }
            }
            Throwable exception = countDownLatch.getException();
            if (exception != null) {
                if (exception instanceof DataImportException) {
                    throw (DataImportException)exception;
                }
                throw new DataImportException(exception);
            }
        }
    }
}

