/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.es.input;

import com.frameworkset.common.poolman.BatchHandler;
import com.frameworkset.common.poolman.ConfigSQLExecutor;
import com.frameworkset.common.poolman.SQLExecutor;
import java.util.List;
import org.frameworkset.elasticsearch.entity.ESDatas;
import org.frameworkset.elasticsearch.scroll.HandlerInfo;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.plugin.db.output.DBOutputConfig;
import org.frameworkset.tran.plugin.es.input.BaseESExporterScrollHandler;
import org.frameworkset.tran.schedule.TaskContext;

public class ESDirectExporterScrollHandler<T>
extends BaseESExporterScrollHandler<T> {
    protected ConfigSQLExecutor configSQLExecutor;
    protected DBOutputConfig dbOutputConfig;
    protected TaskContext taskContext;

    public ESDirectExporterScrollHandler(TaskContext taskContext, ImportContext importContext, ConfigSQLExecutor configSQLExecutor) {
        super(importContext);
        this.configSQLExecutor = configSQLExecutor;
        if (importContext.getOutputConfig() instanceof DBOutputConfig) {
            this.dbOutputConfig = (DBOutputConfig)importContext.getOutputConfig();
        }
        this.taskContext = taskContext;
    }

    @Override
    public void handle(ESDatas<T> response, HandlerInfo handlerInfo) throws Exception {
        String targetDBName;
        long totalSize = response.getTotalSize();
        List datas = response.getDatas();
        int batchNo = this.importContext.getExportCount().increamentCount();
        if (totalSize == 0L || datas == null || datas.size() == 0) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Igonre Execute export task {}:zero or null datas.", (Object)batchNo);
            }
            return;
        }
        int batchSize = this.importContext.getStoreBatchSize();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Execute task {} start.", (Object)batchNo);
        }
        if ((targetDBName = this.dbOutputConfig.getTargetDBName(this.taskContext)) == null) {
            targetDBName = this.dbOutputConfig.getTargetDbname();
        }
        if (this.dbOutputConfig.getSql() == null) {
            this.configSQLExecutor.executeBatch(targetDBName, this.dbOutputConfig.getSqlName(), datas, batchSize, this.dbOutputConfig.getBatchHandler());
        } else {
            SQLExecutor.executeBatch((String)targetDBName, (String)this.dbOutputConfig.getSql(), (List)datas, (int)batchSize, (BatchHandler)this.dbOutputConfig.getBatchHandler());
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Execute task {} complete and export data {} record.", (Object)batchNo, (Object)datas.size());
        }
    }
}

