/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.db.input;

import com.frameworkset.common.poolman.ConfigSQLExecutor;
import com.frameworkset.common.poolman.SQLExecutor;
import com.frameworkset.common.poolman.handle.NullRowHandler;
import com.frameworkset.common.poolman.handle.ResultSetHandler;
import com.frameworkset.common.poolman.util.DBOptions;
import com.frameworkset.orm.transaction.TransactionManager;
import com.frameworkset.util.SimpleStringUtil;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.frameworkset.persitent.util.SQLInfo;
import org.frameworkset.tran.DBConfig;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.DataTranPluginImpl;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.plugin.InputPlugin;
import org.frameworkset.tran.plugin.db.BaseDBPlugin;
import org.frameworkset.tran.plugin.db.input.DBInputConfig;
import org.frameworkset.tran.plugin.db.input.DefaultResultSetHandler;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.task.TaskFailedException;
import org.frameworkset.util.tokenizer.TextGrammarParser;

public class DBInputDataTranPlugin
extends BaseDBPlugin
implements InputPlugin {
    protected String jobType;
    protected org.frameworkset.tran.schedule.SQLInfo sqlInfo;
    protected ConfigSQLExecutor executor;
    protected DBInputConfig dbInputConfig;

    public DBInputDataTranPlugin(ImportContext importContext) {
        super(importContext);
        this.dbInputConfig = (DBInputConfig)importContext.getInputConfig();
        this.jobType = "DBInputDataTranPlugin";
    }

    @Override
    public void beforeInit() {
    }

    @Override
    public void init() {
        DataTranPluginImpl.initDS(this.dbStartResult, this.dbInputConfig.getDbConfig());
        this.initSourceSQLInfo();
    }

    @Override
    public String getJobType() {
        return this.jobType;
    }

    @Override
    public void afterInit() {
        if (this.sqlInfo != null && this.sqlInfo.getParamSize() > 0 && !this.dataTranPlugin.isIncreamentImport() && this.importContext.getJobInputParams() == null) {
            throw new TaskFailedException("1.Parameter variables cannot be set in non-increament import SQL statements\uff1a" + this.dbInputConfig.getSql() + "\r\n2.Parameter values must be setted by BaseImportBuilder.addParam(String,Object) method.");
        }
    }

    @Override
    public void initStatusTableId() {
        if (this.dataTranPlugin.isIncreamentImport()) {
            if (this.dbInputConfig.getSql() != null && !this.dbInputConfig.getSql().equals("")) {
                this.importContext.setStatusTableId(this.dbInputConfig.getSql().hashCode());
            } else {
                String sqlFile = this.dbInputConfig.getSqlFilepath();
                String sqlName = this.dbInputConfig.getSqlName();
                this.importContext.setStatusTableId((sqlFile + "$$" + sqlName).hashCode());
            }
        }
    }

    public void initSourceSQLInfo() {
        if ((this.dbInputConfig.getSql() == null || this.dbInputConfig.getSql().equals("")) && this.dbInputConfig.getSqlFilepath() != null && !this.dbInputConfig.getSqlFilepath().equals("")) {
            try {
                ConfigSQLExecutor executor = new ConfigSQLExecutor(this.dbInputConfig.getSqlFilepath());
                SQLInfo sqlInfo = executor.getSqlInfo(this.getSourceDBName(), this.dbInputConfig.getSqlName());
                this.executor = executor;
                this.dbInputConfig.setSql(sqlInfo.getSql());
            }
            catch (SQLException e) {
                throw new DataImportException(e);
            }
        }
        if (this.dbInputConfig.getSql() != null && !this.dbInputConfig.getSql().equals("")) {
            this.initSQLInfoParams();
        }
    }

    private void initSQLInfoParams() {
        String originSQL = this.dbInputConfig.getSql();
        List tokens = TextGrammarParser.parser((String)originSQL, (String)"#[", (String)"]");
        org.frameworkset.tran.schedule.SQLInfo _sqlInfo = new org.frameworkset.tran.schedule.SQLInfo();
        int paramSize = 0;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < tokens.size(); ++i) {
            TextGrammarParser.GrammarToken token = (TextGrammarParser.GrammarToken)tokens.get(i);
            if (token.texttoken()) {
                builder.append(token.getText());
                continue;
            }
            builder.append("?");
            if (paramSize == 0 && !this.importContext.isLastValueColumnSetted() && this.importContext.isImportIncreamentConfigSetted()) {
                _sqlInfo.setLastValueVarName(token.getText());
            }
            ++paramSize;
        }
        _sqlInfo.setParamSize(paramSize);
        _sqlInfo.setSql(builder.toString());
        this.sqlInfo = _sqlInfo;
    }

    public org.frameworkset.tran.schedule.SQLInfo getSqlInfo() {
        return this.sqlInfo;
    }

    @Override
    public String getLastValueVarName() {
        if (!this.importContext.isLastValueColumnSetted() && this.importContext.isImportIncreamentConfigSetted()) {
            return this.sqlInfo != null ? this.sqlInfo.getLastValueVarName() : null;
        }
        return super.getLastValueVarName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commonImportData(TaskContext taskContext, ResultSetHandler resultSetHandler) throws Exception {
        String sourceDBName = this.getSourceDBName();
        boolean isEnableDBTransaction = this.dbInputConfig.getDbConfig() != null ? this.dbInputConfig.getDbConfig().isEnableDBTransaction() : false;
        DBOptions dbOptions = this.getDBOptions();
        Map params = this.dataTranPlugin.getJobInputParams(taskContext);
        if (params == null || params.size() == 0) {
            if (this.importContext.getDataRefactor() == null || !isEnableDBTransaction) {
                if (this.executor == null) {
                    SQLExecutor.queryWithDBNameByNullRowHandler((DBOptions)dbOptions, (NullRowHandler)resultSetHandler, (String)sourceDBName, (String)this.dbInputConfig.getSql(), (Object[])new Object[0]);
                } else {
                    this.executor.queryWithDBNameByNullRowHandler(dbOptions, (NullRowHandler)resultSetHandler, sourceDBName, this.dbInputConfig.getSqlName(), new Object[0]);
                }
            } else {
                TransactionManager transactionManager = new TransactionManager();
                try {
                    transactionManager.begin(TransactionManager.RW_TRANSACTION);
                    if (this.executor == null) {
                        SQLExecutor.queryWithDBNameByNullRowHandler((DBOptions)dbOptions, (NullRowHandler)resultSetHandler, (String)sourceDBName, (String)this.dbInputConfig.getSql(), (Object[])new Object[0]);
                    } else {
                        this.executor.queryWithDBNameByNullRowHandler(dbOptions, (NullRowHandler)resultSetHandler, sourceDBName, this.dbInputConfig.getSqlName(), new Object[0]);
                    }
                    transactionManager.commit();
                }
                finally {
                    transactionManager.releasenolog();
                }
            }
        } else if (this.importContext.getDataRefactor() == null || !isEnableDBTransaction) {
            if (this.executor == null) {
                SQLExecutor.queryBeanWithDBNameByNullRowHandler((DBOptions)dbOptions, (NullRowHandler)resultSetHandler, (String)sourceDBName, (String)this.dbInputConfig.getSql(), (Object)params);
            } else {
                this.executor.queryBeanWithDBNameByNullRowHandler(dbOptions, (NullRowHandler)resultSetHandler, sourceDBName, this.dbInputConfig.getSqlName(), (Object)params);
            }
        } else {
            TransactionManager transactionManager = new TransactionManager();
            try {
                transactionManager.begin(TransactionManager.RW_TRANSACTION);
                if (this.executor == null) {
                    SQLExecutor.queryBeanWithDBNameByNullRowHandler((DBOptions)dbOptions, (NullRowHandler)resultSetHandler, (String)sourceDBName, (String)this.dbInputConfig.getSql(), (Object)params);
                } else {
                    this.executor.queryBeanWithDBNameByNullRowHandler(dbOptions, (NullRowHandler)resultSetHandler, sourceDBName, this.dbInputConfig.getSqlName(), (Object)params);
                }
                transactionManager.commit();
            }
            finally {
                transactionManager.releasenolog();
            }
        }
    }

    private String getSourceDBName() {
        DBConfig dbConfig = this.dbInputConfig.getDbConfig();
        String sourceDBName = this.dbInputConfig.getSourceDbname();
        if (sourceDBName == null && dbConfig != null && SimpleStringUtil.isNotEmpty((String)dbConfig.getDbName())) {
            sourceDBName = dbConfig.getDbName();
        }
        if (sourceDBName == null) {
            throw new DataImportException("DbConfig is null,please set dbname use importBuilder.setDbName(dbname) or importBuilder.setSourceDBName(dbname) and  other database configs use importBuilder,dbname and other database configs can also been configed in appliction.properties file or other config file bboss supported.");
        }
        return sourceDBName;
    }

    private DBOptions getDBOptions() {
        DBOptions dbOptions = null;
        if (this.dbInputConfig.getJdbcFetchsize() != null && this.dbInputConfig.getJdbcFetchsize() != 0) {
            dbOptions = new DBOptions();
            dbOptions.setFetchSize(this.dbInputConfig.getJdbcFetchsize());
        }
        return dbOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void increamentImportData(TaskContext taskContext, ResultSetHandler resultSetHandler) throws Exception {
        boolean isEnableDBTransaction;
        String sourceDBName = this.getSourceDBName();
        DBOptions dbOptions = this.getDBOptions();
        Map params = this.dataTranPlugin.getJobInputParams(taskContext);
        boolean bl = isEnableDBTransaction = this.dbInputConfig.getDbConfig() != null ? this.dbInputConfig.getDbConfig().isEnableDBTransaction() : false;
        if (this.importContext.getDataRefactor() == null || !isEnableDBTransaction) {
            if (this.executor == null) {
                SQLExecutor.queryBeanWithDBNameByNullRowHandler((DBOptions)dbOptions, (NullRowHandler)resultSetHandler, (String)sourceDBName, (String)this.dbInputConfig.getSql(), (Object)this.dataTranPlugin.getParamValue(params));
            } else {
                this.executor.queryBeanWithDBNameByNullRowHandler(dbOptions, (NullRowHandler)resultSetHandler, sourceDBName, this.dbInputConfig.getSqlName(), (Object)this.dataTranPlugin.getParamValue(params));
            }
        } else {
            TransactionManager transactionManager = new TransactionManager();
            try {
                transactionManager.begin(TransactionManager.RW_TRANSACTION);
                if (this.executor == null) {
                    SQLExecutor.queryBeanWithDBNameByNullRowHandler((DBOptions)dbOptions, (NullRowHandler)resultSetHandler, (String)sourceDBName, (String)this.dbInputConfig.getSql(), (Object)this.dataTranPlugin.getParamValue(params));
                } else {
                    this.executor.queryBeanWithDBNameByNullRowHandler(dbOptions, (NullRowHandler)resultSetHandler, sourceDBName, this.dbInputConfig.getSqlName(), (Object)this.dataTranPlugin.getParamValue(params));
                }
            }
            finally {
                transactionManager.releasenolog();
            }
        }
    }

    @Override
    public void doImportData(TaskContext taskContext) throws DataImportException {
        DefaultResultSetHandler resultSetHandler = new DefaultResultSetHandler(taskContext, this.importContext, this.dataTranPlugin);
        try {
            if (this.sqlInfo.getParamSize() == 0) {
                this.commonImportData(taskContext, resultSetHandler);
            } else if (!this.dataTranPlugin.isIncreamentImport()) {
                this.commonImportData(taskContext, resultSetHandler);
            } else {
                this.increamentImportData(taskContext, resultSetHandler);
            }
        }
        catch (DataImportException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataImportException(e);
        }
    }
}

