/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.metrics;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.frameworkset.tran.status.BaseStatusManager;

public class JobTaskMetrics {
    private Date jobStartTime;
    private Date jobEndTime;
    protected long totalRecords;
    private long totalFailedRecords;
    private long totalIgnoreRecords;
    private long totalSuccessRecords;
    protected int tasks;
    protected volatile int errorTasks;
    protected volatile int exceptionTasks;
    private String jobNo;
    private Object lastValue;
    private String jobId;
    private String jobName;
    private Map<String, Object> jobExecutorDatas;
    private ReentrantLock tasksLock = new ReentrantLock();
    private ReentrantLock errtasksLock = new ReentrantLock();
    private ReentrantLock exceptiontasksLock = new ReentrantLock();

    public JobTaskMetrics putJobExecutorData(String name, Object value) {
        if (this.jobExecutorDatas == null) {
            this.jobExecutorDatas = new LinkedHashMap<String, Object>();
        }
        this.jobExecutorDatas.put(name, value);
        return this;
    }

    public Object readJobExecutorData(String name) {
        if (this.jobExecutorDatas != null) {
            return this.jobExecutorDatas.get(name);
        }
        return null;
    }

    public Map<String, Object> getJobExecutorDatas() {
        return this.jobExecutorDatas;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public Date getJobStartTime() {
        return this.jobStartTime;
    }

    public void setJobStartTime(Date jobStartTime) {
        this.jobStartTime = jobStartTime;
    }

    public long getTotalRecords() {
        return this.totalRecords;
    }

    public void setTotalRecords(long totalRecords) {
        this.totalRecords = totalRecords;
    }

    public void increamentRecords(long records) {
        this.totalRecords += records;
    }

    public long getTotalFailedRecords() {
        return this.totalFailedRecords;
    }

    public void increamentFailedRecords(long failedRecords) {
        this.totalFailedRecords += failedRecords;
    }

    public void setTotalFailedRecords(long totalFailedRecords) {
        this.totalFailedRecords = totalFailedRecords;
    }

    public long getTotalIgnoreRecords() {
        return this.totalIgnoreRecords;
    }

    public void increamentIgnoreRecords(long ignoreRecords) {
        this.totalIgnoreRecords += ignoreRecords;
    }

    public void setTotalIgnoreRecords(long totalIgnoreRecords) {
        this.totalIgnoreRecords = totalIgnoreRecords;
    }

    public long getTotalSuccessRecords() {
        return this.totalSuccessRecords;
    }

    public void increamentSuccessRecords(long successRecords) {
        this.totalSuccessRecords += successRecords;
    }

    public void setTotalSuccessRecords(long totalSuccessRecords) {
        this.totalSuccessRecords = totalSuccessRecords;
    }

    public void await() {
    }

    public void await(long waitime) {
    }

    public int getTasks() {
        return this.tasks;
    }

    public void setTasks(int tasks) {
        this.tasks = tasks;
    }

    public String getJobNo() {
        return this.jobNo;
    }

    public void setJobNo(String jobNo) {
        this.jobNo = jobNo;
    }

    public int increamentTasks() {
        this.tasksLock.lock();
        try {
            ++this.tasks;
            int n = this.tasks;
            return n;
        }
        finally {
            this.tasksLock.unlock();
        }
    }

    public int increamentErrorTasks() {
        this.errtasksLock.lock();
        try {
            ++this.errorTasks;
            int n = this.errorTasks;
            return n;
        }
        finally {
            this.errtasksLock.unlock();
        }
    }

    public int increamentExceptionTasks() {
        this.exceptiontasksLock.lock();
        try {
            ++this.exceptionTasks;
            int n = this.exceptionTasks;
            return n;
        }
        finally {
            this.exceptiontasksLock.unlock();
        }
    }

    public Date getJobEndTime() {
        return this.jobEndTime;
    }

    public void setJobEndTime(Date jobEndTime) {
        this.jobEndTime = jobEndTime;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.buildString(builder);
        return builder.toString();
    }

    protected void buildString(StringBuilder builder) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        builder.append("JobId:").append(this.jobId);
        builder.append(",JobName:").append(this.jobName);
        if (this.jobNo != null) {
            builder.append(",JobNo:").append(this.jobNo);
        } else {
            builder.append(",JobNo:-");
        }
        if (this.jobStartTime != null) {
            builder.append(",JobStartTime:").append(dateFormat.format(this.jobStartTime));
        } else {
            builder.append(",JobStartTime:-");
        }
        if (this.jobEndTime != null) {
            builder.append(",JobEndTime:").append(dateFormat.format(this.jobEndTime));
        } else {
            builder.append(",JobEndTime:-");
        }
        builder.append(",Total Records:").append(this.totalRecords);
        builder.append(",Total Success Records:").append(this.totalSuccessRecords);
        builder.append(",Total Failed Records:").append(this.totalFailedRecords);
        builder.append(",Total Ignore Records:").append(this.totalIgnoreRecords);
        builder.append(",Total Tasks:").append(this.tasks);
        builder.append(",Total lastValue:").append(this.lastValue);
        builder.append(",Elapsed Time:").append(this.getElapsed()).append("ms");
    }

    public long getElapsed() {
        if (this.getJobStartTime() != null && this.getJobEndTime() != null) {
            return this.getJobEndTime().getTime() - this.getJobStartTime().getTime();
        }
        return -1L;
    }

    public Object getLastValue() {
        return this.lastValue;
    }

    public void setLastValue(Object lastValue) {
        this.lastValue = lastValue;
    }

    public void putLastValue(Integer lastValueType, Object lastValue) {
        this.lastValue = BaseStatusManager.max(lastValueType, this.lastValue, lastValue);
    }

    public int getErrorTasks() {
        return this.errorTasks;
    }

    public void setErrorTasks(int errorTasks) {
        this.errorTasks = errorTasks;
    }

    public int getExceptionTasks() {
        return this.exceptionTasks;
    }

    public void setExceptionTasks(int exceptionTasks) {
        this.exceptionTasks = exceptionTasks;
    }
}

