/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.context;

import com.frameworkset.orm.annotation.BatchContext;
import com.frameworkset.orm.annotation.ESIndexWrapper;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.frameworkset.elasticsearch.client.ResultUtil;
import org.frameworkset.spi.geoip.IpInfo;
import org.frameworkset.tran.ColumnData;
import org.frameworkset.tran.CommonRecord;
import org.frameworkset.tran.DataRefactor;
import org.frameworkset.tran.FieldMeta;
import org.frameworkset.tran.Record;
import org.frameworkset.tran.TranMeta;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.config.BaseImportConfig;
import org.frameworkset.tran.config.ClientOptions;
import org.frameworkset.tran.config.ImportBuilder;
import org.frameworkset.tran.config.InputConfig;
import org.frameworkset.tran.config.OutputConfig;
import org.frameworkset.tran.context.Context;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.context.JobContext;
import org.frameworkset.tran.plugin.db.input.DBInputConfig;
import org.frameworkset.tran.plugin.db.output.DBOutputConfig;
import org.frameworkset.tran.plugin.es.ESField;
import org.frameworkset.tran.plugin.es.output.ElasticsearchOutputConfig;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.schedule.timer.TimeUtil;

public class ContextImpl
implements Context {
    protected List<FieldMeta> fieldValues;
    protected Map<String, FieldMeta> valuesIdxByName;
    protected Map<String, FieldMeta> fieldMetaMap;
    private boolean useBatchContextIndexName = false;
    protected Map<String, String> newfieldNames;
    protected Map<String, ColumnData> newfieldName2ndColumnDatas;
    protected BaseImportConfig baseImportConfig;
    protected TranResultSet tranResultSet;
    protected BatchContext batchContext;
    protected boolean drop;
    protected int status = 0;
    protected String index;
    protected String indexType;
    protected ESIndexWrapper esIndexWrapper;
    protected ClientOptions clientOptions;
    protected ImportContext importContext;
    protected TaskContext taskContext;
    protected ElasticsearchOutputConfig elasticsearchOutputConfig;
    protected DBInputConfig dbInputConfig;
    protected DBOutputConfig dbOutputConfig;
    protected CommonRecord commonRecord;

    public ContextImpl(TaskContext taskContext, ImportContext importContext, TranResultSet tranResultSet, BatchContext batchContext) {
        this.baseImportConfig = importContext.getImportConfig();
        this.importContext = importContext;
        OutputConfig outputConfig = importContext.getOutputConfig();
        if (outputConfig instanceof ElasticsearchOutputConfig) {
            this.elasticsearchOutputConfig = (ElasticsearchOutputConfig)outputConfig;
        } else if (outputConfig instanceof DBOutputConfig) {
            this.dbOutputConfig = (DBOutputConfig)outputConfig;
        }
        InputConfig inputConfig = importContext.getInputConfig();
        if (inputConfig instanceof DBInputConfig) {
            this.dbInputConfig = (DBInputConfig)inputConfig;
        }
        this.tranResultSet = tranResultSet;
        this.batchContext = batchContext;
        this.taskContext = taskContext != null ? taskContext : tranResultSet.getRecordTaskContext();
    }

    @Override
    public TranMeta getMetaData() {
        return this.tranResultSet.getMetaData();
    }

    @Override
    public TaskContext getTaskContext() {
        return this.taskContext;
    }

    @Override
    public void setIndex(String index) {
        this.index = index;
    }

    @Override
    public void setIndexType(String indexType) {
        this.indexType = indexType;
    }

    @Override
    public String getIndex() {
        return this.index;
    }

    @Override
    public String getIndexType() {
        return this.indexType;
    }

    @Override
    public Map<String, Object> getGeoipConfig() {
        return this.baseImportConfig.getGeoipConfig();
    }

    @Override
    public void afterRefactor() {
        if (this.elasticsearchOutputConfig != null && this.index != null && !this.index.equals("")) {
            this.esIndexWrapper = this.indexType == null ? new ESIndexWrapper(this.index, this.elasticsearchOutputConfig.getEsIndexWrapper().getType()) : new ESIndexWrapper(this.index, this.indexType);
        }
    }

    @Override
    public void setClientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        if (this.elasticsearchOutputConfig.getClientOptions() != null && clientOptions != null) {
            clientOptions.setParentClientOptions(this.elasticsearchOutputConfig.getClientOptions());
        }
    }

    @Override
    public ClientOptions getClientOptions() {
        if (this.clientOptions != null) {
            return this.clientOptions;
        }
        return this.elasticsearchOutputConfig != null ? this.elasticsearchOutputConfig.getClientOptions() : null;
    }

    @Override
    public String getOperation() {
        if (this.isInsert()) {
            return "index";
        }
        if (this.isUpdate()) {
            return "update";
        }
        if (this.isDelete()) {
            return "delete";
        }
        return "index";
    }

    @Override
    public List<FieldMeta> getGlobalFieldValues() {
        return this.baseImportConfig.getFieldValues();
    }

    @Override
    public Boolean getUseLowcase() {
        return this.baseImportConfig.getUseLowcase();
    }

    @Override
    public Object getValue(int i, String colName, int sqlType) throws Exception {
        return this.tranResultSet.getValue(i, colName, sqlType);
    }

    @Override
    public Boolean getUseJavaName() {
        return this.baseImportConfig.getUseJavaName();
    }

    @Override
    public DateFormat getDateFormat() {
        return this.baseImportConfig.getFormat();
    }

    @Override
    public void refactorData() throws Exception {
        DataRefactor dataRefactor = this.baseImportConfig.getDataRefactor();
        if (dataRefactor != null) {
            dataRefactor.refactor(this);
        }
    }

    @Override
    public ImportContext getImportContext() {
        return this.importContext;
    }

    @Override
    public List<FieldMeta> getFieldValues() {
        return this.fieldValues;
    }

    @Override
    public Map<String, FieldMeta> getFieldMetaMap() {
        return this.fieldMetaMap;
    }

    @Override
    public Context addFieldValue(String fieldName, Object value) {
        if (this.fieldValues == null) {
            this.fieldValues = new ArrayList<FieldMeta>();
            this.valuesIdxByName = new LinkedHashMap<String, FieldMeta>();
        }
        FieldMeta fieldMeta = ImportBuilder.addFieldValue(this.fieldValues, fieldName, value);
        this.valuesIdxByName.put(fieldName, fieldMeta);
        return this;
    }

    @Override
    public Context addFieldValue(String fieldName, String dateFormat, Object value) {
        if (this.fieldValues == null) {
            this.fieldValues = new ArrayList<FieldMeta>();
            this.valuesIdxByName = new LinkedHashMap<String, FieldMeta>();
        }
        FieldMeta fieldMeta = ImportBuilder.addFieldValue(this.fieldValues, fieldName, dateFormat, value, this.baseImportConfig.getLocale(), this.baseImportConfig.getTimeZone());
        this.valuesIdxByName.put(fieldName, fieldMeta);
        return this;
    }

    @Override
    public Context addFieldValue(String fieldName, String dateFormat, Object value, String locale, String timeZone) {
        if (this.fieldValues == null) {
            this.fieldValues = new ArrayList<FieldMeta>();
            this.valuesIdxByName = new LinkedHashMap<String, FieldMeta>();
        }
        FieldMeta fieldMeta = ImportBuilder.addFieldValue(this.fieldValues, fieldName, dateFormat, value, locale, timeZone);
        this.valuesIdxByName.put(fieldName, fieldMeta);
        return this;
    }

    @Override
    public Context addIgnoreFieldMapping(String sourceFieldName) {
        if (this.fieldMetaMap == null) {
            this.fieldMetaMap = new HashMap<String, FieldMeta>();
        }
        ImportBuilder.addIgnoreFieldMapping(this.fieldMetaMap, sourceFieldName);
        return this;
    }

    @Override
    public String getDBName() {
        if (this.dbInputConfig != null) {
            return this.dbInputConfig.getDBName();
        }
        if (this.dbOutputConfig != null) {
            return this.dbInputConfig.getDBName();
        }
        return null;
    }

    @Override
    public long getLongValue(String fieldName) throws Exception {
        Object value = this.getValue(fieldName);
        return ResultUtil.longValue((Object)value, (Long)0L);
    }

    @Override
    public String getStringValue(String fieldName) throws Exception {
        Object value = this.getValue(fieldName);
        return ResultUtil.stringValue((Object)value, null);
    }

    @Override
    public String getStringValue(String fieldName, String defaultValue) throws Exception {
        Object value = this.getValue(fieldName);
        return ResultUtil.stringValue((Object)value, (String)defaultValue);
    }

    @Override
    public boolean getBooleanValue(String fieldName) throws Exception {
        Object value = this.getValue(fieldName);
        return ResultUtil.booleanValue((Object)value, (boolean)false);
    }

    @Override
    public boolean getBooleanValue(String fieldName, boolean defaultValue) throws Exception {
        Object value = this.getValue(fieldName);
        return ResultUtil.booleanValue((Object)value, (boolean)defaultValue);
    }

    @Override
    public double getDoubleValue(String fieldName) throws Exception {
        Object value = this.getValue(fieldName);
        return ResultUtil.doubleValue((Object)value, (Double)0.0);
    }

    @Override
    public float getFloatValue(String fieldName) throws Exception {
        Object value = this.getValue(fieldName);
        return ResultUtil.floatValue((Object)value, (Float)Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public int getIntegerValue(String fieldName) throws Exception {
        Object value = this.getValue(fieldName);
        return ResultUtil.intValue((Object)value, (Integer)0);
    }

    @Override
    public Date getDateValue(String fieldName) throws Exception {
        Object value = this.getValue(fieldName);
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof LocalDateTime) {
            return TimeUtil.convertLocalDatetime((LocalDateTime)value);
        }
        if (value instanceof LocalDate) {
            return TimeUtil.convertLocalDate((LocalDate)value);
        }
        if (value instanceof BigDecimal) {
            return new Date(((BigDecimal)value).longValue());
        }
        if (value instanceof Long) {
            return new Date((Long)value);
        }
        throw new IllegalArgumentException("Convert date value failed:" + value);
    }

    @Override
    public Date getDateValue(String fieldName, DateFormat dateFormat) throws Exception {
        Object value = this.getValue(fieldName);
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof LocalDateTime) {
            return TimeUtil.convertLocalDatetime((LocalDateTime)value);
        }
        if (value instanceof LocalDate) {
            return TimeUtil.convertLocalDate((LocalDate)value);
        }
        if (value instanceof BigDecimal) {
            return new Date(((BigDecimal)value).longValue());
        }
        if (value instanceof Long) {
            return new Date((Long)value);
        }
        if (value instanceof String) {
            return dateFormat.parse((String)value);
        }
        throw new IllegalArgumentException("Convert date value failed:" + value);
    }

    @Override
    public Object getResultSetValue(String fieldName) {
        Object value = this.tranResultSet.getValue(fieldName);
        return TimeUtil.convertLocalDate(value);
    }

    @Override
    public Object getValue(String fieldName) throws Exception {
        FieldMeta fieldMeta = null;
        if (this.valuesIdxByName != null) {
            fieldMeta = this.valuesIdxByName.get(fieldName);
        }
        if (fieldMeta == null) {
            fieldMeta = this.baseImportConfig.getValueIdxByName(fieldName);
        }
        Object value = null;
        value = fieldMeta != null ? fieldMeta.getValue() : this.tranResultSet.getValue(fieldName);
        return TimeUtil.convertLocalDate(value);
    }

    @Override
    public Object getMetaValue(String fieldName) throws Exception {
        return this.tranResultSet.getMetaValue(fieldName);
    }

    @Override
    public FieldMeta getMappingName(String sourceFieldName) {
        FieldMeta fieldMeta;
        if (this.fieldMetaMap != null && (fieldMeta = this.fieldMetaMap.get(sourceFieldName)) != null) {
            return fieldMeta;
        }
        return this.baseImportConfig.getMappingName(sourceFieldName);
    }

    @Override
    public Object getEsId() throws Exception {
        return this.elasticsearchOutputConfig.getEsIdGenerator().genId(this);
    }

    @Override
    public boolean isDrop() {
        return this.drop;
    }

    @Override
    public void setDrop(boolean drop) {
        this.drop = drop;
    }

    @Override
    public IpInfo getIpInfo(String fieldName) throws Exception {
        Object _ip = this.getValue(fieldName);
        if (_ip == null) {
            return null;
        }
        if (BaseImportConfig.getGeoIPUtil(this.getGeoipConfig()) != null) {
            return BaseImportConfig.getGeoIPUtil(this.getGeoipConfig()).getIpInfo(String.valueOf(_ip));
        }
        return null;
    }

    @Override
    public IpInfo getIpInfoByIp(String ip) {
        if (BaseImportConfig.getGeoIPUtil(this.getGeoipConfig()) != null) {
            return BaseImportConfig.getGeoIPUtil(this.getGeoipConfig()).getIpInfo(ip);
        }
        return null;
    }

    @Override
    public void newName2ndData(String fieldName, String newFieldName, Object newFieldValue) throws Exception {
        this.addFieldValue(newFieldName, newFieldValue);
        if (!fieldName.equals(newFieldName)) {
            this.addIgnoreFieldMapping(fieldName);
        }
    }

    @Override
    public BatchContext getBatchContext() {
        return this.batchContext;
    }

    @Override
    public Object getParentId() throws Exception {
        ESField esField;
        ClientOptions clientOptions = this.getClientOptions();
        ESField eSField = esField = clientOptions != null ? clientOptions.getParentIdField() : null;
        if (esField != null) {
            if (!esField.isMeta()) {
                return this.getValue(esField.getField());
            }
            return this.tranResultSet.getMetaValue(esField.getField());
        }
        return clientOptions != null ? clientOptions.getEsParentIdValue() : null;
    }

    @Override
    public Object getRecord() {
        return this.tranResultSet.getRecord();
    }

    @Override
    public Record getCurrentRecord() {
        return this.tranResultSet.getCurrentRecord();
    }

    @Override
    public void markRecoredInsert() {
        this.status = 0;
    }

    @Override
    public void markRecoredUpdate() {
        this.status = 1;
    }

    @Override
    public void markRecoredDelete() {
        this.status = 2;
    }

    @Override
    public boolean isInsert() {
        return this.status == 0;
    }

    @Override
    public boolean isUpdate() {
        return this.status == 1;
    }

    @Override
    public boolean isDelete() {
        return this.status == 2;
    }

    @Override
    public Object getRouting() throws Exception {
        ClientOptions clientOptions = this.getClientOptions();
        ESField esField = clientOptions != null ? clientOptions.getRoutingField() : null;
        Object routing = null;
        routing = esField != null ? (!esField.isMeta() ? this.getValue(esField.getField()) : this.tranResultSet.getMetaValue(esField.getField())) : (clientOptions != null ? clientOptions.getRouting() : null);
        return routing;
    }

    @Override
    public ESIndexWrapper getESIndexWrapper() {
        if (this.esIndexWrapper == null) {
            return this.elasticsearchOutputConfig != null ? this.elasticsearchOutputConfig.getEsIndexWrapper() : null;
        }
        return this.esIndexWrapper;
    }

    @Override
    public Object getVersion() throws Exception {
        ClientOptions clientOptions = this.getClientOptions();
        ESField esField = clientOptions != null ? clientOptions.getVersionField() : null;
        Object version = null;
        version = esField != null ? (!esField.isMeta() ? this.getValue(esField.getField()) : this.tranResultSet.getMetaValue(esField.getField())) : (clientOptions != null ? clientOptions.getVersion() : null);
        return version;
    }

    @Override
    public boolean isUseBatchContextIndexName() {
        return this.useBatchContextIndexName;
    }

    @Override
    public void setUseBatchContextIndexName(boolean useBatchContextIndexName) {
        this.useBatchContextIndexName = useBatchContextIndexName;
    }

    @Override
    public boolean removed() {
        return this.tranResultSet.removed();
    }

    @Override
    public boolean reachEOFClosed() {
        return this.tranResultSet.reachEOFClosed();
    }

    @Override
    public JobContext getJobContext() {
        if (this.importContext != null) {
            return this.importContext.getJobContext();
        }
        return null;
    }

    @Override
    public void setCommonRecord(CommonRecord commonRecord) {
        this.commonRecord = commonRecord;
    }

    @Override
    public CommonRecord getCommonRecord() {
        return this.commonRecord;
    }
}

