/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.config;

import com.frameworkset.util.SimpleStringUtil;
import java.text.DateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.frameworkset.elasticsearch.serial.SerialUtil;
import org.frameworkset.spi.geoip.GeoIPUtil;
import org.frameworkset.tran.DBConfig;
import org.frameworkset.tran.DataRefactor;
import org.frameworkset.tran.FieldMeta;
import org.frameworkset.tran.ImportEndAction;
import org.frameworkset.tran.ImportStartAction;
import org.frameworkset.tran.WrapedExportResultHandler;
import org.frameworkset.tran.config.DynamicParam;
import org.frameworkset.tran.plugin.metrics.output.ETLMetrics;
import org.frameworkset.tran.record.SplitHandler;
import org.frameworkset.tran.schedule.CallInterceptor;
import org.frameworkset.tran.schedule.ImportIncreamentConfig;
import org.frameworkset.tran.schedule.ScheduleConfig;
import org.frameworkset.util.annotations.DateFormateMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseImportConfig {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<DBConfig> configs;
    private DBConfig defaultDBConfig;
    private Map<String, DBConfig> dbConfigMap = new LinkedHashMap<String, DBConfig>();
    private boolean sortLastValue;
    private List<ETLMetrics> metrics;
    private boolean useDefaultMapData = true;
    private boolean flushMetricsOnScheduleTaskCompleted;
    private boolean cleanKeysWhenflushMetricsOnScheduleTaskCompleted;
    private boolean waitCompleteWhenflushMetricsOnScheduleTaskCompleted;
    private ImportStartAction importStartAction;
    private ImportEndAction importEndAction;
    private Date scheduleDate;
    private Date scheduleEndDate;
    private Long deyLay;
    private String jobName;
    private String jobId;
    private boolean lastValueColumnSetted = false;
    private Map jobInputParams;
    private Map<String, DynamicParam> jobDynamicInputParams;
    private Map<String, DynamicParam> jobDynamicOutputParams;
    private Map jobOutputParams;
    private boolean serialAllData;
    protected long logsendTaskMetric = 10000L;
    private long flushInterval = 8000L;
    private long asynResultPollTimeOut = 3000L;
    private Integer increamentEndOffset;
    private String dataTimeField;
    private boolean asynFlushStatus = true;
    private String splitFieldName;
    private SplitHandler splitHandler;
    private long asynFlushStatusInterval = 10000L;
    private String[] exportColumns;
    private boolean ignoreNullValueField;
    private Integer fetchSize = 5000;
    private int tranDataBufferQueue = 10;
    private DBConfig statusDbConfig;
    private boolean printTaskLog = false;
    private List<CallInterceptor> callInterceptors;
    private WrapedExportResultHandler exportResultHandler;
    private boolean parallel;
    private int threadCount = 200;
    private int queue = Integer.MAX_VALUE;
    private String applicationPropertiesFile;
    private Boolean useJavaName;
    private Boolean useLowcase;
    private String dateFormat;
    private String locale;
    private String timeZone;
    private DateFormat format;
    private Map<String, FieldMeta> fieldMetaMap;
    private List<FieldMeta> fieldValues;
    private Map<String, FieldMeta> valuesIdxByName;
    private DataRefactor dataRefactor;
    private int batchSize;
    private Integer scheduleBatchSize;
    private boolean asyn;
    private boolean continueOnError;
    private ScheduleConfig scheduleConfig;
    private ImportIncreamentConfig importIncreamentConfig;
    private Map<String, Object> geoipConfig;

    public void setImportStartAction(ImportStartAction importStartAction) {
        this.importStartAction = importStartAction;
    }

    public ImportStartAction getImportStartAction() {
        return this.importStartAction;
    }

    public boolean isLastValueColumnSetted() {
        return this.lastValueColumnSetted;
    }

    public void setLastValueColumnSetted(boolean lastValueColumnSetted) {
        this.lastValueColumnSetted = lastValueColumnSetted;
    }

    public boolean isImportIncreamentConfigSetted() {
        return this.importIncreamentConfig != null;
    }

    public Map getJobInputParams() {
        return this.jobInputParams;
    }

    public void setJobInputParams(Map jobInputParams) {
        this.jobInputParams = jobInputParams;
    }

    public Map getJobOutputParams() {
        return this.jobOutputParams;
    }

    public void setJobOutputParams(Map jobOutputParams) {
        this.jobOutputParams = jobOutputParams;
    }

    public boolean isSerialAllData() {
        return this.serialAllData;
    }

    public void setSerialAllData(boolean serialAllData) {
        this.serialAllData = serialAllData;
    }

    public void setJobDynamicInputParams(Map<String, DynamicParam> jobDynamicInputParams) {
        this.jobDynamicInputParams = jobDynamicInputParams;
    }

    public Map<String, DynamicParam> getJobDynamicInputParams() {
        return this.jobDynamicInputParams;
    }

    public Map<String, DynamicParam> getJobDynamicOutputParams() {
        return this.jobDynamicOutputParams;
    }

    public void setJobDynamicOutputParams(Map<String, DynamicParam> jobDynamicOutputParams) {
        this.jobDynamicOutputParams = jobDynamicOutputParams;
    }

    public long getLogsendTaskMetric() {
        return this.logsendTaskMetric;
    }

    public void setLogsendTaskMetric(long logsendTaskMetric) {
        this.logsendTaskMetric = logsendTaskMetric;
    }

    public String[] getExportColumns() {
        return this.exportColumns;
    }

    public long getAsynFlushStatusInterval() {
        return this.asynFlushStatusInterval;
    }

    public void setAsynFlushStatusInterval(long asynFlushStatusInterval) {
        this.asynFlushStatusInterval = asynFlushStatusInterval;
    }

    public void setIncreamentEndOffset(Integer increamentEndOffset) {
        this.increamentEndOffset = increamentEndOffset;
    }

    public Integer getIncreamentEndOffset() {
        return this.increamentEndOffset;
    }

    public void setExportColumns(String[] exportColumns) {
        this.exportColumns = exportColumns;
    }

    public boolean isIgnoreNullValueField() {
        return this.ignoreNullValueField;
    }

    public long getAsynResultPollTimeOut() {
        return this.asynResultPollTimeOut;
    }

    public void setAsynResultPollTimeOut(long asynResultPollTimeOut) {
        this.asynResultPollTimeOut = asynResultPollTimeOut;
    }

    public void setIgnoreNullValueField(boolean ignoreNullValueField) {
        this.ignoreNullValueField = ignoreNullValueField;
    }

    public Integer getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(Integer fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setTranDataBufferQueue(int tranDataBufferQueue) {
        this.tranDataBufferQueue = tranDataBufferQueue;
    }

    public String getApplicationPropertiesFile() {
        return this.applicationPropertiesFile;
    }

    public void setApplicationPropertiesFile(String applicationPropertiesFile) {
        this.applicationPropertiesFile = applicationPropertiesFile;
    }

    public Boolean getUseLowcase() {
        return this.useLowcase;
    }

    public void setUseLowcase(Boolean useLowcase) {
        this.useLowcase = useLowcase;
    }

    public Map<String, FieldMeta> getValuesIdxByName() {
        return this.valuesIdxByName;
    }

    public FieldMeta getValueIdxByName(String fieldName) {
        return this.valuesIdxByName != null ? this.valuesIdxByName.get(fieldName) : null;
    }

    public void setValuesIdxByName(Map<String, FieldMeta> valuesIdxByName) {
        this.valuesIdxByName = valuesIdxByName;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public Boolean getUseJavaName() {
        return this.useJavaName;
    }

    public void setUseJavaName(Boolean useJavaName) {
        this.useJavaName = useJavaName;
    }

    public DateFormateMeta getDateFormateMeta() {
        return DateFormateMeta.buildDateFormateMeta((String)this.dateFormat, (String)this.locale, (String)this.timeZone);
    }

    public DateFormat getFormat() {
        if (this.format == null) {
            DateFormateMeta dateFormateMeta = this.getDateFormateMeta();
            if (dateFormateMeta == null) {
                dateFormateMeta = SerialUtil.getDateFormateMeta();
            }
            this.format = dateFormateMeta.toDateFormat();
        }
        return this.format;
    }

    public void setFormat(DateFormat format) {
        this.format = format;
    }

    public Map<String, FieldMeta> getFieldMetaMap() {
        return this.fieldMetaMap;
    }

    public void destroy() {
        this.format = null;
    }

    public void setFieldMetaMap(Map<String, FieldMeta> fieldMetaMap) {
        this.fieldMetaMap = fieldMetaMap;
    }

    public FieldMeta getMappingName(String sourceFieldName) {
        if (this.fieldMetaMap != null) {
            return this.fieldMetaMap.get(sourceFieldName);
        }
        return null;
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public int getQueue() {
        return this.queue;
    }

    public void setQueue(int queue) {
        this.queue = queue;
    }

    public boolean isAsyn() {
        return this.asyn;
    }

    public void setAsyn(boolean asyn) {
        this.asyn = asyn;
    }

    public List<FieldMeta> getFieldValues() {
        return this.fieldValues;
    }

    public void setFieldValues(List<FieldMeta> fieldValues) {
        this.fieldValues = fieldValues;
    }

    public DataRefactor getDataRefactor() {
        return this.dataRefactor;
    }

    public void setDataRefactor(DataRefactor dataRefactor) {
        this.dataRefactor = dataRefactor;
    }

    public ScheduleConfig getScheduleConfig() {
        return this.scheduleConfig;
    }

    public void setScheduleConfig(ScheduleConfig scheduleConfig) {
        this.scheduleConfig = scheduleConfig;
    }

    public ImportIncreamentConfig getImportIncreamentConfig() {
        return this.importIncreamentConfig;
    }

    public void setStatusTableId(String statusTableId) {
        if (this.importIncreamentConfig != null) {
            this.importIncreamentConfig.setStatusTableId(statusTableId);
        }
    }

    public Integer getScheduleBatchSize() {
        return this.scheduleBatchSize;
    }

    public void setScheduleBatchSize(Integer scheduleBatchSize) {
        this.scheduleBatchSize = scheduleBatchSize;
    }

    public boolean isFromFirst() {
        return this.importIncreamentConfig != null && this.importIncreamentConfig.isFromFirst();
    }

    public String getLastValueStoreTableName() {
        return this.importIncreamentConfig != null ? this.importIncreamentConfig.getLastValueStoreTableName() : null;
    }

    public String getLastValueStorePath() {
        return this.importIncreamentConfig != null ? this.importIncreamentConfig.getLastValueStorePath() : null;
    }

    public String getLastValueColumn() {
        return this.importIncreamentConfig != null ? this.importIncreamentConfig.getLastValueColumn() : null;
    }

    public Integer getLastValueType() {
        return this.importIncreamentConfig != null ? this.importIncreamentConfig.getLastValueType() : null;
    }

    public Object getConfigLastValue() {
        return this.importIncreamentConfig != null ? this.importIncreamentConfig.getLastValue() : null;
    }

    public String getStatusTableId() {
        return this.importIncreamentConfig != null ? this.importIncreamentConfig.getStatusTableId() : null;
    }

    public void stop() {
    }

    public List<CallInterceptor> getCallInterceptors() {
        return this.callInterceptors;
    }

    public void setCallInterceptors(List<CallInterceptor> callInterceptors) {
        this.callInterceptors = callInterceptors;
    }

    public boolean isPrintTaskLog() {
        return this.printTaskLog;
    }

    public void setPrintTaskLog(boolean printTaskLog) {
        this.printTaskLog = printTaskLog;
    }

    public WrapedExportResultHandler getExportResultHandler() {
        return this.exportResultHandler;
    }

    public void setExportResultHandler(WrapedExportResultHandler exportResultHandler) {
        this.exportResultHandler = exportResultHandler;
    }

    public int getMaxRetry() {
        if (this.exportResultHandler != null) {
            return this.exportResultHandler.getMaxRetry();
        }
        return -1;
    }

    public DBConfig getStatusDbConfig() {
        return this.statusDbConfig;
    }

    public void setStatusDbConfig(DBConfig statusDbConfig) {
        this.statusDbConfig = statusDbConfig;
        if (statusDbConfig != null && SimpleStringUtil.isNotEmpty((String)statusDbConfig.getDbName())) {
            this.dbConfigMap.put(statusDbConfig.getDbName(), statusDbConfig);
        }
    }

    public static GeoIPUtil getGeoIPUtil(Map<String, Object> geoipConfig) {
        return GeoIPUtil.getGeoIPUtil(geoipConfig);
    }

    public void setExternalTimer(boolean externalTimer) {
        if (this.scheduleConfig == null) {
            this.scheduleConfig = new ScheduleConfig();
        }
        this.scheduleConfig.setExternalTimer(externalTimer);
    }

    public List<DBConfig> getConfigs() {
        return this.configs;
    }

    public void setConfigs(List<DBConfig> configs) {
        this.configs = configs;
        for (int i = 0; configs != null && i < configs.size(); ++i) {
            DBConfig dbConfig = configs.get(i);
            if (!SimpleStringUtil.isNotEmpty((String)dbConfig.getDbName())) continue;
            this.dbConfigMap.put(dbConfig.getDbName(), dbConfig);
        }
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public boolean isContinueOnError() {
        return this.continueOnError;
    }

    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    public void setImportIncreamentConfig(ImportIncreamentConfig importIncreamentConfig) {
        this.importIncreamentConfig = importIncreamentConfig;
    }

    public boolean isExternalTimer() {
        if (this.scheduleConfig != null) {
            return this.scheduleConfig.isExternalTimer();
        }
        return false;
    }

    public void setLastValueType(int lastValueType) {
        this.importIncreamentConfig.setLastValueType(lastValueType);
    }

    public void setLastValueDateformat(String lastValueDateformat) {
        this.importIncreamentConfig.setLastValueDateformat(lastValueDateformat);
    }

    public String getLastValueDateformat() {
        return this.importIncreamentConfig.getLastValueDateformat();
    }

    public boolean isLastValueDateType() {
        return this.getLastValueType() != null && this.getLastValueType() == 1;
    }

    public boolean isSortLastValue() {
        return this.sortLastValue;
    }

    public long getFlushInterval() {
        return this.flushInterval;
    }

    public void setSortLastValue(boolean sortLastValue) {
        this.sortLastValue = sortLastValue;
    }

    public void setFlushInterval(long flushInterval) {
        this.flushInterval = flushInterval;
    }

    public int getTranDataBufferQueue() {
        return this.tranDataBufferQueue;
    }

    public Map<String, Object> getGeoipConfig() {
        return this.geoipConfig;
    }

    public void setGeoipConfig(Map<String, Object> geoipConfig) {
        this.geoipConfig = geoipConfig;
    }

    public boolean isAsynFlushStatus() {
        return this.asynFlushStatus;
    }

    public void setAsynFlushStatus(boolean asynFlushStatus) {
        this.asynFlushStatus = asynFlushStatus;
    }

    public String getSplitFieldName() {
        return this.splitFieldName;
    }

    public void setSplitFieldName(String splitFieldName) {
        this.splitFieldName = splitFieldName;
    }

    public SplitHandler getSplitHandler() {
        return this.splitHandler;
    }

    public void setSplitHandler(SplitHandler splitHandler) {
        this.splitHandler = splitHandler;
    }

    public DBConfig getDefaultDBConfig() {
        return this.defaultDBConfig;
    }

    public void setDefaultDBConfig(DBConfig defaultDBConfig) {
        this.defaultDBConfig = defaultDBConfig;
    }

    public Long getDeyLay() {
        return this.deyLay;
    }

    public void setDeyLay(Long deyLay) {
        this.deyLay = deyLay;
    }

    public Date getScheduleEndDate() {
        return this.scheduleEndDate;
    }

    public void setScheduleEndDate(Date scheduleEndDate) {
        this.scheduleEndDate = scheduleEndDate;
    }

    public Date getScheduleDate() {
        return this.scheduleDate;
    }

    public void setScheduleDate(Date scheduleDate) {
        this.scheduleDate = scheduleDate;
    }

    public ImportEndAction getImportEndAction() {
        return this.importEndAction;
    }

    public void setImportEndAction(ImportEndAction importEndAction) {
        this.importEndAction = importEndAction;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public List<ETLMetrics> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<ETLMetrics> metrics) {
        this.metrics = metrics;
    }

    public String getDataTimeField() {
        return this.dataTimeField;
    }

    public void setDataTimeField(String dataTimeField) {
        this.dataTimeField = dataTimeField;
    }

    public boolean isUseDefaultMapData() {
        return this.useDefaultMapData;
    }

    public void setUseDefaultMapData(boolean useDefaultMapData) {
        this.useDefaultMapData = useDefaultMapData;
    }

    public boolean isFlushMetricsOnScheduleTaskCompleted() {
        return this.flushMetricsOnScheduleTaskCompleted;
    }

    public void setFlushMetricsOnScheduleTaskCompleted(boolean flushMetricsOnScheduleTaskCompleted) {
        this.flushMetricsOnScheduleTaskCompleted = flushMetricsOnScheduleTaskCompleted;
    }

    public boolean isCleanKeysWhenflushMetricsOnScheduleTaskCompleted() {
        return this.cleanKeysWhenflushMetricsOnScheduleTaskCompleted;
    }

    public void setCleanKeysWhenflushMetricsOnScheduleTaskCompleted(boolean cleanKeysWhenflushMetricsOnScheduleTaskCompleted) {
        this.cleanKeysWhenflushMetricsOnScheduleTaskCompleted = cleanKeysWhenflushMetricsOnScheduleTaskCompleted;
    }

    public boolean isWaitCompleteWhenflushMetricsOnScheduleTaskCompleted() {
        return this.waitCompleteWhenflushMetricsOnScheduleTaskCompleted;
    }

    public void setWaitCompleteWhenflushMetricsOnScheduleTaskCompleted(boolean waitCompleteWhenflushMetricsOnScheduleTaskCompleted) {
        this.waitCompleteWhenflushMetricsOnScheduleTaskCompleted = waitCompleteWhenflushMetricsOnScheduleTaskCompleted;
    }
}

