/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran;

import org.frameworkset.tran.ExportResultHandler;
import org.frameworkset.tran.WrapedExportResultHandler;
import org.frameworkset.tran.task.TaskCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseExportResultHandler<DATA, RESULT>
implements WrapedExportResultHandler<DATA, RESULT> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private ExportResultHandler exportResultHandler;

    public BaseExportResultHandler(ExportResultHandler exportResultHandler) {
        this.exportResultHandler = exportResultHandler;
    }

    @Override
    public void success(TaskCommand<DATA, RESULT> taskCommand, RESULT result) {
        this.exportResultHandler.success(taskCommand, result);
    }

    @Override
    public void error(TaskCommand<DATA, RESULT> taskCommand, RESULT result) {
        if (taskCommand.getTaskContext() != null) {
            taskCommand.getTaskContext().increamentErrorTasks();
        }
        this.exportResultHandler.error(taskCommand, result);
    }

    @Override
    public void exception(TaskCommand<DATA, RESULT> taskCommand, Throwable exception) {
        if (taskCommand.getTaskContext() != null) {
            taskCommand.getTaskContext().increamentExceptionTasks();
        }
        this.exportResultHandler.exception(taskCommand, exception);
    }

    @Override
    public int getMaxRetry() {
        return this.exportResultHandler.getMaxRetry();
    }

    @Override
    public void handleResult(TaskCommand<DATA, RESULT> taskCommand, RESULT result) {
        this.success(taskCommand, result);
    }

    @Override
    public void handleException(TaskCommand<DATA, RESULT> taskCommand, Throwable exception) {
        try {
            this.exception(taskCommand, exception);
        }
        catch (Exception e) {
            this.logger.warn("Handle Task Exception failed:", (Throwable)e);
        }
    }

    @Override
    public void destroy() {
    }
}

