/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.util;

import bboss.org.apache.velocity.VelocityContext;
import bboss.org.apache.velocity.context.Context;
import com.frameworkset.common.poolman.ConfigSQLExecutor;
import com.frameworkset.util.SimpleStringUtil;
import com.frameworkset.util.VariableHandler;
import java.io.Writer;
import java.security.AccessController;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.frameworkset.elasticsearch.serial.SerialUtil;
import org.frameworkset.persitent.util.GloableSQLUtil;
import org.frameworkset.persitent.util.SQLInfo;
import org.frameworkset.soa.BBossStringWriter;
import org.frameworkset.tran.DBConfig;
import org.frameworkset.tran.ESDataImportException;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.db.output.DBOutPutContext;
import org.frameworkset.tran.db.output.TranSQLInfo;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.util.annotations.DateFormateMeta;
import sun.security.action.GetPropertyAction;

public abstract class TranUtil {
    public static final String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));

    private static TranSQLInfo buildTranSQLInfo(String sqlName, boolean issql, String sqlFilepath, String dbname) {
        TranSQLInfo sqlInfo = new TranSQLInfo();
        SQLInfo sqlinfo = null;
        ConfigSQLExecutor configSQLExecutor = null;
        try {
            if (issql) {
                if (sqlName != null) {
                    sqlinfo = GloableSQLUtil.getGlobalSQLUtil().getSQLInfo(sqlName);
                }
            } else {
                configSQLExecutor = new ConfigSQLExecutor(sqlFilepath);
                sqlinfo = configSQLExecutor.getSqlInfo(dbname, sqlName);
            }
            if (sqlinfo == null) {
                return null;
            }
            sqlInfo.setOriginSQL(sqlinfo.getSql());
            String sql = TranUtil.parserSQL(sqlinfo);
            VariableHandler.SQLStruction sqlstruction = sqlinfo.getSqlutil().getSQLStruction(sqlinfo, sql);
            sql = sqlstruction.getSql();
            sqlInfo.setSql(sql);
            List vars = sqlstruction.getVariables();
            sqlInfo.setVars(vars);
            return sqlInfo;
        }
        catch (SQLException e) {
            throw new ESDataImportException("Init TargetSQLInfo failed", e);
        }
    }

    public static void initTargetSQLInfo(DBOutPutContext dbContext, String db) throws ESDataImportException {
        TranSQLInfo sqlInfo = null;
        Object sqlinfo = null;
        String sqlName = dbContext.getInsertSqlName();
        if (sqlName == null) {
            sqlName = dbContext.getInsertSql();
            sqlInfo = TranUtil.buildTranSQLInfo(sqlName, true, dbContext.getSqlFilepath(), db);
        } else {
            sqlInfo = TranUtil.buildTranSQLInfo(sqlName, false, dbContext.getSqlFilepath(), db);
        }
        if (sqlInfo != null) {
            dbContext.setTargetSqlInfo(sqlInfo);
            sqlInfo = null;
        }
        if ((sqlName = dbContext.getUpdateSqlName()) == null) {
            sqlName = dbContext.getUpdateSql();
            sqlInfo = TranUtil.buildTranSQLInfo(sqlName, true, dbContext.getSqlFilepath(), db);
        } else {
            sqlInfo = TranUtil.buildTranSQLInfo(sqlName, false, dbContext.getSqlFilepath(), db);
        }
        if (sqlInfo != null) {
            dbContext.setTargetUpdateSqlInfo(sqlInfo);
            sqlInfo = null;
        }
        if ((sqlName = dbContext.getDeleteSqlName()) == null) {
            sqlName = dbContext.getDeleteSql();
            sqlInfo = TranUtil.buildTranSQLInfo(sqlName, true, dbContext.getSqlFilepath(), db);
        } else {
            sqlInfo = TranUtil.buildTranSQLInfo(sqlName, false, dbContext.getSqlFilepath(), db);
        }
        if (sqlInfo != null) {
            dbContext.setTargetDeleteSqlInfo(sqlInfo);
            sqlInfo = null;
        }
    }

    public static void initTaskContextSQLInfo(TaskContext taskContext, ImportContext importContext, ImportContext targetImportContext) {
        if (taskContext != null && taskContext.getDbmportConfig() != null) {
            DBConfig dbConfig;
            String dbName = null;
            if (taskContext.getTargetDBConfig() != null && (dbConfig = taskContext.getTargetDBConfig()) != null && SimpleStringUtil.isNotEmpty((String)dbConfig.getDbName())) {
                dbName = dbConfig.getDbName();
            }
            if (dbName == null && targetImportContext != null && targetImportContext instanceof DBOutPutContext) {
                dbName = ((DBOutPutContext)((Object)targetImportContext)).getTargetDBName(taskContext);
            }
            if (dbName == null) {
                dbName = importContext.getTargetDBName();
            }
            if (dbName != null) {
                TranUtil.initTargetSQLInfo(taskContext, dbName);
            }
        }
    }

    public static void initTargetSQLInfo(TaskContext dbContext, String db) throws ESDataImportException {
        if (dbContext == null) {
            return;
        }
        ImportContext targetImportContext = dbContext.getTargetImportContext();
        if (!(targetImportContext instanceof DBOutPutContext)) {
            return;
        }
        TranSQLInfo sqlInfo = null;
        Object sqlinfo = null;
        String sqlName = dbContext.getInsertSqlName();
        String sqlFilePath = dbContext.getSqlFilepath();
        if (sqlFilePath == null) {
            sqlFilePath = ((DBOutPutContext)((Object)targetImportContext)).getSqlFilepath();
        }
        if (sqlName == null) {
            sqlName = dbContext.getInsertSql();
            if (sqlName != null) {
                sqlInfo = TranUtil.buildTranSQLInfo(sqlName, true, sqlFilePath, db);
            }
        } else {
            sqlInfo = TranUtil.buildTranSQLInfo(sqlName, false, sqlFilePath, db);
        }
        if (sqlInfo != null) {
            dbContext.setTargetSqlInfo(sqlInfo);
            sqlInfo = null;
        }
        if ((sqlName = dbContext.getUpdateSqlName()) == null) {
            sqlName = dbContext.getUpdateSql();
            if (sqlName != null) {
                sqlInfo = TranUtil.buildTranSQLInfo(sqlName, true, sqlFilePath, db);
            }
        } else {
            sqlInfo = TranUtil.buildTranSQLInfo(sqlName, false, sqlFilePath, db);
        }
        if (sqlInfo != null) {
            dbContext.setTargetUpdateSqlInfo(sqlInfo);
            sqlInfo = null;
        }
        if ((sqlName = dbContext.getDeleteSqlName()) == null) {
            sqlName = dbContext.getDeleteSql();
            if (sqlName != null) {
                sqlInfo = TranUtil.buildTranSQLInfo(sqlName, true, sqlFilePath, db);
            }
        } else {
            sqlInfo = TranUtil.buildTranSQLInfo(sqlName, false, sqlFilePath, db);
        }
        if (sqlInfo != null) {
            dbContext.setTargetDeleteSqlInfo(sqlInfo);
            sqlInfo = null;
        }
    }

    private static VelocityContext buildVelocityContext() {
        VelocityContext context_ = new VelocityContext();
        return context_;
    }

    public static String parserSQL(SQLInfo sqlinfo) {
        String sql = null;
        if (sqlinfo.istpl()) {
            sqlinfo.getSqltpl().process();
            if (sqlinfo.istpl()) {
                VelocityContext vcontext = TranUtil.buildVelocityContext();
                BBossStringWriter sw = new BBossStringWriter();
                sqlinfo.getSqltpl().merge((Context)vcontext, (Writer)sw);
                sql = sw.toString();
            } else {
                sql = sqlinfo.getSql();
            }
        } else {
            sql = sqlinfo.getSql();
        }
        return sql;
    }

    public static Date getDateTimeValue(String colName, Object value, ImportContext importContext) throws ESDataImportException {
        return TranUtil.getDateTimeValue(colName, value, importContext, null);
    }

    public static Date getDateTimeValue(String colName, Object value, ImportContext importContext, String dateformat) throws ESDataImportException {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Long) {
            return new Date((Long)value);
        }
        if (value instanceof String) {
            DateFormateMeta dateFormateMeta;
            DateFormat dateFormat = null;
            if (dateformat != null && !dateformat.equals("")) {
                dateFormateMeta = DateFormateMeta.buildDateFormateMeta((String)dateformat);
                dateFormat = dateFormateMeta.toDateFormat();
            } else if (importContext.getDateFormat() != null) {
                dateFormateMeta = DateFormateMeta.buildDateFormateMeta((String)importContext.getDateFormat(), (String)importContext.getLocale(), (String)importContext.getTimeZone());
                dateFormat = dateFormateMeta.toDateFormat();
            } else {
                dateFormat = SerialUtil.getDateFormateMeta().toDateFormat();
            }
            try {
                return dateFormat.parse((String)value);
            }
            catch (ParseException e) {
                throw new ESDataImportException("Illegment colName[" + colName + "] date value:" + (String)value, e);
            }
        }
        throw new ESDataImportException("Illegment colName[" + colName + "] date value:" + (String)value);
    }
}

