/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.status;

import org.frameworkset.tran.status.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusFlushThread
extends Thread {
    private StatusManager statusManager;
    private long flushInterval = 10000L;
    private static Logger logger = LoggerFactory.getLogger(StatusFlushThread.class);

    public StatusFlushThread(StatusManager statusManager, long flushInterval) {
        super("StatusFlushThread");
        this.setDaemon(true);
        this.statusManager = statusManager;
        this.flushInterval = flushInterval;
    }

    @Override
    public void run() {
        try {
            do {
                StatusFlushThread.sleep(this.flushInterval);
                try {
                    this.statusManager.flushStatus();
                }
                catch (Exception e) {
                    logger.warn("StatusManager flush Status failed:", (Throwable)e);
                }
            } while (!this.statusManager.isStoped());
        }
        catch (InterruptedException e) {
            try {
                this.statusManager.flushStatus();
            }
            catch (Exception e1) {
                logger.warn("StatusManager flush Status failed:", (Throwable)e1);
            }
        }
    }
}

