/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.status;

import java.util.Date;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.frameworkset.spi.BaseApplicationContext;
import org.frameworkset.tran.DataTranPlugin;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.status.StatusFlushThread;
import org.frameworkset.tran.status.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseStatusManager
implements StatusManager {
    private static Logger logger = LoggerFactory.getLogger(BaseStatusManager.class);
    protected String statusDbname;
    protected String updateSQL;
    protected int lastValueType;
    private StatusFlushThread flushThread;
    private DataTranPlugin dataTranPlugin;
    private boolean stoped;
    private ReadWriteLock putStatusLock = new ReentrantReadWriteLock();
    private Lock read = this.putStatusLock.readLock();
    private Lock write = this.putStatusLock.writeLock();

    public BaseStatusManager(String statusDbname, String updateSQL, int lastValueType, DataTranPlugin dataTranPlugin) {
        this.statusDbname = statusDbname;
        this.updateSQL = updateSQL;
        this.lastValueType = lastValueType;
        this.dataTranPlugin = dataTranPlugin;
    }

    public DataTranPlugin getDataTranPlugin() {
        return this.dataTranPlugin;
    }

    @Override
    public void init() {
        this.flushThread = new StatusFlushThread(this, this.dataTranPlugin.getImportContext().getAsynFlushStatusInterval());
        this.flushThread.start();
        BaseApplicationContext.addShutdownHook((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (BaseStatusManager.this.isStoped()) {
                    return;
                }
                BaseStatusManager baseStatusManager = BaseStatusManager.this;
                synchronized (baseStatusManager) {
                    if (BaseStatusManager.this.isStoped()) {
                        return;
                    }
                    BaseStatusManager.this.flushStatus();
                }
            }
        });
    }

    protected abstract void _putStatus(Status var1);

    @Override
    public void putStatus(Status currentStatus) throws Exception {
        try {
            this.read.lock();
            this._putStatus(currentStatus);
        }
        finally {
            this.read.unlock();
        }
    }

    protected abstract void _flushStatus() throws Exception;

    @Override
    public void flushStatus() {
        try {
            this.write.lock();
            this._flushStatus();
        }
        catch (Exception throwables) {
            logger.error("flushStatus failed:statusDbname[" + this.statusDbname + "],updateSQL[" + this.updateSQL + "]", (Throwable)throwables);
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public synchronized void stop() {
        this.stoped = true;
        this.flushThread.interrupt();
    }

    @Override
    public synchronized boolean isStoped() {
        return this.stoped;
    }

    protected Object convertLastValue(Object lastValue) {
        if (lastValue == null) {
            return null;
        }
        if (lastValue instanceof Date) {
            lastValue = new Long(((Date)lastValue).getTime());
        }
        return lastValue;
    }
}

