/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.schedule.timer;

import org.frameworkset.tran.schedule.ScheduleService;
import org.frameworkset.tran.schedule.timer.TimeUtil;
import org.frameworkset.tran.schedule.timer.TimerScheduleConfig;

public class ScheduleTimer
implements Runnable {
    private TimerScheduleConfig timerScheduleConfig;
    private ScheduleService scheduleService;
    private Thread thread = null;
    protected volatile boolean running = false;

    public ScheduleTimer(TimerScheduleConfig timerScheduleConfig, ScheduleService scheduleService) {
        this.timerScheduleConfig = timerScheduleConfig;
        this.scheduleService = scheduleService;
    }

    public synchronized void start() throws IllegalStateException {
        if (this.running) {
            throw new IllegalStateException("BBossScheduleTimer is already running");
        }
        this.running = true;
        this.thread = new Thread((Runnable)this, "BBossScheduleTimer");
        this.thread.setDaemon(false);
        this.thread.start();
    }

    public synchronized void stop() throws Exception {
        this.stop(this.timerScheduleConfig.getPeriod());
    }

    public synchronized void stop(long stopInterval) throws Exception {
        if (!this.running) {
            throw new IllegalStateException("Monitor is not running");
        }
        this.running = false;
        try {
            this.thread.interrupt();
            this.thread.join(stopInterval);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void run() {
        Long deyLay;
        Long interval = this.timerScheduleConfig.getPeriod();
        if (interval == null) {
            interval = 100000L;
        }
        if ((deyLay = this.timerScheduleConfig.getDeyLay()) != null) {
            try {
                Thread.sleep(deyLay);
            }
            catch (InterruptedException ignored) {
                return;
            }
        }
        while (this.running) {
            while (true) {
                if (TimeUtil.evalateNeedScan(this.timerScheduleConfig)) {
                    this.scheduleService.externalTimeSchedule();
                    break;
                }
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                    break;
                }
            }
            if (!this.running) break;
            try {
                Thread.sleep(interval);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

