/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.ouput.custom;

import com.frameworkset.orm.annotation.BatchContext;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.tran.BaseCommonRecordDataTran;
import org.frameworkset.tran.CommonRecord;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.ESDataImportException;
import org.frameworkset.tran.TranErrorWrapper;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.context.Context;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.metrics.ImportCount;
import org.frameworkset.tran.metrics.ParallImportCount;
import org.frameworkset.tran.metrics.SerialImportCount;
import org.frameworkset.tran.ouput.custom.CustomTaskCommandImpl;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.task.TaskCall;
import org.slf4j.Logger;

public class CustomOutPutDataTran
extends BaseCommonRecordDataTran {
    protected CountDownLatch countDownLatch;
    protected String taskInfo;

    @Override
    public void logTaskStart(Logger logger) {
        logger.info(this.taskInfo + " start.");
    }

    @Override
    public void stop() {
        if (this.esTranResultSet != null) {
            this.esTranResultSet.stop();
            this.esTranResultSet = null;
        }
        super.stop();
    }

    @Override
    public void stopTranOnly() {
        if (this.esTranResultSet != null) {
            this.esTranResultSet.stopTranOnly();
            this.esTranResultSet = null;
        }
        super.stopTranOnly();
    }

    @Override
    public String tran() throws ESDataImportException {
        try {
            String ret;
            String string = ret = super.tran();
            return string;
        }
        finally {
            if (this.countDownLatch != null) {
                this.countDownLatch.countDown();
            }
        }
    }

    @Override
    public void init() {
        super.init();
        this.taskInfo = "Import data to custom output.";
    }

    public CustomOutPutDataTran(TaskContext taskContext, TranResultSet jdbcResultSet, ImportContext importContext, ImportContext targetImportContext, Status currentStatus) {
        super(taskContext, jdbcResultSet, importContext, targetImportContext, currentStatus);
    }

    public CustomOutPutDataTran(TaskContext taskContext, TranResultSet jdbcResultSet, ImportContext importContext, ImportContext targetImportContext, CountDownLatch countDownLatch, Status currentStatus) {
        super(taskContext, jdbcResultSet, importContext, targetImportContext, currentStatus);
        this.countDownLatch = countDownLatch;
    }

    @Override
    public String serialExecute() {
        this.logger.info("serial import data Execute started.");
        ArrayList<CommonRecord> datas = new ArrayList<CommonRecord>();
        Object lastValue = null;
        Exception exception = null;
        long start = System.currentTimeMillis();
        Status currentStatus = this.currentStatus;
        Object currentValue = currentStatus != null ? currentStatus.getLastValue() : null;
        SerialImportCount importCount = new SerialImportCount();
        int taskNo = 0;
        long totalCount = 0L;
        int count = 0;
        long ignoreTotalCount = 0L;
        boolean reachEOFClosed = false;
        try {
            Object temp = null;
            while (true) {
                Boolean hasNext;
                if ((hasNext = this.jdbcResultSet.next()) == null) {
                    String ret = null;
                    if (count > 0) {
                        int _count = count;
                        count = 0;
                        CustomTaskCommandImpl taskCommand = new CustomTaskCommandImpl(importCount, this.importContext, this.targetImportContext, _count, taskNo, importCount.getJobNo(), lastValue, currentStatus, reachEOFClosed, this.taskContext);
                        taskCommand.setDatas((List<CommonRecord>)datas);
                        datas = new ArrayList();
                        ret = TaskCall.call(taskCommand);
                        ++taskNo;
                    } else {
                        ret = "{\"took\":0,\"errors\":false}";
                    }
                    if (!this.isPrintTaskLog()) continue;
                    long end = System.currentTimeMillis();
                    this.logger.info("Force flush datas Take time:" + (end - start) + "ms" + ",Import total " + totalCount + " records,IgnoreTotalCount " + ignoreTotalCount + " records.");
                    continue;
                }
                if (!hasNext.booleanValue()) break;
                try {
                    lastValue = lastValue == null ? this.importContext.max(currentValue, this.getLastValue()) : this.importContext.max(lastValue, this.getLastValue());
                    Context context = this.importContext.buildContext(this.taskContext, this.jdbcResultSet, null);
                    if (!reachEOFClosed) {
                        reachEOFClosed = context.reachEOFClosed();
                    }
                    if (context.removed()) {
                        if (!reachEOFClosed) {
                            ((ImportCount)importCount).increamentIgnoreTotalCount();
                            continue;
                        }
                        this.importContext.flushLastValue(lastValue, currentStatus, reachEOFClosed);
                        continue;
                    }
                    context.refactorData();
                    context.afterRefactor();
                    if (context.isDrop()) {
                        ((ImportCount)importCount).increamentIgnoreTotalCount();
                        continue;
                    }
                    CommonRecord record = this.buildRecord(context);
                    datas.add(record);
                    ++totalCount;
                    ++count;
                }
                catch (Exception e) {
                    throw new DataImportException(e);
                }
            }
            if (count > 0) {
                CustomTaskCommandImpl taskCommand = new CustomTaskCommandImpl(importCount, this.importContext, this.targetImportContext, count, taskNo, importCount.getJobNo(), lastValue, currentStatus, reachEOFClosed, this.taskContext);
                ++taskNo;
                taskCommand.setDatas((List<CommonRecord>)datas);
                TaskCall.call(taskCommand);
            }
            if (this.isPrintTaskLog()) {
                long end = System.currentTimeMillis();
                this.logger.info("Serial import Take time:" + (end - start) + "ms" + ",Import total " + totalCount + " records,IgnoreTotalCount " + ((ImportCount)importCount).getIgnoreTotalCount() + " records.");
            }
        }
        catch (DataImportException e) {
            exception = e;
            throw e;
        }
        catch (Exception e) {
            exception = e;
            throw new DataImportException(e);
        }
        finally {
            if (!TranErrorWrapper.assertCondition(exception, this.importContext)) {
                if (!this.importContext.getDataTranPlugin().isMultiTran()) {
                    this.stop();
                } else {
                    this.stopTranOnly();
                }
            }
            if (this.importContext.isCurrentStoped()) {
                this.stopTranOnly();
            }
            importCount.setJobEndTime(new Date());
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String parallelBatchExecute() {
        boolean reachEOFClosed;
        TranErrorWrapper tranErrorWrapper;
        Object lastValue;
        Throwable exception;
        ParallImportCount totalCount;
        ArrayList<Future> tasks;
        ExecutorService service;
        String ret;
        block19: {
            int count = 0;
            ArrayList<CommonRecord> datas = new ArrayList<CommonRecord>();
            ret = null;
            service = this.importContext.buildThreadPool();
            tasks = new ArrayList<Future>();
            int taskNo = 0;
            totalCount = new ParallImportCount();
            exception = null;
            Status currentStatus = this.currentStatus;
            Object currentValue = currentStatus != null ? currentStatus.getLastValue() : null;
            lastValue = null;
            tranErrorWrapper = new TranErrorWrapper(this.importContext);
            int batchsize = this.importContext.getStoreBatchSize();
            reachEOFClosed = false;
            try {
                block18: {
                    BatchContext batchContext = new BatchContext();
                    while (true) {
                        Boolean hasNext;
                        if (!tranErrorWrapper.assertCondition()) {
                            this.jdbcResultSet.stop();
                            tranErrorWrapper.throwError();
                        }
                        if ((hasNext = this.jdbcResultSet.next()) == null) {
                            if (count <= 0) continue;
                            int _count = count;
                            count = 0;
                            CustomTaskCommandImpl taskCommand = new CustomTaskCommandImpl(totalCount, this.importContext, this.targetImportContext, _count, taskNo, totalCount.getJobNo(), lastValue, currentStatus, reachEOFClosed, this.taskContext);
                            taskCommand.setDatas((List<CommonRecord>)datas);
                            datas = new ArrayList();
                            tasks.add(service.submit(new TaskCall(taskCommand, tranErrorWrapper)));
                            ++taskNo;
                            continue;
                        }
                        if (!hasNext.booleanValue()) {
                            if (count > 0) {
                                break;
                            }
                            break block18;
                        }
                        lastValue = lastValue == null ? this.importContext.max(currentValue, this.getLastValue()) : this.importContext.max(lastValue, this.getLastValue());
                        Context context = this.importContext.buildContext(this.taskContext, this.jdbcResultSet, batchContext);
                        if (!reachEOFClosed) {
                            reachEOFClosed = context.reachEOFClosed();
                        }
                        if (context.removed()) {
                            if (!reachEOFClosed) {
                                ((ImportCount)totalCount).increamentIgnoreTotalCount();
                                continue;
                            }
                            this.importContext.flushLastValue(lastValue, currentStatus, reachEOFClosed);
                            continue;
                        }
                        context.refactorData();
                        context.afterRefactor();
                        if (context.isDrop()) {
                            ((ImportCount)totalCount).increamentIgnoreTotalCount();
                            continue;
                        }
                        CommonRecord record = this.buildRecord(context);
                        datas.add(record);
                        if (++count < batchsize) continue;
                        int _count = count;
                        count = 0;
                        CustomTaskCommandImpl taskCommand = new CustomTaskCommandImpl(totalCount, this.importContext, this.targetImportContext, _count, taskNo, totalCount.getJobNo(), lastValue, currentStatus, reachEOFClosed, this.taskContext);
                        taskCommand.setDatas((List<CommonRecord>)datas);
                        datas = new ArrayList();
                        tasks.add(service.submit(new TaskCall(taskCommand, tranErrorWrapper)));
                        ++taskNo;
                    }
                    if (!tranErrorWrapper.assertCondition()) {
                        tranErrorWrapper.throwError();
                    }
                    CustomTaskCommandImpl taskCommand = new CustomTaskCommandImpl(totalCount, this.importContext, this.targetImportContext, count, taskNo, totalCount.getJobNo(), lastValue, currentStatus, reachEOFClosed, this.taskContext);
                    taskCommand.setDatas((List<CommonRecord>)datas);
                    datas = null;
                    tasks.add(service.submit(new TaskCall(taskCommand, tranErrorWrapper)));
                    if (this.isPrintTaskLog()) {
                        this.logger.info("Pararrel batch submit tasks:" + taskNo);
                    }
                    break block19;
                }
                if (this.isPrintTaskLog()) {
                    this.logger.info("Pararrel batch submit tasks:" + taskNo);
                }
            }
            catch (SQLException e) {
                try {
                    exception = e;
                    throw new ElasticSearchException((Throwable)e);
                    catch (ElasticSearchException e2) {
                        exception = e2;
                        throw e2;
                    }
                    catch (Exception e3) {
                        exception = e3;
                        throw new ElasticSearchException((Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    this.waitTasksComplete(tasks, service, (Exception)exception, lastValue, totalCount, tranErrorWrapper, null, reachEOFClosed);
                    totalCount.setJobEndTime(new Date());
                    throw throwable;
                }
            }
        }
        this.waitTasksComplete(tasks, service, (Exception)exception, lastValue, totalCount, tranErrorWrapper, null, reachEOFClosed);
        totalCount.setJobEndTime(new Date());
        return ret;
    }

    @Override
    public String batchExecute() {
        int count = 0;
        ArrayList<CommonRecord> datas = new ArrayList<CommonRecord>();
        String ret = null;
        int taskNo = 0;
        Throwable exception = null;
        Status currentStatus = this.currentStatus;
        Object currentValue = currentStatus != null ? currentStatus.getLastValue() : null;
        Object lastValue = null;
        long start = System.currentTimeMillis();
        long istart = 0L;
        long end = 0L;
        long totalCount = 0L;
        long ignoreTotalCount = 0L;
        SerialImportCount importCount = new SerialImportCount();
        int batchsize = this.importContext.getStoreBatchSize();
        boolean reachEOFClosed = false;
        try {
            istart = start;
            BatchContext batchContext = new BatchContext();
            while (true) {
                Boolean hasNext;
                if ((hasNext = this.jdbcResultSet.next()) == null) {
                    if (count <= 0) continue;
                    int _count = count;
                    count = 0;
                    CustomTaskCommandImpl taskCommand = new CustomTaskCommandImpl(importCount, this.importContext, this.targetImportContext, _count, taskNo, importCount.getJobNo(), lastValue, currentStatus, reachEOFClosed, this.taskContext);
                    taskCommand.setDatas((List<CommonRecord>)datas);
                    datas = new ArrayList();
                    ret = TaskCall.call(taskCommand);
                    if (this.isPrintTaskLog()) {
                        end = System.currentTimeMillis();
                        this.logger.info("Batch import Force flush datas Task[" + taskNo + "] complete,take time:" + (end - istart) + "ms" + ",import " + _count + " records.");
                        istart = end;
                    }
                    ++taskNo;
                    continue;
                }
                if (!hasNext.booleanValue()) break;
                lastValue = lastValue == null ? this.importContext.max(currentValue, this.getLastValue()) : this.importContext.max(lastValue, this.getLastValue());
                Context context = this.importContext.buildContext(this.taskContext, this.jdbcResultSet, batchContext);
                if (!reachEOFClosed) {
                    reachEOFClosed = context.reachEOFClosed();
                }
                if (context.removed()) {
                    if (!reachEOFClosed) {
                        ((ImportCount)importCount).increamentIgnoreTotalCount();
                        continue;
                    }
                    this.importContext.flushLastValue(lastValue, currentStatus, reachEOFClosed);
                    continue;
                }
                context.refactorData();
                context.afterRefactor();
                if (context.isDrop()) {
                    ((ImportCount)importCount).increamentIgnoreTotalCount();
                    continue;
                }
                CommonRecord record = this.buildRecord(context);
                datas.add(record);
                ++totalCount;
                if (++count < batchsize) continue;
                int _count = count;
                count = 0;
                CustomTaskCommandImpl taskCommand = new CustomTaskCommandImpl(importCount, this.importContext, this.targetImportContext, _count, taskNo, importCount.getJobNo(), lastValue, currentStatus, reachEOFClosed, this.taskContext);
                taskCommand.setDatas((List<CommonRecord>)datas);
                datas = new ArrayList();
                ret = TaskCall.call(taskCommand);
                if (this.isPrintTaskLog()) {
                    end = System.currentTimeMillis();
                    this.logger.info("Batch import Task[" + taskNo + "] complete,take time:" + (end - istart) + "ms" + ",import " + batchsize + " records.");
                    istart = end;
                }
                ++taskNo;
            }
            if (count > 0) {
                CustomTaskCommandImpl taskCommand = new CustomTaskCommandImpl(importCount, this.importContext, this.targetImportContext, count, taskNo, importCount.getJobNo(), lastValue, currentStatus, reachEOFClosed, this.taskContext);
                taskCommand.setDatas((List<CommonRecord>)datas);
                TaskCall.call(taskCommand);
                if (this.isPrintTaskLog()) {
                    end = System.currentTimeMillis();
                    this.logger.info("Batch import Task[" + taskNo + "] complete,take time:" + (end - istart) + "ms" + ",import " + count + " records,IgnoreTotalCount " + ignoreTotalCount + " records.");
                }
            }
            if (this.isPrintTaskLog()) {
                end = System.currentTimeMillis();
                this.logger.info("Batch import Execute Tasks:" + taskNo + ",All Take time:" + (end - start) + "ms" + ",Import total " + totalCount + " records,IgnoreTotalCount " + ignoreTotalCount + " records.");
            }
        }
        catch (SQLException e) {
            exception = e;
            throw new ElasticSearchException((Throwable)e);
        }
        catch (ElasticSearchException e) {
            exception = e;
            throw e;
        }
        catch (Exception e) {
            exception = e;
            throw new ElasticSearchException((Throwable)e);
        }
        finally {
            if (!TranErrorWrapper.assertCondition(exception, this.importContext)) {
                if (!this.importContext.getDataTranPlugin().isMultiTran()) {
                    this.stop();
                } else {
                    this.stopTranOnly();
                }
            }
            importCount.setJobEndTime(new Date());
        }
        return ret;
    }
}

