/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.es.input.db;

import com.frameworkset.common.poolman.BatchHandler;
import com.frameworkset.common.poolman.ConfigSQLExecutor;
import com.frameworkset.common.poolman.SQLExecutor;
import java.util.List;
import org.frameworkset.elasticsearch.entity.ESDatas;
import org.frameworkset.elasticsearch.scroll.HandlerInfo;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.db.DBImportContext;
import org.frameworkset.tran.es.BaseESExporterScrollHandler;
import org.frameworkset.tran.schedule.TaskContext;

public class ESDirectExporterScrollHandler<T>
extends BaseESExporterScrollHandler<T> {
    protected ConfigSQLExecutor configSQLExecutor;
    protected DBImportContext es2DBContext;
    protected TaskContext taskContext;

    public ESDirectExporterScrollHandler(TaskContext taskContext, ImportContext importContext, ImportContext targetImportContext, ConfigSQLExecutor configSQLExecutor) {
        super(importContext, targetImportContext);
        this.configSQLExecutor = configSQLExecutor;
        this.es2DBContext = (DBImportContext)targetImportContext;
        this.taskContext = taskContext;
    }

    @Override
    public void handle(ESDatas<T> response, HandlerInfo handlerInfo) throws Exception {
        String targetDBName;
        long totalSize = response.getTotalSize();
        List datas = response.getDatas();
        int batchNo = this.importContext.getExportCount().increamentCount();
        if (totalSize == 0L || datas == null || datas.size() == 0) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Igonre Execute export task {}:zero or null datas.", (Object)batchNo);
            }
            return;
        }
        int batchSize = this.importContext.getStoreBatchSize();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Execute task {} start.", (Object)batchNo);
        }
        if ((targetDBName = this.es2DBContext.getTargetDBName(this.taskContext)) == null) {
            targetDBName = this.importContext.getTargetDBName();
        }
        if (this.es2DBContext.getSql() == null) {
            this.configSQLExecutor.executeBatch(targetDBName, this.es2DBContext.getSqlName(), datas, batchSize, this.es2DBContext.getBatchHandler());
        } else {
            SQLExecutor.executeBatch((String)targetDBName, (String)this.es2DBContext.getSql(), (List)datas, (int)batchSize, (BatchHandler)this.es2DBContext.getBatchHandler());
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Execute task {} complete and export data {} record.", (Object)batchNo, (Object)datas.size());
        }
    }
}

